/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFloat;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents an entry in the list of COV references sequence of sequences in an entry of the list
 * of COV subscription specifications sequence of sequences in a BACnetCOVMultipleSubscription
 * sequence.
 *
 * @author Tim Urenda on Oct 18, 2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "monitoredProperty",
  type = "BBacnetPropertyReference",
  defaultValue = "new BBacnetPropertyReference()"
)
@NiagaraProperty(
  name = "covIncrement",
  type = "float",
  defaultValue = "BFloat.NaN"
)
@NiagaraProperty(
  name = "timestamped",
  type = "boolean",
  defaultValue = "false"
)
public class BBacnetCovMultipleSubscriptionCovReference
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetCovMultipleSubscriptionCovReference(2473470188)1.0$ @*/
/* Generated Sun Oct 27 17:29:46 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "monitoredProperty"

  /**
   * Slot for the {@code monitoredProperty} property.
   * @see #getMonitoredProperty
   * @see #setMonitoredProperty
   */
  @Generated
  public static final Property monitoredProperty = newProperty(0, new BBacnetPropertyReference(), null);

  /**
   * Get the {@code monitoredProperty} property.
   * @see #monitoredProperty
   */
  @Generated
  public BBacnetPropertyReference getMonitoredProperty() { return (BBacnetPropertyReference)get(monitoredProperty); }

  /**
   * Set the {@code monitoredProperty} property.
   * @see #monitoredProperty
   */
  @Generated
  public void setMonitoredProperty(BBacnetPropertyReference v) { set(monitoredProperty, v, null); }

  //endregion Property "monitoredProperty"

  //region Property "covIncrement"

  /**
   * Slot for the {@code covIncrement} property.
   * @see #getCovIncrement
   * @see #setCovIncrement
   */
  @Generated
  public static final Property covIncrement = newProperty(0, BFloat.NaN, null);

  /**
   * Get the {@code covIncrement} property.
   * @see #covIncrement
   */
  @Generated
  public float getCovIncrement() { return getFloat(covIncrement); }

  /**
   * Set the {@code covIncrement} property.
   * @see #covIncrement
   */
  @Generated
  public void setCovIncrement(float v) { setFloat(covIncrement, v, null); }

  //endregion Property "covIncrement"

  //region Property "timestamped"

  /**
   * Slot for the {@code timestamped} property.
   * @see #getTimestamped
   * @see #setTimestamped
   */
  @Generated
  public static final Property timestamped = newProperty(0, false, null);

  /**
   * Get the {@code timestamped} property.
   * @see #timestamped
   */
  @Generated
  public boolean getTimestamped() { return getBoolean(timestamped); }

  /**
   * Set the {@code timestamped} property.
   * @see #timestamped
   */
  @Generated
  public void setTimestamped(boolean v) { setBoolean(timestamped, v, null); }

  //endregion Property "timestamped"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetCovMultipleSubscriptionCovReference.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  private boolean isCovIncrementUsed()
  {
    return !Float.isNaN(getCovIncrement());
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    getMonitoredProperty().writeAsn(out);
    out.writeClosingTag(0);
    if (isCovIncrementUsed())
    {
      out.writeReal(1, getCovIncrement());
    }
    out.writeBoolean(2, getTimestamped());
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.skipOpeningTag(0);
    BBacnetPropertyReference monitoredProperty = new BBacnetPropertyReference();
    monitoredProperty.readAsn(in);
    in.skipClosingTag(0);

    in.peekTag();
    float covIncrement = in.isValueTag(1) ? in.readReal(1) : Float.NaN;

    boolean timestamped = in.readBoolean(2);

    set(BBacnetCovMultipleSubscriptionCovReference.monitoredProperty, monitoredProperty, noWrite);
    setFloat(BBacnetCovMultipleSubscriptionCovReference.covIncrement, covIncrement, noWrite);
    setBoolean(BBacnetCovMultipleSubscriptionCovReference.timestamped, timestamped, noWrite);
  }

  @Override
  public String toString(Context context)
  {
    StringBuilder builder = new StringBuilder(getMonitoredProperty().toString(context));
    if (isCovIncrementUsed())
    {
      builder.append(", increment: ").append(BFloat.toString(getCovIncrement(), context));
    }
    builder.append(", timestamped? ").append(getTimestamped());
    return builder.toString();
  }
}
