/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetBDTEntry sequence, which contains a bbmdAddress and an optional
 * broadcastMask. The broadcastMask shall be present if BACnet/IP and absent for BACnet/IPv6.
 *
 * @author Uday Rapuru on 10-Oct-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "bbmdAddress",
  type = "BBacnetHostNPort",
  defaultValue = "new BBacnetHostNPort()"
)
@NiagaraProperty(
  name = "broadcastMask",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
public final class BBacnetBdtEntry
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetBdtEntry(3286524618)1.0$ @*/
/* Generated Fri Oct 13 14:15:51 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "bbmdAddress"

  /**
   * Slot for the {@code bbmdAddress} property.
   * @see #getBbmdAddress
   * @see #setBbmdAddress
   */
  @Generated
  public static final Property bbmdAddress = newProperty(0, new BBacnetHostNPort(), null);

  /**
   * Get the {@code bbmdAddress} property.
   * @see #bbmdAddress
   */
  @Generated
  public BBacnetHostNPort getBbmdAddress() { return (BBacnetHostNPort)get(bbmdAddress); }

  /**
   * Set the {@code bbmdAddress} property.
   * @see #bbmdAddress
   */
  @Generated
  public void setBbmdAddress(BBacnetHostNPort v) { set(bbmdAddress, v, null); }

  //endregion Property "bbmdAddress"

  //region Property "broadcastMask"

  /**
   * Slot for the {@code broadcastMask} property.
   * @see #getBroadcastMask
   * @see #setBroadcastMask
   */
  @Generated
  public static final Property broadcastMask = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code broadcastMask} property.
   * @see #broadcastMask
   */
  @Generated
  public BBacnetOctetString getBroadcastMask() { return (BBacnetOctetString)get(broadcastMask); }

  /**
   * Set the {@code broadcastMask} property.
   * @see #broadcastMask
   */
  @Generated
  public void setBroadcastMask(BBacnetOctetString v) { set(broadcastMask, v, null); }

  //endregion Property "broadcastMask"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetBdtEntry.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.skipOpeningTag(0);
    BBacnetHostNPort bbmdAddress = new BBacnetHostNPort();
    bbmdAddress.readAsn(in);
    in.skipClosingTag(0);

    BBacnetOctetString broadcastMask = BBacnetOctetString.DEFAULT;
    in.peekTag();
    if (in.isValueTag(1))
    {
      broadcastMask = BBacnetOctetString.make(in.readOctetString(1));
    }

    set(BBacnetBdtEntry.bbmdAddress, bbmdAddress, noWrite);
    set(BBacnetBdtEntry.broadcastMask, broadcastMask, noWrite);
  }

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    getBbmdAddress().writeAsn(out);
    out.writeClosingTag(0);
    if (getBroadcastMask() != BBacnetOctetString.DEFAULT)
    {
      out.writeOctetString(1, getBroadcastMask());
    }
  }

  @Override
  public String toString(Context context)
  {
    StringBuilder builder = new StringBuilder(getBbmdAddress().toString(context))
      .append(", mask: ");
    BBacnetOctetString mask = getBroadcastMask();
    if (!mask.isNull() && mask.length() == 4)
    {
      builder.append(BBacnetAddress.bytesToString(BBacnetAddress.MAC_TYPE_IP, mask.getBytes()));
    }
    else
    {
      builder.append(mask.toString(context));
    }
    return builder.toString();
  }
}
