/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;

import com.tridium.bacnet.ObjectTypeList;
import com.tridium.bacnet.asn.AsnUtil;

/**
 * Represents the BACnetActionCommand structure
 *
 * @author Uday Rapuru on 04-Nov-2022
 * @since Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "deviceId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.DEFAULT_DEVICE",
  facets = @Facet("BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.DEVICE)")
)
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.DEFAULT"
)
@NiagaraProperty(
  name = "propertyId",
  type = "BDynamicEnum",
  defaultValue = "BDynamicEnum.make(BBacnetPropertyIdentifier.presentValue)"
)
@NiagaraProperty(
  name = "propertyArrayIndex",
  type = "int",
  defaultValue = "NOT_USED"
)
@NiagaraProperty(
  name = "propertyValue",
  type = "BValue",
  defaultValue = "BBacnetNull.DEFAULT"
)
@NiagaraProperty(
  name = "priority",
  type = "int",
  defaultValue = "0"
)
@NiagaraProperty(
  name = "postDelay",
  type = "int",
  defaultValue = "0",
  facets = @Facet(name = "BFacets.UNITS", value = "BUnit.getUnit(\"second\")")
)
@NiagaraProperty(
  name = "quitOnFailure",
  type = "boolean",
  defaultValue = "false"
)
@NiagaraProperty(
  name = "writeSuccessful",
  type = "boolean",
  defaultValue = "false"
)
public final class BBacnetActionCommand
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetActionCommand(2624654517)1.0$ @*/
/* Generated Mon Nov 21 13:41:41 CST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "deviceId"

  /**
   * Slot for the {@code deviceId} property.
   * @see #getDeviceId
   * @see #setDeviceId
   */
  @Generated
  public static final Property deviceId = newProperty(0, BBacnetObjectIdentifier.DEFAULT_DEVICE, BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.DEVICE));

  /**
   * Get the {@code deviceId} property.
   * @see #deviceId
   */
  @Generated
  public BBacnetObjectIdentifier getDeviceId() { return (BBacnetObjectIdentifier)get(deviceId); }

  /**
   * Set the {@code deviceId} property.
   * @see #deviceId
   */
  @Generated
  public void setDeviceId(BBacnetObjectIdentifier v) { set(deviceId, v, null); }

  //endregion Property "deviceId"

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(0, BBacnetObjectIdentifier.DEFAULT, null);

  /**
   * Get the {@code objectId} property.
   * @see #objectId
   */
  @Generated
  public BBacnetObjectIdentifier getObjectId() { return (BBacnetObjectIdentifier)get(objectId); }

  /**
   * Set the {@code objectId} property.
   * @see #objectId
   */
  @Generated
  public void setObjectId(BBacnetObjectIdentifier v) { set(objectId, v, null); }

  //endregion Property "objectId"

  //region Property "propertyId"

  /**
   * Slot for the {@code propertyId} property.
   * @see #getPropertyId
   * @see #setPropertyId
   */
  @Generated
  public static final Property propertyId = newProperty(0, BDynamicEnum.make(BBacnetPropertyIdentifier.presentValue), null);

  /**
   * Get the {@code propertyId} property.
   * @see #propertyId
   */
  @Generated
  public BDynamicEnum getPropertyId() { return (BDynamicEnum)get(propertyId); }

  /**
   * Set the {@code propertyId} property.
   * @see #propertyId
   */
  @Generated
  public void setPropertyId(BDynamicEnum v) { set(propertyId, v, null); }

  //endregion Property "propertyId"

  //region Property "propertyArrayIndex"

  /**
   * Slot for the {@code propertyArrayIndex} property.
   * @see #getPropertyArrayIndex
   * @see #setPropertyArrayIndex
   */
  @Generated
  public static final Property propertyArrayIndex = newProperty(0, NOT_USED, null);

  /**
   * Get the {@code propertyArrayIndex} property.
   * @see #propertyArrayIndex
   */
  @Generated
  public int getPropertyArrayIndex() { return getInt(propertyArrayIndex); }

  /**
   * Set the {@code propertyArrayIndex} property.
   * @see #propertyArrayIndex
   */
  @Generated
  public void setPropertyArrayIndex(int v) { setInt(propertyArrayIndex, v, null); }

  //endregion Property "propertyArrayIndex"

  //region Property "propertyValue"

  /**
   * Slot for the {@code propertyValue} property.
   * @see #getPropertyValue
   * @see #setPropertyValue
   */
  @Generated
  public static final Property propertyValue = newProperty(0, BBacnetNull.DEFAULT, null);

  /**
   * Get the {@code propertyValue} property.
   * @see #propertyValue
   */
  @Generated
  public BValue getPropertyValue() { return get(propertyValue); }

  /**
   * Set the {@code propertyValue} property.
   * @see #propertyValue
   */
  @Generated
  public void setPropertyValue(BValue v) { set(propertyValue, v, null); }

  //endregion Property "propertyValue"

  //region Property "priority"

  /**
   * Slot for the {@code priority} property.
   * @see #getPriority
   * @see #setPriority
   */
  @Generated
  public static final Property priority = newProperty(0, 0, null);

  /**
   * Get the {@code priority} property.
   * @see #priority
   */
  @Generated
  public int getPriority() { return getInt(priority); }

  /**
   * Set the {@code priority} property.
   * @see #priority
   */
  @Generated
  public void setPriority(int v) { setInt(priority, v, null); }

  //endregion Property "priority"

  //region Property "postDelay"

  /**
   * Slot for the {@code postDelay} property.
   * @see #getPostDelay
   * @see #setPostDelay
   */
  @Generated
  public static final Property postDelay = newProperty(0, 0, BFacets.make(BFacets.UNITS, BUnit.getUnit("second")));

  /**
   * Get the {@code postDelay} property.
   * @see #postDelay
   */
  @Generated
  public int getPostDelay() { return getInt(postDelay); }

  /**
   * Set the {@code postDelay} property.
   * @see #postDelay
   */
  @Generated
  public void setPostDelay(int v) { setInt(postDelay, v, null); }

  //endregion Property "postDelay"

  //region Property "quitOnFailure"

  /**
   * Slot for the {@code quitOnFailure} property.
   * @see #getQuitOnFailure
   * @see #setQuitOnFailure
   */
  @Generated
  public static final Property quitOnFailure = newProperty(0, false, null);

  /**
   * Get the {@code quitOnFailure} property.
   * @see #quitOnFailure
   */
  @Generated
  public boolean getQuitOnFailure() { return getBoolean(quitOnFailure); }

  /**
   * Set the {@code quitOnFailure} property.
   * @see #quitOnFailure
   */
  @Generated
  public void setQuitOnFailure(boolean v) { setBoolean(quitOnFailure, v, null); }

  //endregion Property "quitOnFailure"

  //region Property "writeSuccessful"

  /**
   * Slot for the {@code writeSuccessful} property.
   * @see #getWriteSuccessful
   * @see #setWriteSuccessful
   */
  @Generated
  public static final Property writeSuccessful = newProperty(0, false, null);

  /**
   * Get the {@code writeSuccessful} property.
   * @see #writeSuccessful
   */
  @Generated
  public boolean getWriteSuccessful() { return getBoolean(writeSuccessful); }

  /**
   * Set the {@code writeSuccessful} property.
   * @see #writeSuccessful
   */
  @Generated
  public void setWriteSuccessful(boolean v) { setBoolean(writeSuccessful, v, null); }

  //endregion Property "writeSuccessful"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetActionCommand.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void started()
    throws Exception
  {
    super.started();
    updatePropertyValueType();
  }

  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    if (!isRunning())
    {
      return;
    }

    if (property.equals(objectId) || property.equals(propertyId) || property.equals(propertyArrayIndex))
    {
      updatePropertyValueType();
    }
  }

  private void updatePropertyValueType()
  {
    PropertyInfo propertyInfo = findPropertyInfo(getObjectId(), getPropertyId().getOrdinal());
    Type newType = getPropertyType(propertyInfo);
    Type newElementType = getElementType(newType, propertyInfo);

    BValue propertyValue = getPropertyValue();
    Type oldType = propertyValue.getType();
    if (oldType.equals(newType))
    {
      // Check that the element type matches
      if (newType == BBacnetListOf.TYPE)
      {
        Type oldElementType = ((BBacnetListOf)propertyValue).getListType();
        if (oldElementType.equals(newElementType))
        {
          return;
        }
      }
      else if (newType == BBacnetArray.TYPE)
      {
        BBacnetArray oldArray = (BBacnetArray)propertyValue;
        Type oldElementType = oldArray.getArrayTypeSpec().getResolvedType();
        int newArraySize = propertyInfo.getSize();
        if (oldElementType.equals(newElementType))
        {
          if (oldArray.getFixedSize())
          {
            // oldArraySize will be greater than zero. If newArraySize is -1, the new array type
            // does not have a fixed size so the existing one must be replaced.
            if (oldArray.getSize() == newArraySize)
            {
              // Both array types have the same fixed size: leave the existing array alone.
              return;
            }
          }
          else if (newArraySize == -1)
          {
            // Both array types are not a fixed size: leave the existing array alone.
            return;
          }
        }
      }
      else
      {
        // Type.equals good enough for non-array/list types
        return;
      }
    }

    if (newType == BBacnetListOf.TYPE)
    {
      setPropertyValue(new BBacnetListOf(newElementType));
    }
    else if (newType == BBacnetArray.TYPE)
    {
      int newSize = propertyInfo.getSize();
      if (newSize != -1)
      {
        setPropertyValue(new BBacnetArray(newElementType, newSize));
      }
      else
      {
        setPropertyValue(new BBacnetArray(newElementType));
      }
    }
    else
    {
      setPropertyValue((BValue)newType.getInstance());
    }
  }

  private static PropertyInfo findPropertyInfo(BBacnetObjectIdentifier objectId, int propertyId)
  {
    return ObjectTypeList.getInstance().getPropertyInfo(objectId.getObjectType(), propertyId);
  }

  private Type getPropertyType(PropertyInfo propertyInfo)
  {
    if (propertyInfo == null)
    {
      return BComponent.TYPE;
    }
    else if (propertyInfo.isList())
    {
      return BBacnetListOf.TYPE;
    }
    else if (propertyInfo.isArray())
    {
      int index = getPropertyArrayIndex();
      if (index == 0)
      {
        return BBacnetUnsigned.TYPE;
      }
      else if (index > 0)
      {
        return Sys.getType(propertyInfo.getType());
      }
      else
      {
        return BBacnetArray.TYPE;
      }
    }
    else
    {
      return Sys.getType(propertyInfo.getType());
    }
  }

  private static Type getElementType(Type type, PropertyInfo propertyInfo)
  {
    if (type == BBacnetListOf.TYPE || type == BBacnetArray.TYPE)
    {
      return Sys.getType(propertyInfo.getType());
    }

    return null;
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetObjectIdentifier deviceId = BBacnetObjectIdentifier.DEFAULT_DEVICE;
    in.peekTag();
    if (in.isValueTag(0))
    {
      deviceId = in.readObjectIdentifier(0);
    }

    BBacnetObjectIdentifier objectId = in.readObjectIdentifier(1);
    int propertyId = in.readEnumerated(2);

    int propertyArrayIndex = -1;
    in.peekTag();
    if (in.isValueTag(3))
    {
      propertyArrayIndex = in.readUnsignedInt(3);
    }

    PropertyInfo propertyInfo = findPropertyInfo(objectId, propertyId);
    BValue propertyValue = readPropertyValue(propertyInfo, propertyArrayIndex, in);

    int priority = 0;
    in.peekTag();
    if (in.isValueTag(5))
    {
      priority = in.readUnsignedInt(5);
    }

    int postDelay = 0;
    in.peekTag();
    if (in.isValueTag(6))
    {
      postDelay = in.readUnsignedInt(6);
    }
    boolean quitOnFailure = in.readBoolean(7);
    boolean writeSuccessful = in.readBoolean(8);

    set(BBacnetActionCommand.deviceId, deviceId, noWrite);
    set(BBacnetActionCommand.objectId, objectId, noWrite);
    set(BBacnetActionCommand.propertyId, BDynamicEnum.make(propertyId, BBacnetPropertyIdentifier.DEFAULT.getRange()), noWrite);
    setInt(BBacnetActionCommand.propertyArrayIndex, propertyArrayIndex, noWrite);
    set(BBacnetActionCommand.propertyValue, propertyValue, noWrite);
    setInt(BBacnetActionCommand.priority, priority, noWrite);
    setInt(BBacnetActionCommand.postDelay, postDelay, noWrite);
    setBoolean(BBacnetActionCommand.quitOnFailure, quitOnFailure, noWrite);
    setBoolean(BBacnetActionCommand.writeSuccessful, writeSuccessful, noWrite);
  }

  private static BValue readPropertyValue(PropertyInfo propertyInfo, int propertyArrayIndex, AsnInput in)
    throws AsnException
  {
    if (propertyArrayIndex == -1)
    {
      return AsnUtil.asnToValue(propertyInfo, in.readEncodedValue(4));
    }
    else
    {
      if (!propertyInfo.isArray())
      {
        throw new AsnException("Index specified for BACnetActionCommand when property is not an array");
      }

      int size = propertyInfo.getSize();
      if (propertyArrayIndex == 0)
      {
        if (size > -1)
        {
          throw new AsnException("BACnetActionCommand index may not be zero fixed size for a fixed size array");
        }
        return AsnUtil.fromAsnUnsigned(in.readEncodedValue(4));
      }
      else
      {
        if (size > -1 && propertyArrayIndex > size)
        {
          throw new AsnException("Index specified for BACnetActionCommand exceeds array's fixed size");
        }
        BTypeSpec elementType = BTypeSpec.make(propertyInfo.getType());
        return AsnUtil.fromAsn(in.readEncodedValue(4), (BValue)elementType.getInstance());
      }
    }
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    if (isDeviceIdUsed())
    {
      out.writeObjectIdentifier(0, getDeviceId());
    }
    out.writeObjectIdentifier(1, getObjectId());
    out.writeEnumerated(2, getPropertyId());
    if (isPropertyArrayIndexUsed())
    {
      out.writeUnsignedInteger(3, getPropertyArrayIndex());
    }
    out.writeEncodedValue(4, AsnUtil.toAsn(getPropertyValue()));
    if (isPriorityUsed())
    {
      out.writeUnsignedInteger(5, getPriority());
    }
    if (isPostDelayUsed())
    {
      out.writeUnsignedInteger(6, getPostDelay());
    }
    out.writeBoolean(7, getQuitOnFailure());
    out.writeBoolean(8, getWriteSuccessful());
  }

  private boolean isDeviceIdUsed()
  {
    return !deviceId.isEquivalentToDefaultValue(getDeviceId());
  }

  private boolean isPropertyArrayIndexUsed()
  {
    return getPropertyArrayIndex() != NOT_USED;
  }

  private boolean isPriorityUsed()
  {
    return getPriority() > 0;
  }

  private boolean isPostDelayUsed()
  {
    return getPostDelay() > 0;
  }

  @Override
  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    if (isDeviceIdUsed())
    {
      sb.append(getDeviceId().toString(context)).append(' ');
    }
    sb.append(getObjectId().toString(context)).append(' ');
    sb.append(BBacnetPropertyIdentifier.tag(getPropertyId().getOrdinal()));
    if (isPropertyArrayIndexUsed())
    {
      sb.append('[').append(getPropertyArrayIndex()).append(']');
    }

    sb.append(" := ").append(getPropertyValue().toString(context));
    if (isPriorityUsed())
    {
      sb.append(" @").append(getPriority());
    }

    // Handle PropertySheet with just the top level string
    if (context != null)
    {
      return sb.toString();
    }

    if (isPostDelayUsed())
    {
      sb.append("; postDelay=").append(getPostDelay()).append('s');
    }
    sb.append("; quitOnFailure=").append(getQuitOnFailure());
    sb.append("; writeSuccessful=").append(getWriteSuccessful());
    return sb.toString();
  }
}
