/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetTimerState;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents a Bacnet Timer object type.
 *
 * @author Tim Urenda on Nov. 1, 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.UNASSIGNED_31)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.UNASSIGNED_31, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "presentValue",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
@NiagaraProperty(
  name = "timerState",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetTimerState.IDLE, BEnumRange.make(BBacnetTimerState.TYPE))",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.TIMER_STATE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "timerRunning",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.TIMER_RUNNING, ASN_BOOLEAN)")
)
public class BBacnetTimer
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetTimer(3369693775)1.0$ @*/
/* Generated Thu Nov 09 12:40:52 CST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.UNASSIGNED_31), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.UNASSIGNED_31, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "presentValue"

  /**
   * Slot for the {@code presentValue} property.
   * @see #getPresentValue
   * @see #setPresentValue
   */
  @Generated
  public static final Property presentValue = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_UNSIGNED));

  /**
   * Get the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public BBacnetUnsigned getPresentValue() { return (BBacnetUnsigned)get(presentValue); }

  /**
   * Set the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public void setPresentValue(BBacnetUnsigned v) { set(presentValue, v, null); }

  //endregion Property "presentValue"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "timerState"

  /**
   * Slot for the {@code timerState} property.
   * @see #getTimerState
   * @see #setTimerState
   */
  @Generated
  public static final Property timerState = newProperty(0, BDynamicEnum.make(BBacnetTimerState.IDLE, BEnumRange.make(BBacnetTimerState.TYPE)), makeFacets(BBacnetPropertyIdentifier.TIMER_STATE, ASN_ENUMERATED));

  /**
   * Get the {@code timerState} property.
   * @see #timerState
   */
  @Generated
  public BEnum getTimerState() { return (BEnum)get(timerState); }

  /**
   * Set the {@code timerState} property.
   * @see #timerState
   */
  @Generated
  public void setTimerState(BEnum v) { set(timerState, v, null); }

  //endregion Property "timerState"

  //region Property "timerRunning"

  /**
   * Slot for the {@code timerRunning} property.
   * @see #getTimerRunning
   * @see #setTimerRunning
   */
  @Generated
  public static final Property timerRunning = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.TIMER_RUNNING, ASN_BOOLEAN));

  /**
   * Get the {@code timerRunning} property.
   * @see #timerRunning
   */
  @Generated
  public boolean getTimerRunning() { return getBoolean(timerRunning); }

  /**
   * Set the {@code timerRunning} property.
   * @see #timerRunning
   */
  @Generated
  public void setTimerRunning(boolean v) { setBoolean(timerRunning, v, null); }

  //endregion Property "timerRunning"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetTimer.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * The present value as a Property.
   */
  @Override
  public Property getPresentValueProperty()
  {
    return presentValue;
  }

  /**
   * Returns the object ID.
   */
  @Override
  public String toString(Context context)
  {
    return getObjectId().toString(context) + " = " + getPresentValue().toString(context);
  }
}
