/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetNetworkType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetNetworkPort represents the NetworkPort config.
 *
 * @author Uday Rapuru on 12-Jul-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.NETWORK_PORT)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.NETWORK_PORT, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
@NiagaraProperty(
  name = "reliability",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetReliability.NO_FAULT_DETECTED, BEnumRange.make(BBacnetReliability.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "outOfService",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "networkType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetNetworkType.ETHERNET, BEnumRange.make(BBacnetNetworkType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.NETWORK_TYPE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "changesPending",
  type = "boolean",
  defaultValue = "false",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.CHANGES_PENDING, ASN_BOOLEAN)")
)
public class BBacnetNetworkPort
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetNetworkPort(662992958)1.0$ @*/
/* Generated Wed May 15 19:24:54 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.NETWORK_PORT), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.NETWORK_PORT, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "reliability"

  /**
   * Slot for the {@code reliability} property.
   * @see #getReliability
   * @see #setReliability
   */
  @Generated
  public static final Property reliability = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetReliability.NO_FAULT_DETECTED, BEnumRange.make(BBacnetReliability.TYPE)), makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED));

  /**
   * Get the {@code reliability} property.
   * @see #reliability
   */
  @Generated
  public BEnum getReliability() { return (BEnum)get(reliability); }

  /**
   * Set the {@code reliability} property.
   * @see #reliability
   */
  @Generated
  public void setReliability(BEnum v) { set(reliability, v, null); }

  //endregion Property "reliability"

  //region Property "outOfService"

  /**
   * Slot for the {@code outOfService} property.
   * @see #getOutOfService
   * @see #setOutOfService
   */
  @Generated
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN));

  /**
   * Get the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public boolean getOutOfService() { return getBoolean(outOfService); }

  /**
   * Set the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public void setOutOfService(boolean v) { setBoolean(outOfService, v, null); }

  //endregion Property "outOfService"

  //region Property "networkType"

  /**
   * Slot for the {@code networkType} property.
   * @see #getNetworkType
   * @see #setNetworkType
   */
  @Generated
  public static final Property networkType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetNetworkType.ETHERNET, BEnumRange.make(BBacnetNetworkType.TYPE)), makeFacets(BBacnetPropertyIdentifier.NETWORK_TYPE, ASN_ENUMERATED));

  /**
   * Get the {@code networkType} property.
   * @see #networkType
   */
  @Generated
  public BEnum getNetworkType() { return (BEnum)get(networkType); }

  /**
   * Set the {@code networkType} property.
   * @see #networkType
   */
  @Generated
  public void setNetworkType(BEnum v) { set(networkType, v, null); }

  //endregion Property "networkType"

  //region Property "changesPending"

  /**
   * Slot for the {@code changesPending} property.
   * @see #getChangesPending
   * @see #setChangesPending
   */
  @Generated
  public static final Property changesPending = newProperty(Flags.READONLY, false, makeFacets(BBacnetPropertyIdentifier.CHANGES_PENDING, ASN_BOOLEAN));

  /**
   * Get the {@code changesPending} property.
   * @see #changesPending
   */
  @Generated
  public boolean getChangesPending() { return getBoolean(changesPending); }

  /**
   * Set the {@code changesPending} property.
   * @see #changesPending
   */
  @Generated
  public void setChangesPending(boolean v) { setBoolean(changesPending, v, null); }

  //endregion Property "changesPending"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetNetworkPort.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
