/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetShedLevel;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetShedState;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BString;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetLoadControl represents the BacnetLoadControl config.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.LOAD_CONTROL)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.LOAD_CONTROL, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "presentValue",
  type = "BBacnetShedState",
  defaultValue = "BBacnetShedState.shedInactive",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
/*
 eventState indicates if this object has an active event state.
 */
@NiagaraProperty(
  name = "eventState",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetEventState.NORMAL, BEnumRange.make(BBacnetEventState.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.EVENT_STATE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "requestedShedLevel",
  type = "BBacnetShedLevel",
  defaultValue = "new BBacnetShedLevel()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.REQUESTED_SHED_LEVEL, ASN_CHOICE)")
)
@NiagaraProperty(
  name = "startTime",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.START_TIME, ASN_CONSTRUCTED_DATA)")
)
@NiagaraProperty(
  name = "shedDuration",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.SHED_DURATION, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "dutyWindow",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.DUTY_WINDOW, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "enable",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ENABLE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "expectedShedLevel",
  type = "BBacnetShedLevel",
  defaultValue = "new BBacnetShedLevel()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.EXPECTED_SHED_LEVEL, ASN_CHOICE)")
)
@NiagaraProperty(
  name = "acutalShedLevel",
  type = "BBacnetShedLevel",
  defaultValue = "new BBacnetShedLevel()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ACTUAL_SHED_LEVEL, ASN_CHOICE)")
)
@NiagaraProperty(
  name = "shedLevels",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetUnsigned.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.SHED_LEVELS, ASN_BACNET_ARRAY)")
)
@NiagaraProperty(
  name = "shedLevelDescriptions",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BString.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.SHED_LEVEL_DESCRIPTIONS, ASN_BACNET_ARRAY)")
)
public class BBacnetLoadControl
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetLoadControl(1597220814)1.0$ @*/
/* Generated Fri Jul 14 15:18:07 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.LOAD_CONTROL), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.LOAD_CONTROL, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "presentValue"

  /**
   * Slot for the {@code presentValue} property.
   * @see #getPresentValue
   * @see #setPresentValue
   */
  @Generated
  public static final Property presentValue = newProperty(0, BBacnetShedState.shedInactive, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_ENUMERATED));

  /**
   * Get the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public BBacnetShedState getPresentValue() { return (BBacnetShedState)get(presentValue); }

  /**
   * Set the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public void setPresentValue(BBacnetShedState v) { set(presentValue, v, null); }

  //endregion Property "presentValue"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "eventState"

  /**
   * Slot for the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #getEventState
   * @see #setEventState
   */
  @Generated
  public static final Property eventState = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetEventState.NORMAL, BEnumRange.make(BBacnetEventState.TYPE)), makeFacets(BBacnetPropertyIdentifier.EVENT_STATE, ASN_ENUMERATED));

  /**
   * Get the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  @Generated
  public BEnum getEventState() { return (BEnum)get(eventState); }

  /**
   * Set the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  @Generated
  public void setEventState(BEnum v) { set(eventState, v, null); }

  //endregion Property "eventState"

  //region Property "requestedShedLevel"

  /**
   * Slot for the {@code requestedShedLevel} property.
   * @see #getRequestedShedLevel
   * @see #setRequestedShedLevel
   */
  @Generated
  public static final Property requestedShedLevel = newProperty(0, new BBacnetShedLevel(), makeFacets(BBacnetPropertyIdentifier.REQUESTED_SHED_LEVEL, ASN_CHOICE));

  /**
   * Get the {@code requestedShedLevel} property.
   * @see #requestedShedLevel
   */
  @Generated
  public BBacnetShedLevel getRequestedShedLevel() { return (BBacnetShedLevel)get(requestedShedLevel); }

  /**
   * Set the {@code requestedShedLevel} property.
   * @see #requestedShedLevel
   */
  @Generated
  public void setRequestedShedLevel(BBacnetShedLevel v) { set(requestedShedLevel, v, null); }

  //endregion Property "requestedShedLevel"

  //region Property "startTime"

  /**
   * Slot for the {@code startTime} property.
   * @see #getStartTime
   * @see #setStartTime
   */
  @Generated
  public static final Property startTime = newProperty(0, new BBacnetDateTime(), makeFacets(BBacnetPropertyIdentifier.START_TIME, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code startTime} property.
   * @see #startTime
   */
  @Generated
  public BBacnetDateTime getStartTime() { return (BBacnetDateTime)get(startTime); }

  /**
   * Set the {@code startTime} property.
   * @see #startTime
   */
  @Generated
  public void setStartTime(BBacnetDateTime v) { set(startTime, v, null); }

  //endregion Property "startTime"

  //region Property "shedDuration"

  /**
   * Slot for the {@code shedDuration} property.
   * @see #getShedDuration
   * @see #setShedDuration
   */
  @Generated
  public static final Property shedDuration = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.SHED_DURATION, ASN_UNSIGNED));

  /**
   * Get the {@code shedDuration} property.
   * @see #shedDuration
   */
  @Generated
  public BBacnetUnsigned getShedDuration() { return (BBacnetUnsigned)get(shedDuration); }

  /**
   * Set the {@code shedDuration} property.
   * @see #shedDuration
   */
  @Generated
  public void setShedDuration(BBacnetUnsigned v) { set(shedDuration, v, null); }

  //endregion Property "shedDuration"

  //region Property "dutyWindow"

  /**
   * Slot for the {@code dutyWindow} property.
   * @see #getDutyWindow
   * @see #setDutyWindow
   */
  @Generated
  public static final Property dutyWindow = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.DUTY_WINDOW, ASN_UNSIGNED));

  /**
   * Get the {@code dutyWindow} property.
   * @see #dutyWindow
   */
  @Generated
  public BBacnetUnsigned getDutyWindow() { return (BBacnetUnsigned)get(dutyWindow); }

  /**
   * Set the {@code dutyWindow} property.
   * @see #dutyWindow
   */
  @Generated
  public void setDutyWindow(BBacnetUnsigned v) { set(dutyWindow, v, null); }

  //endregion Property "dutyWindow"

  //region Property "enable"

  /**
   * Slot for the {@code enable} property.
   * @see #getEnable
   * @see #setEnable
   */
  @Generated
  public static final Property enable = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.ENABLE, ASN_BOOLEAN));

  /**
   * Get the {@code enable} property.
   * @see #enable
   */
  @Generated
  public boolean getEnable() { return getBoolean(enable); }

  /**
   * Set the {@code enable} property.
   * @see #enable
   */
  @Generated
  public void setEnable(boolean v) { setBoolean(enable, v, null); }

  //endregion Property "enable"

  //region Property "expectedShedLevel"

  /**
   * Slot for the {@code expectedShedLevel} property.
   * @see #getExpectedShedLevel
   * @see #setExpectedShedLevel
   */
  @Generated
  public static final Property expectedShedLevel = newProperty(0, new BBacnetShedLevel(), makeFacets(BBacnetPropertyIdentifier.EXPECTED_SHED_LEVEL, ASN_CHOICE));

  /**
   * Get the {@code expectedShedLevel} property.
   * @see #expectedShedLevel
   */
  @Generated
  public BBacnetShedLevel getExpectedShedLevel() { return (BBacnetShedLevel)get(expectedShedLevel); }

  /**
   * Set the {@code expectedShedLevel} property.
   * @see #expectedShedLevel
   */
  @Generated
  public void setExpectedShedLevel(BBacnetShedLevel v) { set(expectedShedLevel, v, null); }

  //endregion Property "expectedShedLevel"

  //region Property "acutalShedLevel"

  /**
   * Slot for the {@code acutalShedLevel} property.
   * @see #getAcutalShedLevel
   * @see #setAcutalShedLevel
   */
  @Generated
  public static final Property acutalShedLevel = newProperty(0, new BBacnetShedLevel(), makeFacets(BBacnetPropertyIdentifier.ACTUAL_SHED_LEVEL, ASN_CHOICE));

  /**
   * Get the {@code acutalShedLevel} property.
   * @see #acutalShedLevel
   */
  @Generated
  public BBacnetShedLevel getAcutalShedLevel() { return (BBacnetShedLevel)get(acutalShedLevel); }

  /**
   * Set the {@code acutalShedLevel} property.
   * @see #acutalShedLevel
   */
  @Generated
  public void setAcutalShedLevel(BBacnetShedLevel v) { set(acutalShedLevel, v, null); }

  //endregion Property "acutalShedLevel"

  //region Property "shedLevels"

  /**
   * Slot for the {@code shedLevels} property.
   * @see #getShedLevels
   * @see #setShedLevels
   */
  @Generated
  public static final Property shedLevels = newProperty(0, new BBacnetArray(BBacnetUnsigned.TYPE), makeFacets(BBacnetPropertyIdentifier.SHED_LEVELS, ASN_BACNET_ARRAY));

  /**
   * Get the {@code shedLevels} property.
   * @see #shedLevels
   */
  @Generated
  public BBacnetArray getShedLevels() { return (BBacnetArray)get(shedLevels); }

  /**
   * Set the {@code shedLevels} property.
   * @see #shedLevels
   */
  @Generated
  public void setShedLevels(BBacnetArray v) { set(shedLevels, v, null); }

  //endregion Property "shedLevels"

  //region Property "shedLevelDescriptions"

  /**
   * Slot for the {@code shedLevelDescriptions} property.
   * @see #getShedLevelDescriptions
   * @see #setShedLevelDescriptions
   */
  @Generated
  public static final Property shedLevelDescriptions = newProperty(0, new BBacnetArray(BString.TYPE), makeFacets(BBacnetPropertyIdentifier.SHED_LEVEL_DESCRIPTIONS, ASN_BACNET_ARRAY));

  /**
   * Get the {@code shedLevelDescriptions} property.
   * @see #shedLevelDescriptions
   */
  @Generated
  public BBacnetArray getShedLevelDescriptions() { return (BBacnetArray)get(shedLevelDescriptions); }

  /**
   * Set the {@code shedLevelDescriptions} property.
   * @see #shedLevelDescriptions
   */
  @Generated
  public void setShedLevelDescriptions(BBacnetArray v) { set(shedLevelDescriptions, v, null); }

  //endregion Property "shedLevelDescriptions"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetLoadControl.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
