/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.access.BBacnetDoorStatus;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarDirection;
import javax.baja.bacnet.enums.elevator.BBacnetLiftFault;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents a Lift object.
 *
 * @author Tim Urenda on Oct 1, 2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.LIFT)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.LIFT, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
@NiagaraProperty(
  name = "elevatorGroup",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ELEVATOR_GROUP)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ELEVATOR_GROUP, ASN_OBJECT_IDENTIFIER)")
)
@NiagaraProperty(
  name = "groupId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.GROUP_ID, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "installationId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.INSTALLATION_ID, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "carPosition",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.CAR_POSITION, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "carMovingDirection",
  type = "BBacnetLiftCarDirection",
  defaultValue = "BBacnetLiftCarDirection.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.CAR_MOVING_DIRECTION, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "carDoorStatus",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetDoorStatus.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.CAR_DOOR_STATUS, ASN_BACNET_ARRAY)")
)
@NiagaraProperty(
  name = "passengerAlarm",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PASSENGER_ALARM, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "outOfService",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "faultSignals",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetLiftFault.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.FAULT_SIGNALS, ASN_CONSTRUCTED_DATA)")
)
public class BBacnetLift
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetLift(1370709328)1.0$ @*/
/* Generated Fri Oct 04 12:32:40 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.LIFT), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.LIFT, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "elevatorGroup"

  /**
   * Slot for the {@code elevatorGroup} property.
   * @see #getElevatorGroup
   * @see #setElevatorGroup
   */
  @Generated
  public static final Property elevatorGroup = newProperty(0, BBacnetObjectIdentifier.make(BBacnetObjectType.ELEVATOR_GROUP), makeFacets(BBacnetPropertyIdentifier.ELEVATOR_GROUP, ASN_OBJECT_IDENTIFIER));

  /**
   * Get the {@code elevatorGroup} property.
   * @see #elevatorGroup
   */
  @Generated
  public BBacnetObjectIdentifier getElevatorGroup() { return (BBacnetObjectIdentifier)get(elevatorGroup); }

  /**
   * Set the {@code elevatorGroup} property.
   * @see #elevatorGroup
   */
  @Generated
  public void setElevatorGroup(BBacnetObjectIdentifier v) { set(elevatorGroup, v, null); }

  //endregion Property "elevatorGroup"

  //region Property "groupId"

  /**
   * Slot for the {@code groupId} property.
   * @see #getGroupId
   * @see #setGroupId
   */
  @Generated
  public static final Property groupId = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.GROUP_ID, ASN_UNSIGNED));

  /**
   * Get the {@code groupId} property.
   * @see #groupId
   */
  @Generated
  public BBacnetUnsigned getGroupId() { return (BBacnetUnsigned)get(groupId); }

  /**
   * Set the {@code groupId} property.
   * @see #groupId
   */
  @Generated
  public void setGroupId(BBacnetUnsigned v) { set(groupId, v, null); }

  //endregion Property "groupId"

  //region Property "installationId"

  /**
   * Slot for the {@code installationId} property.
   * @see #getInstallationId
   * @see #setInstallationId
   */
  @Generated
  public static final Property installationId = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.INSTALLATION_ID, ASN_UNSIGNED));

  /**
   * Get the {@code installationId} property.
   * @see #installationId
   */
  @Generated
  public BBacnetUnsigned getInstallationId() { return (BBacnetUnsigned)get(installationId); }

  /**
   * Set the {@code installationId} property.
   * @see #installationId
   */
  @Generated
  public void setInstallationId(BBacnetUnsigned v) { set(installationId, v, null); }

  //endregion Property "installationId"

  //region Property "carPosition"

  /**
   * Slot for the {@code carPosition} property.
   * @see #getCarPosition
   * @see #setCarPosition
   */
  @Generated
  public static final Property carPosition = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.CAR_POSITION, ASN_UNSIGNED));

  /**
   * Get the {@code carPosition} property.
   * @see #carPosition
   */
  @Generated
  public BBacnetUnsigned getCarPosition() { return (BBacnetUnsigned)get(carPosition); }

  /**
   * Set the {@code carPosition} property.
   * @see #carPosition
   */
  @Generated
  public void setCarPosition(BBacnetUnsigned v) { set(carPosition, v, null); }

  //endregion Property "carPosition"

  //region Property "carMovingDirection"

  /**
   * Slot for the {@code carMovingDirection} property.
   * @see #getCarMovingDirection
   * @see #setCarMovingDirection
   */
  @Generated
  public static final Property carMovingDirection = newProperty(0, BBacnetLiftCarDirection.DEFAULT, makeFacets(BBacnetPropertyIdentifier.CAR_MOVING_DIRECTION, ASN_ENUMERATED));

  /**
   * Get the {@code carMovingDirection} property.
   * @see #carMovingDirection
   */
  @Generated
  public BBacnetLiftCarDirection getCarMovingDirection() { return (BBacnetLiftCarDirection)get(carMovingDirection); }

  /**
   * Set the {@code carMovingDirection} property.
   * @see #carMovingDirection
   */
  @Generated
  public void setCarMovingDirection(BBacnetLiftCarDirection v) { set(carMovingDirection, v, null); }

  //endregion Property "carMovingDirection"

  //region Property "carDoorStatus"

  /**
   * Slot for the {@code carDoorStatus} property.
   * @see #getCarDoorStatus
   * @see #setCarDoorStatus
   */
  @Generated
  public static final Property carDoorStatus = newProperty(0, new BBacnetArray(BBacnetDoorStatus.TYPE), makeFacets(BBacnetPropertyIdentifier.CAR_DOOR_STATUS, ASN_BACNET_ARRAY));

  /**
   * Get the {@code carDoorStatus} property.
   * @see #carDoorStatus
   */
  @Generated
  public BBacnetArray getCarDoorStatus() { return (BBacnetArray)get(carDoorStatus); }

  /**
   * Set the {@code carDoorStatus} property.
   * @see #carDoorStatus
   */
  @Generated
  public void setCarDoorStatus(BBacnetArray v) { set(carDoorStatus, v, null); }

  //endregion Property "carDoorStatus"

  //region Property "passengerAlarm"

  /**
   * Slot for the {@code passengerAlarm} property.
   * @see #getPassengerAlarm
   * @see #setPassengerAlarm
   */
  @Generated
  public static final Property passengerAlarm = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.PASSENGER_ALARM, ASN_BOOLEAN));

  /**
   * Get the {@code passengerAlarm} property.
   * @see #passengerAlarm
   */
  @Generated
  public boolean getPassengerAlarm() { return getBoolean(passengerAlarm); }

  /**
   * Set the {@code passengerAlarm} property.
   * @see #passengerAlarm
   */
  @Generated
  public void setPassengerAlarm(boolean v) { setBoolean(passengerAlarm, v, null); }

  //endregion Property "passengerAlarm"

  //region Property "outOfService"

  /**
   * Slot for the {@code outOfService} property.
   * @see #getOutOfService
   * @see #setOutOfService
   */
  @Generated
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN));

  /**
   * Get the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public boolean getOutOfService() { return getBoolean(outOfService); }

  /**
   * Set the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public void setOutOfService(boolean v) { setBoolean(outOfService, v, null); }

  //endregion Property "outOfService"

  //region Property "faultSignals"

  /**
   * Slot for the {@code faultSignals} property.
   * @see #getFaultSignals
   * @see #setFaultSignals
   */
  @Generated
  public static final Property faultSignals = newProperty(0, new BBacnetArray(BBacnetLiftFault.TYPE), makeFacets(BBacnetPropertyIdentifier.FAULT_SIGNALS, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code faultSignals} property.
   * @see #faultSignals
   */
  @Generated
  public BBacnetArray getFaultSignals() { return (BBacnetArray)get(faultSignals); }

  /**
   * Set the {@code faultSignals} property.
   * @see #faultSignals
   */
  @Generated
  public void setFaultSignals(BBacnetArray v) { set(faultSignals, v, null); }

  //endregion Property "faultSignals"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetLift.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetLift()
  {
  }
}
