/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bacnet.config;


import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.elevator.BBacnetEscalatorOperationDirection;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents an Escalator object.
 *
 * @author Tim Urenda on Oct 1, 2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ESCALATOR)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.ESCALATOR, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
@NiagaraProperty(
  name = "elevatorGroup",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ELEVATOR_GROUP)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ELEVATOR_GROUP, ASN_OBJECT_IDENTIFIER)")
)
@NiagaraProperty(
  name = "groupId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.GROUP_ID, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "installationId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.INSTALLATION_ID, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "operationDirection",
  type = "BBacnetEscalatorOperationDirection",
  defaultValue = "BBacnetEscalatorOperationDirection.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OPERATION_DIRECTION, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "outOfService",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "passengerAlarm",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PASSENGER_ALARM, ASN_BOOLEAN)")
)
public class BBacnetEscalator
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetEscalator(3701554167)1.0$ @*/
/* Generated Fri Oct 04 12:35:20 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.ESCALATOR), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.ESCALATOR, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "elevatorGroup"

  /**
   * Slot for the {@code elevatorGroup} property.
   * @see #getElevatorGroup
   * @see #setElevatorGroup
   */
  @Generated
  public static final Property elevatorGroup = newProperty(0, BBacnetObjectIdentifier.make(BBacnetObjectType.ELEVATOR_GROUP), makeFacets(BBacnetPropertyIdentifier.ELEVATOR_GROUP, ASN_OBJECT_IDENTIFIER));

  /**
   * Get the {@code elevatorGroup} property.
   * @see #elevatorGroup
   */
  @Generated
  public BBacnetObjectIdentifier getElevatorGroup() { return (BBacnetObjectIdentifier)get(elevatorGroup); }

  /**
   * Set the {@code elevatorGroup} property.
   * @see #elevatorGroup
   */
  @Generated
  public void setElevatorGroup(BBacnetObjectIdentifier v) { set(elevatorGroup, v, null); }

  //endregion Property "elevatorGroup"

  //region Property "groupId"

  /**
   * Slot for the {@code groupId} property.
   * @see #getGroupId
   * @see #setGroupId
   */
  @Generated
  public static final Property groupId = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.GROUP_ID, ASN_UNSIGNED));

  /**
   * Get the {@code groupId} property.
   * @see #groupId
   */
  @Generated
  public BBacnetUnsigned getGroupId() { return (BBacnetUnsigned)get(groupId); }

  /**
   * Set the {@code groupId} property.
   * @see #groupId
   */
  @Generated
  public void setGroupId(BBacnetUnsigned v) { set(groupId, v, null); }

  //endregion Property "groupId"

  //region Property "installationId"

  /**
   * Slot for the {@code installationId} property.
   * @see #getInstallationId
   * @see #setInstallationId
   */
  @Generated
  public static final Property installationId = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.INSTALLATION_ID, ASN_UNSIGNED));

  /**
   * Get the {@code installationId} property.
   * @see #installationId
   */
  @Generated
  public BBacnetUnsigned getInstallationId() { return (BBacnetUnsigned)get(installationId); }

  /**
   * Set the {@code installationId} property.
   * @see #installationId
   */
  @Generated
  public void setInstallationId(BBacnetUnsigned v) { set(installationId, v, null); }

  //endregion Property "installationId"

  //region Property "operationDirection"

  /**
   * Slot for the {@code operationDirection} property.
   * @see #getOperationDirection
   * @see #setOperationDirection
   */
  @Generated
  public static final Property operationDirection = newProperty(0, BBacnetEscalatorOperationDirection.DEFAULT, makeFacets(BBacnetPropertyIdentifier.OPERATION_DIRECTION, ASN_ENUMERATED));

  /**
   * Get the {@code operationDirection} property.
   * @see #operationDirection
   */
  @Generated
  public BBacnetEscalatorOperationDirection getOperationDirection() { return (BBacnetEscalatorOperationDirection)get(operationDirection); }

  /**
   * Set the {@code operationDirection} property.
   * @see #operationDirection
   */
  @Generated
  public void setOperationDirection(BBacnetEscalatorOperationDirection v) { set(operationDirection, v, null); }

  //endregion Property "operationDirection"

  //region Property "outOfService"

  /**
   * Slot for the {@code outOfService} property.
   * @see #getOutOfService
   * @see #setOutOfService
   */
  @Generated
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN));

  /**
   * Get the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public boolean getOutOfService() { return getBoolean(outOfService); }

  /**
   * Set the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public void setOutOfService(boolean v) { setBoolean(outOfService, v, null); }

  //endregion Property "outOfService"

  //region Property "passengerAlarm"

  /**
   * Slot for the {@code passengerAlarm} property.
   * @see #getPassengerAlarm
   * @see #setPassengerAlarm
   */
  @Generated
  public static final Property passengerAlarm = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.PASSENGER_ALARM, ASN_BOOLEAN));

  /**
   * Get the {@code passengerAlarm} property.
   * @see #passengerAlarm
   */
  @Generated
  public boolean getPassengerAlarm() { return getBoolean(passengerAlarm); }

  /**
   * Set the {@code passengerAlarm} property.
   * @see #passengerAlarm
   */
  @Generated
  public void setPassengerAlarm(boolean v) { setBoolean(passengerAlarm, v, null); }

  //endregion Property "passengerAlarm"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetEscalator.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetEscalator()
  {
  }
}
