/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents an Elevator Group object.
 *
 * @author Tim Urenda on Oct 1, 2024
 * @since Niagara 4.15
 */

@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ELEVATOR_GROUP)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.ELEVATOR_GROUP, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "machineRoomId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.POSITIVE_INTEGER_VALUE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.MACHINE_ROOM_ID, ASN_OBJECT_IDENTIFIER)")
)
@NiagaraProperty(
  name = "groupId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.GROUP_ID, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "groupMembers",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetObjectIdentifier.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.GROUP_MEMBERS, ASN_BACNET_ARRAY)")
)
public class BBacnetElevatorGroup
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetElevatorGroup(1646854195)1.0$ @*/
/* Generated Fri Oct 04 12:24:31 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.ELEVATOR_GROUP), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.ELEVATOR_GROUP, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "machineRoomId"

  /**
   * Slot for the {@code machineRoomId} property.
   * @see #getMachineRoomId
   * @see #setMachineRoomId
   */
  @Generated
  public static final Property machineRoomId = newProperty(0, BBacnetObjectIdentifier.make(BBacnetObjectType.POSITIVE_INTEGER_VALUE), makeFacets(BBacnetPropertyIdentifier.MACHINE_ROOM_ID, ASN_OBJECT_IDENTIFIER));

  /**
   * Get the {@code machineRoomId} property.
   * @see #machineRoomId
   */
  @Generated
  public BBacnetObjectIdentifier getMachineRoomId() { return (BBacnetObjectIdentifier)get(machineRoomId); }

  /**
   * Set the {@code machineRoomId} property.
   * @see #machineRoomId
   */
  @Generated
  public void setMachineRoomId(BBacnetObjectIdentifier v) { set(machineRoomId, v, null); }

  //endregion Property "machineRoomId"

  //region Property "groupId"

  /**
   * Slot for the {@code groupId} property.
   * @see #getGroupId
   * @see #setGroupId
   */
  @Generated
  public static final Property groupId = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.GROUP_ID, ASN_UNSIGNED));

  /**
   * Get the {@code groupId} property.
   * @see #groupId
   */
  @Generated
  public BBacnetUnsigned getGroupId() { return (BBacnetUnsigned)get(groupId); }

  /**
   * Set the {@code groupId} property.
   * @see #groupId
   */
  @Generated
  public void setGroupId(BBacnetUnsigned v) { set(groupId, v, null); }

  //endregion Property "groupId"

  //region Property "groupMembers"

  /**
   * Slot for the {@code groupMembers} property.
   * @see #getGroupMembers
   * @see #setGroupMembers
   */
  @Generated
  public static final Property groupMembers = newProperty(0, new BBacnetArray(BBacnetObjectIdentifier.TYPE), makeFacets(BBacnetPropertyIdentifier.GROUP_MEMBERS, ASN_BACNET_ARRAY));

  /**
   * Get the {@code groupMembers} property.
   * @see #groupMembers
   */
  @Generated
  public BBacnetArray getGroupMembers() { return (BBacnetArray)get(groupMembers); }

  /**
   * Set the {@code groupMembers} property.
   * @see #groupMembers
   */
  @Generated
  public void setGroupMembers(BBacnetArray v) { set(groupMembers, v, null); }

  //endregion Property "groupMembers"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetElevatorGroup.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetElevatorGroup()
  {
  }
}
