/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.datatypes.access.BBacnetAssignedAccessRights;
import javax.baja.bacnet.datatypes.access.BBacnetCredentialAuthenticationFactor;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisableReason;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents a Bacnet Access Credential object type. This object represents credentials in a remote
 * BACnet device who is responsible for protecting their credentials.
 *
 * @author Tim Urenda on Nov. 20, 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ACCESS_CREDENTIAL)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.ACCESS_CREDENTIAL, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "globalIdentifier",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.GLOBAL_IDENTIFIER, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
@NiagaraProperty(
  name = "reliability",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetReliability.NO_FAULT_DETECTED, BEnumRange.make(BBacnetReliability.TYPE))",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "credentialStatus",
  type = "BBacnetBinaryPv",
  defaultValue = "BBacnetBinaryPv.inactive",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.CREDENTIAL_STATUS, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "reasonForDisable",
  type = "BBacnetListOf",
  defaultValue = "new BBacnetListOf(BBacnetAccessCredentialDisableReason.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.REASON_FOR_DISABLE, ASN_BACNET_LIST)")
)
@NiagaraProperty(
  name = "authenticationFactors",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetCredentialAuthenticationFactor.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.AUTHENTICATION_FACTORS, ASN_BACNET_ARRAY)")
)
@NiagaraProperty(
  name = "activationTime",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ACTIVATION_TIME, ASN_CONSTRUCTED_DATA)")
)
@NiagaraProperty(
  name = "expirationTime",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.EXPIRY_TIME, ASN_CONSTRUCTED_DATA)")
)
@NiagaraProperty(
  name = "credentialDisable",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetAccessCredentialDisable.NONE, BEnumRange.make(BBacnetAccessCredentialDisable.TYPE))",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.CREDENTIAL_DISABLE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "assignedAccessRights",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetAssignedAccessRights.TYPE)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ASSIGNED_ACCESS_RIGHTS, ASN_BACNET_ARRAY)")
)

public class BBacnetAccessCredential
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetAccessCredential(3408586792)1.0$ @*/
/* Generated Thu Dec 14 13:54:06 CST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.ACCESS_CREDENTIAL), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.ACCESS_CREDENTIAL, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "globalIdentifier"

  /**
   * Slot for the {@code globalIdentifier} property.
   * @see #getGlobalIdentifier
   * @see #setGlobalIdentifier
   */
  @Generated
  public static final Property globalIdentifier = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.GLOBAL_IDENTIFIER, ASN_UNSIGNED));

  /**
   * Get the {@code globalIdentifier} property.
   * @see #globalIdentifier
   */
  @Generated
  public BBacnetUnsigned getGlobalIdentifier() { return (BBacnetUnsigned)get(globalIdentifier); }

  /**
   * Set the {@code globalIdentifier} property.
   * @see #globalIdentifier
   */
  @Generated
  public void setGlobalIdentifier(BBacnetUnsigned v) { set(globalIdentifier, v, null); }

  //endregion Property "globalIdentifier"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "reliability"

  /**
   * Slot for the {@code reliability} property.
   * @see #getReliability
   * @see #setReliability
   */
  @Generated
  public static final Property reliability = newProperty(0, BDynamicEnum.make(BBacnetReliability.NO_FAULT_DETECTED, BEnumRange.make(BBacnetReliability.TYPE)), makeFacets(BBacnetPropertyIdentifier.RELIABILITY, ASN_ENUMERATED));

  /**
   * Get the {@code reliability} property.
   * @see #reliability
   */
  @Generated
  public BEnum getReliability() { return (BEnum)get(reliability); }

  /**
   * Set the {@code reliability} property.
   * @see #reliability
   */
  @Generated
  public void setReliability(BEnum v) { set(reliability, v, null); }

  //endregion Property "reliability"

  //region Property "credentialStatus"

  /**
   * Slot for the {@code credentialStatus} property.
   * @see #getCredentialStatus
   * @see #setCredentialStatus
   */
  @Generated
  public static final Property credentialStatus = newProperty(0, BBacnetBinaryPv.inactive, makeFacets(BBacnetPropertyIdentifier.CREDENTIAL_STATUS, ASN_ENUMERATED));

  /**
   * Get the {@code credentialStatus} property.
   * @see #credentialStatus
   */
  @Generated
  public BBacnetBinaryPv getCredentialStatus() { return (BBacnetBinaryPv)get(credentialStatus); }

  /**
   * Set the {@code credentialStatus} property.
   * @see #credentialStatus
   */
  @Generated
  public void setCredentialStatus(BBacnetBinaryPv v) { set(credentialStatus, v, null); }

  //endregion Property "credentialStatus"

  //region Property "reasonForDisable"

  /**
   * Slot for the {@code reasonForDisable} property.
   * @see #getReasonForDisable
   * @see #setReasonForDisable
   */
  @Generated
  public static final Property reasonForDisable = newProperty(0, new BBacnetListOf(BBacnetAccessCredentialDisableReason.TYPE), makeFacets(BBacnetPropertyIdentifier.REASON_FOR_DISABLE, ASN_BACNET_LIST));

  /**
   * Get the {@code reasonForDisable} property.
   * @see #reasonForDisable
   */
  @Generated
  public BBacnetListOf getReasonForDisable() { return (BBacnetListOf)get(reasonForDisable); }

  /**
   * Set the {@code reasonForDisable} property.
   * @see #reasonForDisable
   */
  @Generated
  public void setReasonForDisable(BBacnetListOf v) { set(reasonForDisable, v, null); }

  //endregion Property "reasonForDisable"

  //region Property "authenticationFactors"

  /**
   * Slot for the {@code authenticationFactors} property.
   * @see #getAuthenticationFactors
   * @see #setAuthenticationFactors
   */
  @Generated
  public static final Property authenticationFactors = newProperty(0, new BBacnetArray(BBacnetCredentialAuthenticationFactor.TYPE), makeFacets(BBacnetPropertyIdentifier.AUTHENTICATION_FACTORS, ASN_BACNET_ARRAY));

  /**
   * Get the {@code authenticationFactors} property.
   * @see #authenticationFactors
   */
  @Generated
  public BBacnetArray getAuthenticationFactors() { return (BBacnetArray)get(authenticationFactors); }

  /**
   * Set the {@code authenticationFactors} property.
   * @see #authenticationFactors
   */
  @Generated
  public void setAuthenticationFactors(BBacnetArray v) { set(authenticationFactors, v, null); }

  //endregion Property "authenticationFactors"

  //region Property "activationTime"

  /**
   * Slot for the {@code activationTime} property.
   * @see #getActivationTime
   * @see #setActivationTime
   */
  @Generated
  public static final Property activationTime = newProperty(0, new BBacnetDateTime(), makeFacets(BBacnetPropertyIdentifier.ACTIVATION_TIME, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code activationTime} property.
   * @see #activationTime
   */
  @Generated
  public BBacnetDateTime getActivationTime() { return (BBacnetDateTime)get(activationTime); }

  /**
   * Set the {@code activationTime} property.
   * @see #activationTime
   */
  @Generated
  public void setActivationTime(BBacnetDateTime v) { set(activationTime, v, null); }

  //endregion Property "activationTime"

  //region Property "expirationTime"

  /**
   * Slot for the {@code expirationTime} property.
   * @see #getExpirationTime
   * @see #setExpirationTime
   */
  @Generated
  public static final Property expirationTime = newProperty(0, new BBacnetDateTime(), makeFacets(BBacnetPropertyIdentifier.EXPIRY_TIME, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code expirationTime} property.
   * @see #expirationTime
   */
  @Generated
  public BBacnetDateTime getExpirationTime() { return (BBacnetDateTime)get(expirationTime); }

  /**
   * Set the {@code expirationTime} property.
   * @see #expirationTime
   */
  @Generated
  public void setExpirationTime(BBacnetDateTime v) { set(expirationTime, v, null); }

  //endregion Property "expirationTime"

  //region Property "credentialDisable"

  /**
   * Slot for the {@code credentialDisable} property.
   * @see #getCredentialDisable
   * @see #setCredentialDisable
   */
  @Generated
  public static final Property credentialDisable = newProperty(0, BDynamicEnum.make(BBacnetAccessCredentialDisable.NONE, BEnumRange.make(BBacnetAccessCredentialDisable.TYPE)), makeFacets(BBacnetPropertyIdentifier.CREDENTIAL_DISABLE, ASN_ENUMERATED));

  /**
   * Get the {@code credentialDisable} property.
   * @see #credentialDisable
   */
  @Generated
  public BEnum getCredentialDisable() { return (BEnum)get(credentialDisable); }

  /**
   * Set the {@code credentialDisable} property.
   * @see #credentialDisable
   */
  @Generated
  public void setCredentialDisable(BEnum v) { set(credentialDisable, v, null); }

  //endregion Property "credentialDisable"

  //region Property "assignedAccessRights"

  /**
   * Slot for the {@code assignedAccessRights} property.
   * @see #getAssignedAccessRights
   * @see #setAssignedAccessRights
   */
  @Generated
  public static final Property assignedAccessRights = newProperty(0, new BBacnetArray(BBacnetAssignedAccessRights.TYPE), makeFacets(BBacnetPropertyIdentifier.ASSIGNED_ACCESS_RIGHTS, ASN_BACNET_ARRAY));

  /**
   * Get the {@code assignedAccessRights} property.
   * @see #assignedAccessRights
   */
  @Generated
  public BBacnetArray getAssignedAccessRights() { return (BBacnetArray)get(assignedAccessRights); }

  /**
   * Set the {@code assignedAccessRights} property.
   * @see #assignedAccessRights
   */
  @Generated
  public void setAssignedAccessRights(BBacnetArray v) { set(assignedAccessRights, v, null); }

  //endregion Property "assignedAccessRights"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetAccessCredential.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
