function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Cody Short
 */

/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/live/VideoTimestampWidget
 */
define(['baja!', 'lex!videoDriver', 'bajaux/Widget', 'bajaux/mixin/mixinUtils', 'Promise', 'nmodule/videoDriver/rc/live/VideoFeedMixin'], function (baja, lexs, Widget, mixinUtils, Promise, VideoFeedMixin) {
  'use strict';

  var hasMixin = mixinUtils.hasMixin;
  var TIMESTAMP_CHANGED_EVENT = VideoFeedMixin.TIMESTAMP_CHANGED_EVENT;

  /**
   * Support for displaying a video's current timestamp.
   *
   * @class
   * @alias module:nmodule/videoDriver/rc/live/VideoTimestampWidget
   * @extends {module:bajaux/Widget}
   */
  return /*#__PURE__*/function (_Widget) {
    function VideoTimestampWidget() {
      _classCallCheck(this, VideoTimestampWidget);
      return _callSuper(this, VideoTimestampWidget, arguments);
    }
    _inherits(VideoTimestampWidget, _Widget);
    return _createClass(VideoTimestampWidget, [{
      key: "doInitialize",
      value:
      /**
       * @param {JQuery} dom
       */
      function doInitialize(dom) {
        dom.html('<div class="videoTimestampDisplay"></div>').addClass('VideoTimestampWidget');
        dom.find('.videoTimestampDisplay').hide();
      }

      /**
       * Arms event handler to show the video stream's current timestamp.
       * @param {module:nmodule/videoDriver/rc/live/VideoFeedMixin} videoStream a
       * `VideoStream` that has the `VideoFeedMixin`
       */
    }, {
      key: "doLoad",
      value: function doLoad(videoStream) {
        var _this = this;
        if (providesTimestamp(videoStream)) {
          var update = function update() {
            return _this.$updateTimestamp(videoStream.getVideoTimestamp());
          };
          this.$listener = update;
          videoStream.on(TIMESTAMP_CHANGED_EVENT, update);
          return update();
        }
      }

      /**
       * Updates the timestamp currently displayed.
       * @private
       * @param {number} timestamp
       * @returns {Promise}
       */
    }, {
      key: "$updateTimestamp",
      value: function $updateTimestamp(timestamp) {
        var timestampElement = this.$getTimestampElement();
        if (!timestamp) {
          timestampElement.hide();
          return Promise.resolve();
        }
        return baja.AbsTime.make({
          jsDate: new Date(timestamp)
        }).toString({
          showSeconds: true,
          showMilliseconds: true
        }).then(function (timeString) {
          timestampElement.show();
          timestampElement.text(timeString);
        });
      }
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        this.jq().removeClass('VideoTimestampWidget');
        var videoStream = this.value();
        if (providesTimestamp(videoStream)) {
          videoStream.removeListener(TIMESTAMP_CHANGED_EVENT, this.$listener);
        }
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getTimestampElement",
      value: function $getTimestampElement() {
        return this.jq().find('.videoTimestampDisplay');
      }
    }]);
  }(Widget);
  function providesTimestamp(obj) {
    return obj && hasMixin(obj, VideoFeedMixin.MIXIN_NAME) && typeof obj.getVideoTimestamp === 'function';
  }
});
