function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module  module:nmodule/videoDriver/rc/fe/utils/videoDriverUtils
 */
define(['baja!', 'baja!videoDriver:IVideoStream,' + 'videoDriver:IRemoteVideoCamera,' + 'videoDriver:IVideoCamera', 'lex!videoDriver', 'bajaux/Widget', 'jquery', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/videoDriver/rc/rpc/rpc', 'nmodule/webEditors/rc/fe/baja/util/compUtils', 'nmodule/webEditors/rc/wb/profile/profileUtils', 'nmodule/webEditors/rc/fe/registry/StationRegistry', 'log!nmodule.videoDriver.rc.fe.utils.videoDriverUtils'], function (baja, types, lexs, Widget, $, Promise, _, asyncUtils, rpc, compUtils, profileUtils, StationRegistry, log) {
  'use strict';

  var exports = {};
  var _lexs = _slicedToArray(lexs, 1),
    lex = _lexs[0];
  var closest = compUtils.closest;
  var doRequire = asyncUtils.doRequire;
  var SLOW_FACTORS = [0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.05];
  var FAST_FACTORS = [2, 4, 6, 8, 10, 30, 60, 600, 1200, 2400];
  var DEFAULT_FPS = 30;
  var FPS_INTERVAL = 1000 / DEFAULT_FPS;
  var videoStreamType = 'videoDriver:IVideoStream';
  var remoteVideoCameraType = 'videoDriver:IRemoteVideoCamera';
  var videoCameraType = 'videoDriver:IVideoCamera';
  var logSevere = log.severe.bind(log);

  /**
   * Gets the best IVideoStream agent. Prefer HLS when
   * foxStreaming is preferred.
   * @param {baja.Value} value
   * @returns {Promise<*>}
   * @private
   */
  exports.getVideoStreamAgent = function (value) {
    return Promise.all([StationRegistry.getInstance().resolveAll(value.getType(), {
      tags: [videoStreamType]
    }), doRequire('nmodule/videoDriver/rc/hls/HLSVideoStream')]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        videoStreams = _ref2[0],
        HLSVideoStream = _ref2[1];
      if (videoStreams.length === 1) {
        return videoStreams[0];
      }
      var boxStreamerIndex = videoStreams.indexOf(HLSVideoStream);
      if (boxStreamerIndex !== -1) {
        return rpc.isFoxVideoStreamPreferred(value.getNavOrd()).then(function (foxVideoPreferred) {
          if (foxVideoPreferred) {
            return videoStreams[boxStreamerIndex];
          }
          return videoStreams[boxStreamerIndex === 0 ? 1 : 0];
        });
      }
      return videoStreams[0];
    });
  };

  /**
   *
   * @param {baja.Value|null} value
   * @return {*}
   */
  exports.getNoStreamMessage = function (value) {
    if (!value || !_.isFunction(value.getType)) {
      return lex.get('LiveVideo.noStreamEmpty');
    }
    return lex.get('LiveVideo.noStream', value.getType());
  };

  /**
   * Initialize the VideoEventListeners so that video aspect ratio changes
   * call relayout and changes in document visibility cause the video to reload.
   * When the video is playing and the `timeUpdate` function exists on the widget
   * then call that method when each new frame is received.
   * @param {module:bajaux/Widget} widget
   * @see https://developer.mozilla.org/en-US/docs/Web/API/Page_Visibility_API
   */
  exports.initializeVideoEventListeners = function (widget) {
    if (!widget) {
      return;
    }
    var jq = widget.jq();
    var videoDom = widget.jq().find("video");
    if (!videoDom.length) {
      return;
    }
    var videoElem = videoDom[0];
    widget.$docEventListener = function () {
      if (exports.$getDocument().visibilityState === "visible") {
        widget.load(widget.value())["catch"](baja.error);
      }
    };
    exports.$getDocument().addEventListener("visibilitychange", widget.$docEventListener);
    widget.$videoEventListener = function () {
      // Video is loaded and can be played, make sure to adjust layout based on aspect ratio
      var parentJq = jq.closest(".LiveVideo");
      var parentWidget = Widget["in"](parentJq);
      if (parentWidget) {
        parentWidget.layout()["catch"](baja.error);
      }
    };
    videoElem.addEventListener('loadedmetadata', widget.$videoEventListener, false);
    var currentTime;
    var _doTimeUpdate = function doTimeUpdate() {
      var newCurrentTime = videoElem.currentTime;
      if (currentTime !== newCurrentTime && widget.timeUpdate) {
        widget.timeUpdate();
      }
      currentTime = newCurrentTime;
      //TODO: make FPS configurable
      widget.$timeUpdateTicket = setTimeout(_doTimeUpdate, FPS_INTERVAL);
    };
    widget.$timeUpdateTicket = setTimeout(_doTimeUpdate);
  };

  /**
   * Remove the current video Event listeners.
   * @param {module:bajaux/Widget} widget
   */
  exports.removeVideoEventListeners = function (widget) {
    if (!widget) {
      return;
    }
    if (widget.$docEventListener) {
      exports.$getDocument().removeEventListener('visibilitychange', widget.$docEventListener);
    }
    delete widget.$docEventListener;
    var videoDom = widget.jq().find("video");
    if (!videoDom.length) {
      return;
    }
    var videoElem = videoDom[0];
    if (widget.$videoEventListener) {
      videoElem.removeEventListener('loadedmetadata', widget.$videoEventListener);
      delete widget.$videoEventListener;
    }
    if (widget.$timeUpdateTicket) {
      clearTimeout(widget.$timeUpdateTicket);
    }
  };

  //TODO: this should be in a type extension, but NCCB-24257
  /**
   * @param {string|baja.Enum|number} tag a tag from
   * `videoDriver:VideoAspectRatioEnum` (if a number already, will be returned
   * directly)
   * @returns {number} the width / height aspect ratio
   */
  exports.getAspectRatio = function (tag) {
    if (typeof tag === 'number') {
      return tag;
    }
    switch (tagToString(tag)) {
      case 'movietone':
        return 1.15;
      case 'standard_def':
        return 4 / 3;
      case 'imax':
        return 1.43;
      case 'classic_35mm':
        return 1.5;
      case 'golden_ratio':
        return 1.618;
      case 'european_widescreen':
        return 5 / 3;
      case 'high_def':
        return 16 / 9;
      case 'us_widescreen':
        return 1.85;
      case 'cinema_widescreen':
        return 2.39;
    }
  };

  /**
   * Get the largest dimensions that can fit inside the given width and height
   * while maintaining the given aspect ratio.
   *
   * If one dimension is 0, but the other is not, it will give a ratio that fits
   * the one dimension that is present.
   *
   * @param {string|baja.Enum} aspectRatio a tag from `videoDriver:VideoAspectRatioEnum`
   * @param {object} params
   * @param {number} params.width
   * @param {number} params.height
   * @returns {{width: number, height: number}}
   */
  exports.fitRatio = function (aspectRatio, _ref3) {
    var width = _ref3.width,
      height = _ref3.height;
    var ratio = exports.getAspectRatio(aspectRatio);
    var fitWidth = width;
    var fitHeight = height;
    if (ratio) {
      if (height && !width) {
        fitWidth = height * ratio;
      } else if (width && !height) {
        fitHeight = width / ratio;
      } else {
        // first try to fit the width
        fitHeight = width / ratio;
        if (fitHeight > height) {
          // too tall!
          fitWidth = height * ratio;
          fitHeight = height;
        }
      }
    }
    return {
      width: Math.floor(fitWidth),
      height: Math.floor(fitHeight)
    };
  };

  /**
   * @param {string|baja.Enum} type a `videoDriver:PlaybackTypeEnum` tag
   * @param {number|string|baja.Enum} speed a `videoDriver:PlaybackSpeedEnum`
   * tag or number (1 to 10)
   * @returns {number} the default playback speed factor for the given type and
   * speed. 1 means normal playback; 0.5 means playback at half speed; 2 means
   * playback at double speed. Negative numbers are returned for rewind.
   */
  exports.getPlaybackSpeedFactor = function (type, speed) {
    var tag = tagToString(type);
    var speedNum = parseInt(tagToString(speed).replace('x', ''), 10);
    var index = clamp(speedNum, 1, 10) - 1;
    switch (tag) {
      case 'play':
        return 1;
      case 'pause':
        return 0;
      case 'slowRew':
        return -SLOW_FACTORS[index];
      case 'slowFwd':
        return SLOW_FACTORS[index];
      case 'fastRew':
        return -FAST_FACTORS[index];
      case 'fastFwd':
        return FAST_FACTORS[index];
      default:
        throw new Error("invalid tag \"".concat(tag, "\""));
    }
  };
  function tagToString(tag) {
    if (baja.hasType(tag, 'baja:Enum')) {
      tag = tag.getTag();
    }
    return String(tag);
  }
  function clamp(num, min, max) {
    return Math.min(Math.max(num, min), max);
  }

  /**
   * Get the browser's Document variable.
   * @private
   * @return {Document}
   */
  exports.$getDocument = function () {
    return document;
  };

  /**
   * Get the browser's `window.location.href`.
   * @private
   * @return {String}
   */
  exports.$getLocation = function () {
    return window.location.href;
  };

  /**
   * Get a View Parameter from the current `window.location.href`
   * @param {String} name
   * @return {String|undefined}
   */
  exports.getViewParameter = function (name) {
    var location = exports.$getLocation(),
      viewIndex = location.lastIndexOf('view:');
    if (viewIndex > -1) {
      var viewQueryBody = location.substring(viewIndex + 5);
      var viewQuery = new baja.ViewQuery(viewQueryBody),
        params = viewQuery.getParameters();
      return params[name];
    }
  };

  /**
   * Get a  Normalized View Parameter from the current `window.location.href`
   * @param {String} name
   * @return {String|undefined}
   */

  exports.getNormalizedViewParams = function (name) {
    var ord = String(profileUtils.getCurrentOrd().normalize()),
      viewIndex = ord.lastIndexOf('view:');
    if (viewIndex > -1) {
      var viewQueryBody = ord.substring(viewIndex + 5);
      var viewQuery = new baja.ViewQuery(viewQueryBody),
        params = viewQuery.getParameters();
      return params[name];
    }
  };

  /**
   * Resolve the camera. If its a remote camera, ensure its loaded up and return
   * the local copy for the proper IVideoStream with the proper functionality
   * @param {baja.Component} camera a `videoDriver:IVideoCamera` instance
   * @return {Promise.<baja.Component|*>}
   */
  exports.resolveCamera = function (camera) {
    if (camera.getType().is(remoteVideoCameraType)) {
      return exports.$remoteCameraResolve(camera);
    } else if (camera.getType().is(videoCameraType)) {
      return Promise.resolve(camera);
    }
    return Promise.resolve();
  };

  /**
   * Resolve a remote camera.
   * @private
   * @param {baja.Component} value a `videoDriver:IRemoteVideoCamera` instance
   * @return {Promise.<baja.Component|*>}
   */
  exports.$remoteCameraResolve = function (value) {
    var proxyExt, remoteId;
    if (value.isMounted()) {
      return value.lease().then(function () {
        proxyExt = value.getProxyExt();
        return proxyExt.lease();
      }).then(function () {
        return baja.Ord.make("service:remoteVideo:RemoteVideoService").get();
      }).then(function (remoteService) {
        var pointId = proxyExt.getPointId();
        pointId = pointId.replace("slot:/", "");
        var arg = exports.$getStationName(value) + "//" + pointId;
        return remoteService.invoke({
          slot: 'resolveRemoteVideoSource',
          value: arg
        });
      }).then(function (remoteVideoSourceBaseOrd) {
        var pointId = proxyExt.getPointId();
        pointId = pointId.replace("slot:/Drivers/", "");
        remoteId = "station:|" + remoteVideoSourceBaseOrd + "/" + pointId;
        return exports.$waitForResolution(remoteId);
      }).then(function (camera) {
        if (camera.getType().is(videoCameraType)) {
          return camera;
        }
      });
    }
    return Promise.resolve();
  };

  /**
   * Function is used to resolve a camera based on the ord
   * If the camera is located in the remote station then slot and station is appended to ord and local
   * camera is resolved
   * If the camera is located in the niagara network of the station then the camera is resolved
   * at the niagara network location in the station
   * If the camera is discovered on Jace by joining and the ord contains remoteVideo then it is resolved
   * locally in the station
   * @param remoteVideoOrdString
   * @param sourceName
   * @returns {Promise}
   */
  exports.$remoteVideoCameraResolve = function (remoteVideoOrdString, sourceName) {
    var indexOfSlashSlash = remoteVideoOrdString.indexOf("//");
    var indexOfColon = remoteVideoOrdString.indexOf(":");
    if (indexOfSlashSlash >= 0) {
      // @since Niagara 4.14 calls the new compUtils.getStationName function
      // the ord contains remoteVideo and the alarm is routed from JACE
      return compUtils.getStationName().then(function (localStationName) {
        if (localStationName !== null) {
          return exports.$remoteVideoCameraOrd(remoteVideoOrdString, indexOfColon, indexOfSlashSlash, localStationName);
        } else {
          logSevere("Unable to find local station.");
          return remoteVideoOrdString;
        }
      });
    } else {
      if (indexOfSlashSlash === -1 && sourceName.indexOf(':') !== -1) {
        // the camera is present in the Niagara Network of the station
        return Promise.resolve(exports.$niagaraNetworkCameraOrd(remoteVideoOrdString, sourceName));
      } else {
        // the camera is present in the station
        // We are checking if the retrieved remoteVideoOrdString starts with "station:|"
        if (remoteVideoOrdString.indexOf("station:|") === 0) {
          return Promise.resolve(remoteVideoOrdString);
        } else {
          return Promise.resolve("station:|" + remoteVideoOrdString);
        }
      }
    }
  };

  /**
   * Wait up to 10 seconds for this ord to resolve.
   * @param {String} remoteId
   * @param {Number} [counter=0]
   * @return {Promise.<baja.Component|null>} Returns null if ord does not resolve in time.
   */
  exports.$waitForResolution = function (remoteId, counter) {
    if (!counter) {
      counter = 0;
    }
    if (counter >= 20) {
      return null;
    }
    return baja.Ord.make(remoteId).get()["catch"](function () {
      return asyncUtils.waitInterval(500).then(function () {
        return exports.$waitForResolution(remoteId, ++counter);
      });
    });
  };

  /**
   * @private
   * @param {baja.Component} value
   * @return {String}
   */
  exports.$getStationName = function (value) {
    var station = closest(value, 'niagaraDriver:INiagaraStation');
    return station ? station.getName() : null;
  };

  /**
   * Function to construct the ord of the camera discovered in a Jace from the supervisor
   * and the video is viewed in the supervisor
   * @param remoteVideoOrdString
   * @param indexOfColon
   * @param indexOfSlashSlash
   * @param localStationName
   * @returns {string}
   */
  exports.$remoteVideoCameraOrd = function (remoteVideoOrdString, indexOfColon, indexOfSlashSlash, localStationName) {
    var niagaraStationName = remoteVideoOrdString.substring(indexOfColon + 1, indexOfSlashSlash);
    var remoteCameraOrdString = remoteVideoOrdString.substring(indexOfSlashSlash + 2); //Drivers/AxisVideoNetwork/AxisVideoCamera
    if (remoteCameraOrdString.startsWith("h:")) {
      // Then the remoteCameraOrdString is already in the correct format
    } else {
      remoteCameraOrdString = "slot:/" + remoteCameraOrdString;
      remoteCameraOrdString = 'station:|' + remoteCameraOrdString;
    }
    if (niagaraStationName.equals(localStationName)) {
      // resolve locally
      return remoteCameraOrdString;
    } else {
      return remoteVideoOrdString;
    }
  };

  /**
   * Function constructs the ord for the camera located in the Niagara Network of the station
   * @param remoteVideoOrdString
   * @param sourceName
   * @returns {string}
   */
  exports.$niagaraNetworkCameraOrd = function (remoteVideoOrdString, sourceName) {
    var stationName = sourceName.split(':')[0];
    var cameraName = remoteVideoOrdString.substring(remoteVideoOrdString.lastIndexOf('/'));
    return baja.rpc({
      typeSpec: "niagaraDriver:NiagaraNetwork",
      method: "getStationSlotPathByName",
      args: [stationName]
    }).then(function (ord) {
      var niagaraOrd = ord;
      return 'station:|' + niagaraOrd + '/remoteVideo_NiagaraCameraExt' + cameraName;
    });
  };
  return exports;
});
