function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Shivani Jakhmola
 */

/* eslint-env browser */
/**
 * API Status: **Private**
 * @module nmodule/videoDriver/rc/fe/playback/WebVideoPlayback
 */

define(['baja!', 'bajaux/Properties', 'bajaux/Widget', 'bajaux/mixin/responsiveMixIn', 'bajaux/mixin/subscriberMixIn', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/webEditors/rc/fe/BaseWidget', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'nmodule/webEditors/rc/fe/fe', 'nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget', 'nmodule/videoDriver/rc/fe/playback/CameraChooserWidget', 'nmodule/videoDriver/rc/fe/utils/videoDriverUtils', 'nmodule/videoDriver/rc/live/LiveVideo', 'nmodule/videoDriver/rc/live/stream/StreamSettingsCommand', 'baja!videoDriver:VideoPlaybackChooser,' + 'videoDriver:IVideoCamera'], function (baja, Properties, Widget, responsiveMixIn, subscriberMixIn, Promise, _, asyncUtils, BaseWidget, DisplayOnlyEditor, fe, PlaybackControlsWidget, CameraChooserWidget, videoDriverUtils, LiveVideo, StreamSettingsCommand) {
  'use strict';

  var tpl = function tpl() {
    return "\n    <div class=\"webVideoPlaybackContainer\">\n      <div class=\"CameraChooserWidget\"></div>\n      <div class=\"LiveVideo\"></div>\n      <div class=\"PlaybackControlsWidget\"></div>\n    </div>\n  ";
  };
  var extend = _.extend,
    isFunction = _.isFunction;
  var videoPlaybackChooserType = 'videoDriver:VideoPlaybackChooser';
  var videoCameraType = 'videoDriver:IVideoCamera';
  var PLAYBACK_TYPE = 'playbackType';
  var PLAYBACK_TIMESTAMP = 'playbackTimestamp';

  /**
   * Widget for playback of historical video from a camera. Provides playback
   * controls such as play/pause/rewind/seek.
   *
   * It supports the following bajaux Properties:
   *
   * - `playbackType`: a String corresponding to a `BPlaybackTypeEnum` tag.
   *   Specifies how the video should be playing. Defaults to `live`
   * - `playbackTimestamp`: a String encoding of a `baja:AbsTime` that indicates
   *   when the playback should start. Will only be respected if `playbackType`
   *   is `play`. Defaults to `AbsTime.DEFAULT`, which also indicates that
   *   the playback should start "now" instead of a specified time.
   *
   * @private
   * @class
   * @extends module:nmodule/webEditors/rc/fe/BaseWidget
   * @alias module:nmodule/videoDriver/rc/fe/WebVideoPlayback
   */
  return /*#__PURE__*/function (_BaseWidget) {
    function WebVideoPlayback(params) {
      var _this;
      _classCallCheck(this, WebVideoPlayback);
      _this = _callSuper(this, WebVideoPlayback, [extend({
        keyName: 'WebVideoPlayback',
        moduleName: 'videoDriver'
      }, params, {
        properties: Properties.extend(_defineProperty(_defineProperty({}, PLAYBACK_TYPE, {
          value: 'live',
          typeSpec: 'videoDriver:PlaybackTypeEnum'
        }), PLAYBACK_TIMESTAMP, {
          value: baja.AbsTime.DEFAULT.encodeToString(),
          typeSpec: 'baja:AbsTime'
        }), params && params.properties)
      })]);
      subscriberMixIn(_this);
      responsiveMixIn(_this, {
        'playback-thin': {
          maxWidth: 550
        }
      });
      _this.getCommandGroup().add(new StreamSettingsCommand(_this));
      return _this;
    }

    /**
     * @private
     * @returns {module:nmodule/videoDriver/rc/live/stream/StreamSettingsCommand}
     */
    _inherits(WebVideoPlayback, _BaseWidget);
    return _createClass(WebVideoPlayback, [{
      key: "$getStreamSettingsCommand",
      value: function $getStreamSettingsCommand() {
        return this.getCommandGroup().get(0);
      }

      /**
       * @param {JQuery} dom
       */
    }, {
      key: "doInitialize",
      value: function doInitialize(dom) {
        dom.html(tpl()).addClass('WebVideoPlayback');
      }

      /**
       * @param {baja.Component} value - the agent value on which WebVideoPlayback
       * is registered on.
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(value) {
        var timestamp = videoDriverUtils.getNormalizedViewParams("playbackTimestamp");
        if (timestamp) {
          var startTime = baja.AbsTime.make({
            jsDate: new Date(parseInt(timestamp))
          }).encodeToString();
          this.properties().setValue('playbackTimestamp', startTime);
          this.properties().setValue('playbackType', 'play');
        }
        return this.$reload();
      }

      /**
       * Destroys the editor and all children of the editor.
       * @returns {Promise}
       */
    }, {
      key: "doDestroy",
      value: function doDestroy() {
        var jq = this.jq();
        jq.removeClass('WebVideoPlayback');
        jq.css('max-width', '');
        return this.getChildWidgets().destroyAll();
      }

      /**
       * Layout the widgets in playback Viewer
       * @returns {Promise}
       */
    }, {
      key: "doLayout",
      value: function doLayout() {
        return this.getChildWidgets().layoutAll();
      }

      /**
       * Destroy all the child widgets if necessary and reload the new child widgets.
       * @private
       * @return {Promise}
       */
    }, {
      key: "$reload",
      value: function $reload() {
        var _this2 = this;
        this.$reloading = true;
        return Promise.resolve(this.$loaded && this.getChildWidgets().destroyAll()).then(function () {
          if (_this2.$loaded) {
            _this2.doInitialize(_this2.jq());
          }
          _this2.$loaded = true;
          return _this2.$initializeView(_this2.value());
        })["finally"](function () {
          _this2.$reloading = false;
        });
      }

      /**
       * For a `VideoPlaybackChooser` value, resolve to the most recently used camera.
       * If the value is a camera, then resolve it.
       * Otherwise just resolve to undefined.
       * @private
       * @param {baja.Component} value
       * @return {Promise.<baja.Component|*>}
       */
    }, {
      key: "$resolveCamera",
      value: function $resolveCamera(value) {
        if (value.getType().is(videoPlaybackChooserType)) {
          var mostRecent = value.getMostRecentCameraViewed();
          if (mostRecent !== baja.Ord.DEFAULT) {
            return baja.Ord.make("station:|" + mostRecent).get().then(function (camera) {
              if (camera.getType().is(videoCameraType)) {
                return videoDriverUtils.resolveCamera(camera);
              }
            })["catch"](baja.error);
          }
        } else if (value.getType().is(videoCameraType)) {
          return videoDriverUtils.resolveCamera(value);
        }
        return Promise.resolve();
      }

      /**
       * Function is used to initialize the web video playback view with Camera Controls,
       * Video Display and Video Playback buttons
       * @private
       * @param {baja.Component} value - the agent value on which WebVideoPlayback
       * is registered on.
       * @returns {Promise}
       */
    }, {
      key: "$initializeView",
      value: function $initializeView(value) {
        var _this3 = this;
        return Promise.all([value.getType().is(videoPlaybackChooserType) && this.$buildCameraChooser(value), this.$resolveCamera(value).then(function (camera) {
          if (!camera) {
            return _this3.$showNoStreamError();
          }
          return _this3.$buildLiveVideo(camera).then(function (liveVideo) {
            var settingsCmd = _.result(liveVideo, '$getStreamSettingsCommand');
            _this3.$getStreamSettingsCommand().setEnabled(settingsCmd && settingsCmd.isEnabled());
            var videoStream = liveVideo.$getVideoStream();
            if (isFunction(videoStream.playback)) {
              return _this3.$buildPlaybackControls(videoStream);
            }
          });
        })]);
      }

      /**
        * @private
       * @param {baja.Component} camera
       * @returns {Promise.<module:nmodule/videoDriver/rc/fe/playback/CameraChooserWidget>}
       */
    }, {
      key: "$buildCameraChooser",
      value: function $buildCameraChooser(camera) {
        var _this4 = this;
        return fe.buildFor({
          formFactor: 'mini',
          type: CameraChooserWidget,
          dom: this.$getCameraChooserElement(),
          value: camera,
          properties: {
            onCameraChanged: function onCameraChanged() {
              if (!_this4.$reloading) {
                return _this4.$reload().then(function () {
                  return _this4.layout();
                });
              }
            }
          }
        });
      }

      /**
       * @private
       * @param {baja.Component} camera
       * @returns {Promise.<module:nmodule/videoDriver/rc/live/LiveVideo>}
       */
    }, {
      key: "$buildLiveVideo",
      value: function $buildLiveVideo(camera) {
        return fe.buildFor({
          formFactor: 'mini',
          type: LiveVideo,
          dom: this.$getLiveVideoElement(),
          value: camera,
          properties: this.properties().subset(['playbackType', 'playbackTimestamp', 'preferredResolution', 'preferredFrameRate', 'preferredCompression']).toValueMap()
        });
      }

      /**
       * @private
       * @param {module:nmodule/videoDriver/rc/fe/playback/PlaybackController} controller
       * @returns {Promise.<module:nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget>}
       */
    }, {
      key: "$buildPlaybackControls",
      value: function $buildPlaybackControls(controller) {
        return fe.buildFor({
          formFactor: 'mini',
          type: PlaybackControlsWidget,
          dom: this.$getVideoPlaybackControlsElement(),
          value: controller,
          properties: _defineProperty({}, PLAYBACK_TYPE, this.properties().getValue(PLAYBACK_TYPE))
        });
      }

      /**
       * @private
       * @returns {number} the timestamp the widget is user-configured to start
       * playback from
       */
    }, {
      key: "$getPlaybackTimestamp",
      value: function $getPlaybackTimestamp() {
        var str = this.properties().getValue(PLAYBACK_TIMESTAMP);
        if (str) {
          return baja.AbsTime.DEFAULT.decodeFromString(str).getMillis();
        }
        return 0;
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getVideoPlaybackControlsElement",
      value: function $getVideoPlaybackControlsElement() {
        return this.jq().find('.PlaybackControlsWidget');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/playback/PlaybackControlsWidget}
       */
    }, {
      key: "$getVideoPlaybackControlsWidget",
      value: function $getVideoPlaybackControlsWidget() {
        return Widget["in"](this.$getVideoPlaybackControlsElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getLiveVideoElement",
      value: function $getLiveVideoElement() {
        return this.jq().find('.LiveVideo');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/live/LiveVideo}
       */
    }, {
      key: "$getLiveVideo",
      value: function $getLiveVideo() {
        return Widget["in"](this.$getLiveVideoElement());
      }

      /**
       * @private
       * @returns {JQuery}
       */
    }, {
      key: "$getCameraChooserElement",
      value: function $getCameraChooserElement() {
        return this.jq().find('.CameraChooserWidget');
      }

      /**
       * @private
       * @returns {module:nmodule/videoDriver/rc/fe/playback/CameraChooserWidget}
       */
    }, {
      key: "$getCameraChooserWidget",
      value: function $getCameraChooserWidget() {
        return Widget["in"](this.$getCameraChooserElement());
      }

      /**
       * @private
       * @returns {module:bajaux/Widget}
       */
    }, {
      key: "$getVideoStream",
      value: function $getVideoStream() {
        return this.$getLiveVideo().$getVideoStream();
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$showNoStreamError",
      value: function $showNoStreamError() {
        return fe.buildFor({
          formFactor: 'mini',
          type: DisplayOnlyEditor,
          dom: this.$getLiveVideoElement(),
          value: videoDriverUtils.getNoStreamMessage()
        });
      }
    }]);
  }(BaseWidget);
});
