/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */
function setElementDisabled(elements, disable)
{
  if ((elements != null) && (elements[0] != null))
  {
    elements[0].disabled = disable;
    elements[0].readOnly = disable;
  }
}

function executeAdapterOnLoad(prefix)
{
  //NOTE: prefix here will normally look like:
  //
  //  settings.en0
  //
  //However, under more exotic HxPx environments, the prefix could look like:
  //
  //  root.content.IEEE8021XPlatformServicePlugin.IEEE8021XService.settings.en0
  //
  //The host level settings like "readonly" will require that
  //we strip off the adapter context ("en0" above) in order to find the fields - don't use the hardcoded
  //'settings' prefix (NCCB-34651). Strip off everything after the last '.' to determine the 'host' level prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite         = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly          = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var ieee8021XEnabled            = (document.getElementsByName(prefix + ".isIEEE8021XEnabled.hidden")[0].value === "true");
  var eapMethod                   = (document.getElementsByName(prefix + ".eapMethod.hidden")[0].value);
  var fastReauthenticationEnabled = (document.getElementsByName(prefix + ".isUseFastReauthenticationEnabled.hidden")[0].value === "true");

  var phase1                      = (document.getElementsByName(prefix + ".phase1.hidden")[0].value);
  var phase2                      = (document.getElementsByName(prefix + ".phase2.hidden")[0].value);

  //generic settings
  setElementDisabled(document.getElementsByName(prefix + ".isIEEE8021XEnabled.value"),          (adapterReadonly || !operatorCanWrite));

  //Static configuration
  setElementDisabled(document.getElementsByName(prefix + ".eapMethod.value"),                   (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".fastReauthenticationEnabled.value"), (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));

  //Credentials
  setElementDisabled(document.getElementsByName(prefix + ".eapIdentity.value"),                 (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".eapAnonymousIdentity.value"),        (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".eapPassphrase.value"),               (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  //NOTE: The HxPasswordFE has a 'confirm' field in addition to the 'value' field. Make sure that is disabled as well.
  setElementDisabled(document.getElementsByName(prefix + ".eapPassphrase.confirm"),             (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));

  //Outer TLS
  setElementDisabled(document.getElementsByName(prefix + ".clientKey.value"),                   (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".clientKeyPassphrase.value"),         (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  //NOTE: The HxPasswordFE has a 'confirm' field in addition to the 'value' field. Make sure that is disabled as well.
  setElementDisabled(document.getElementsByName(prefix + ".clientKeyPassphrase.confirm"),       (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".caCert.value"),                      (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));

  //Tunnel
  setElementDisabled(document.getElementsByName(prefix + ".peapPhase1.value"),                  (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".peapPhase2.value"),                  (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".ttlsPhase2.value"),                  (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));

  //Inner TLS
  setElementDisabled(document.getElementsByName(prefix + ".clientKey2.value"),                  (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".clientKey2Passphrase.value"),        (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  //NOTE: The HxPasswordFE has a 'confirm' field in addition to the 'value' field. Make sure that is disabled as well.
  setElementDisabled(document.getElementsByName(prefix + ".clientKey2Passphrase.confirm"),      (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
  setElementDisabled(document.getElementsByName(prefix + ".caCert2.value"),                     (adapterReadonly || !operatorCanWrite || !ieee8021XEnabled));
}

function onIEEE8021XEnabledChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].ieee8021XEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite            = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly             = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var ieee8021XEnabled            = (element.value === "true");
  var eapMethod                   = (document.getElementsByName(prefix + ".eapMethod.hidden")[0].value);
  var fastReauthenticationEnabled = (document.getElementsByName(prefix + ".isUseFastReauthenticationEnabled.hidden")[0].value === "true");

  var phase1                      = (document.getElementsByName(prefix + ".phase1.hidden")[0].value);
  var phase2                      = (document.getElementsByName(prefix + ".phase2.hidden")[0].value);

  if (operatorCanWrite && !adapterReadonly)
  {
    //Self
    document.getElementsByName(prefix + ".isIEEE8021XEnabled.hidden")[0].value = element.value;

    //Static configuration
    setElementDisabled(document.getElementsByName(prefix + ".eapMethod.value"),                   !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".fastReauthenticationEnabled.value"), !ieee8021XEnabled);

    //Credentials
    setElementDisabled(document.getElementsByName(prefix + ".eapIdentity.value"),                 !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".eapAnonymousIdentity.value"),        !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".eapPassphrase.value"),               !ieee8021XEnabled);
    //NOTE: The HxPasswordFE has a 'confirm' field in addition to the 'value' field. Make sure that is disabled as well.
    setElementDisabled(document.getElementsByName(prefix + ".eapPassphrase.confirm"),             !ieee8021XEnabled);


    //Outer TLS
    setElementDisabled(document.getElementsByName(prefix + ".clientKey.value"),                   !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".clientKeyPassphrase.value"),         !ieee8021XEnabled);
    //NOTE: The HxPasswordFE has a 'confirm' field in addition to the 'value' field. Make sure that is disabled as well.
    setElementDisabled(document.getElementsByName(prefix + ".clientKeyPassphrase.confirm"),       !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".caCert.value"),                      !ieee8021XEnabled);

    //Tunnel
    setElementDisabled(document.getElementsByName(prefix + ".peapPhase1.value"),                  !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".peapPhase2.value"),                  !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".ttlsPhase2.value"),                  !ieee8021XEnabled);

    //Inner TLS
    setElementDisabled(document.getElementsByName(prefix + ".clientKey2.value"),                  !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".clientKey2Passphrase.value"),        !ieee8021XEnabled);
    //NOTE: The HxPasswordFE has a 'confirm' field in addition to the 'value' field. Make sure that is disabled as well.
    setElementDisabled(document.getElementsByName(prefix + ".clientKey2Passphrase.confirm"),      !ieee8021XEnabled);
    setElementDisabled(document.getElementsByName(prefix + ".caCert2.value"),                     !ieee8021XEnabled);
  }
}

function onEAPMethodChanged(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].fastReauthenticationEnabled.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite            = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly             = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var ieee8021XEnabled            = (document.getElementsByName(prefix + ".isIEEE8021XEnabled.hidden")[0].value === "true");
  var eapMethod                   = (element.value);
  var fastReauthenticationEnabled = (document.getElementsByName(prefix + ".isUseFastReauthenticationEnabled.hidden")[0].value === "true");

  var phase1                      = (document.getElementsByName(prefix + ".phase1.hidden")[0].value);
  var phase2                      = (document.getElementsByName(prefix + ".phase2.hidden")[0].value);

  //NOTE: When editor is not readonly, this needs to redraw the contents of the page
}

function onPhase2Changed(event)
{
  var element = (event.target) ? event.target : window.event.srcElement;

  //We will typically expect to see the scope passed here as:
  //
  //  [host].[adapter].phase2.value
  //
  //We want to get the [host] level scope, so peel off the last 2 items to get back to
  //
  //  [host].[adapter]
  //
  var prefix = element.name.substring(0, element.name.lastIndexOf("."));
  prefix = prefix.substring(0, prefix.lastIndexOf("."));

  //Determine host prefix
  var hostLevelPrefix = prefix.substring(0, prefix.lastIndexOf("."));

  var operatorCanWrite            = (document.getElementsByName(prefix + ".operatorCanWrite.hidden")[0].value === "true");
  var adapterReadonly             = (document.getElementsByName(prefix + ".adapterReadonly.hidden")[0].value === "true");

  var ieee8021XEnabled            = (document.getElementsByName(prefix + ".isIEEE8021XEnabled.hidden")[0].value === "true");
  var eapMethod                   = (document.getElementsByName(prefix + ".eapMethod.hidden")[0].value);
  var fastReauthenticationEnabled = (document.getElementsByName(prefix + ".isUseFastReauthenticationEnabled.hidden")[0].value === "true");

  var phase1                      = (document.getElementsByName(prefix + ".phase1.hidden")[0].value);
  var phase2                      = (element.value);

  //NOTE: When editor is not readonly, this needs to redraw the contents of the page
}


