function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/** @jsx spandrel.jsx */

/**
 * API Status: **Private**
 * @module nmodule/weather/rc/wb/baja/UxCurrentWeatherView
 */

define(["baja!", 'baja!gx:Font,gx:Brush,bajaui:Halign,bajaui:Valign,weather:WeatherIconSize,weather:CurrentConditions', 'lex!weather', 'bajaux/spandrel', 'bajaux/mixin/subscriberMixIn', 'bajaux/mixin/UxModelSupport', 'nmodule/bajaui/rc/ux/Label', 'nmodule/webEditors/rc/fe/baja/IconEditor', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'css!nmodule/weather/rc/weather'], function (baja, types, lexs, spandrel, subscriberMixIn, UxModelSupport, Label, IconEditor, DepthSubscriber) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    WEATHER_LEX = _lexs[0];
  var widgetDefaults = function widgetDefaults() {
    return {
      moduleName: 'weather',
      keyName: 'UxCurrentWeatherView',
      properties: {
        rootCssClass: "-t-UxCurrentWeatherView",
        enabled: true,
        visible: true,
        alarmStateBrush: baja.$('gx:Brush', 'red'),
        halign: baja.$('bajaui:Halign', 'center'),
        valign: baja.$('bajaui:Valign', 'center'),
        iconSize: baja.$('weather:WeatherIconSize', 'x64'),
        tempFont: baja.$('gx:Font', WEATHER_LEX.get('temp.font')),
        tempBrush: baja.$('gx:Brush', 'black'),
        stateFont: baja.$('gx:Font', WEATHER_LEX.get('state.font')),
        stateBrush: baja.$('gx:Brush', 'black'),
        summaryFont: {
          value: baja.$('gx:Font', WEATHER_LEX.get('state.font')),
          hidden: true
        },
        summaryBrush: {
          value: baja.$('gx:Brush', 'black'),
          hidden: true
        }
      }
    };
  };
  var getIconSize = function getIconSize(size) {
    var sizeMap = {
      'x64': 64,
      'x32': 32
    };
    return sizeMap[size.getTag()];
  };
  var LEFT = baja.$('bajaui:Halign', 'left');
  var LABEL_MARGIN = baja.$('gx:Insets', 3, 0, 0, 5);

  /**
   * Ux view for Current weather
   *
   * @class
   * @alias module:nmodule/weather/rc/wb/baja/UxCurrentWeatherView
   * @extends module:bajaux/Widget
   * @since Niagara 4.14
  */
  var UxCurrentWeatherView = /*#__PURE__*/function (_spandrel) {
    function UxCurrentWeatherView(params) {
      var _this;
      _classCallCheck(this, UxCurrentWeatherView);
      _this = _callSuper(this, UxCurrentWeatherView, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      UxModelSupport(_this);
      _this.$subscriber = new DepthSubscriber(5);
      subscriberMixIn(_this);
      _this.getSubscriber().attach('changed', function () {
        _this.rerender();
      });
      return _this;
    }
    _inherits(UxCurrentWeatherView, _spandrel);
    return _createClass(UxCurrentWeatherView, [{
      key: "$buildEditor",
      value: function $buildEditor(weatherCondition, props) {
        var _this$$toValues = this.$toValues(weatherCondition),
          useAlarmBrush = _this$$toValues.useAlarmBrush,
          tempDisplay = _this$$toValues.tempDisplay,
          stateDisplay = _this$$toValues.stateDisplay,
          summaryDisplay = _this$$toValues.summaryDisplay,
          iconName = _this$$toValues.iconName;
        var alarmStateBrush = props.alarmStateBrush,
          iconSize = props.iconSize,
          summaryBrush = props.summaryBrush,
          summaryFont = props.summaryFont,
          tempBrush = props.tempBrush,
          tempFont = props.tempFont;
        var stateBrush = props.stateBrush,
          stateFont = props.stateFont;
        var icon = baja.$('baja:Icon', "module://weather/rc/".concat(iconName).concat(getIconSize(iconSize), ".png"));
        if (this.properties().get("stateBrush").hidden) {
          stateBrush = summaryBrush;
          stateFont = summaryFont;
        }
        return spandrel.jsx("div", {
          className: "-t-WeatherView-wrapper"
        }, spandrel.jsx(IconEditor, {
          value: icon
        }), spandrel.jsx("div", {
          className: "-t-WeatherView-textWrapper"
        }, spandrel.jsx(Label, {
          spandrelKey: "temperatureLabel",
          className: "-t-WeatherView-temperatureLabel",
          properties: {
            font: tempFont,
            foreground: tempBrush,
            text: tempDisplay,
            halign: LEFT,
            margin: LABEL_MARGIN
          }
        }), spandrel.jsx(Label, {
          spandrelKey: "stateLabel",
          className: "-t-WeatherView-stateLabel",
          properties: {
            font: stateFont,
            foreground: useAlarmBrush ? alarmStateBrush : stateBrush,
            text: stateDisplay,
            halign: LEFT,
            margin: LABEL_MARGIN
          }
        }), spandrel.jsx(Label, {
          spandrelKey: "summaryLabel",
          className: "-t-Weather-summaryLabel",
          properties: {
            font: summaryFont,
            foreground: summaryBrush,
            text: summaryDisplay,
            halign: LEFT,
            margin: LABEL_MARGIN
          }
        })));
      }

      /**
       * Applies horizontal and vertical alignment to view
       * @private
       * @param style
       * @param alignment
       */
    }, {
      key: "$applyAlignment",
      value: function $applyAlignment(style, alignment) {
        var halign = alignment.halign,
          valign = alignment.valign;
        var justifyContent = toHAlign(halign && halign.getTag() || 'center');
        var alignItems = toVAlign(valign && valign.getTag() || 'center');
        style.justifyContent = justifyContent;
        style.alignItems = alignItems;

        /**
         * Horizontal positioning based on css changes to `justifyContent`
         * @param {String} tag
         * @return {String}
         */
        function toHAlign(tag) {
          switch (tag) {
            case 'left':
            case 'fill':
              return 'flex-start';
            case 'right':
              return 'flex-end';
            default:
              return 'center';
          }
        }

        /**
         * Vertical position based on css change to `alignItems`.
         * @param {String} tag
         * @return {String}
         */
        function toVAlign(tag) {
          switch (tag) {
            case 'top':
            case 'fill':
              return 'flex-start';
            case 'bottom':
              return 'flex-end';
            default:
              return 'center';
          }
        }
      }

      /**
       * Returns the correct weather icon name based on the state and sundown values
       * @private
       * @param {String} state the tag string value from the state of the weather value
       * @param {Boolean} sunDown is the sun down or up, used to select icons based on that status
       * @returns {String} a string used to build the path to the icon to be shown
       */
    }, {
      key: "$getWeatherIconName",
      value: function $getWeatherIconName(state, sunDown) {
        switch (state.toUpperCase()) {
          case "SUNNY":
          case "CLEAR":
          case "FAIR":
            if (!sunDown) {
              return "sunny";
            } else {
              return "nightClear";
            }
          case "PARTLYSUNNY":
          case "MOSTLYCLOUDY":
            if (!sunDown) {
              return "partlySunny";
            } else {
              return "nightMostlyCloudy";
            }
          case "MOSTLYSUNNY":
          case "PARTLYCLOUDY":
          case "AFEWCLOUDS":
            if (!sunDown) {
              return "mostlySunny";
            } else {
              return "nightPartlyCloudy";
            }
          case "CLOUDY":
          case "OVERCAST":
            return "cloudy";
          case "FOG":
            if (!sunDown) {
              return "fog";
            } else {
              return "nightFog";
            }
          case "HAZE":
            return "haze";
          case "MISTY":
          case "RAIN":
          case "LIGHTRAIN":
          case "HEAVYRAIN":
          case "HURRICANE":
            return "rain";
          case "FREEZINGRAIN":
            return "freezingRain";
          case "THUNDERSTORMS":
            return "thunder";
          case "SNOW":
            return "snow";
          case "WINDY":
          case "TORNADO":
            return "windy";
          case "DUST":
            return "dust";
          case "TSUNAMI":
          case "FLOOD":
            return "flood";
          case "EARTHQUAKE":
            return "earthquake";
          case "FIRE":
          case "VOLCANO":
            return "fire";
          default:
            return "unknown";
        }
      }

      /**
       * Extracts the values for the $buildEditor function to use in building the view
       * @private
       * @param {baja.Component} weatherConditions the weather conditions to be displayed
       * @returns {Object}
       */
    }, {
      key: "$toValues",
      value: function $toValues(weatherConditions) {
        var tempDisplay = "-";
        var stateDisplay = "";
        var summaryDisplay = "-";
        var stateTag = "unknown";
        var sunDown = false;
        var iconName = "unknown";
        var useAlarmBrush = false;
        if (weatherConditions.getType().is('weather:WeatherReport')) {
          weatherConditions = weatherConditions.getCurrent();
        }
        if (weatherConditions.getType().is('weather:CurrentConditions')) {
          var tempValue = weatherConditions.getTemp();
          var stateValue = weatherConditions.getState();
          var advisories = weatherConditions.getAdvisories().getSlots().is("weather:Advisory").toValueArray();
          advisories.sort(function (advisory1, advisory2) {
            var ord1 = advisory1.getUrgency().getValue().getOrdinal();
            var ord2 = advisory2.getUrgency().getValue().getOrdinal();
            var millis1 = advisory1.getEffective().getMillis();
            var millis2 = advisory2.getEffective().getMillis();
            var value = ord1 - ord2;
            if (value !== 0) {
              return value;
            }
            return millis2 - millis1;
          });
          var advisory = advisories[0];
          sunDown = weatherConditions.getSunDown().getValue();
          if (stateValue.getStatus().isValid()) {
            stateDisplay = stateValue.getDisplay('value');
            stateTag = stateValue.getValue().getTag();
            if (advisory) {
              useAlarmBrush = true;
              stateDisplay = advisory.getWeatherSummary().getValue();
              var advisoryState = advisory.getState().getValue();
              var unknown = baja.$("weather:WeatherState").decodeFromString("unknown");
              if (advisoryState.getOrdinal() !== unknown.getOrdinal()) {
                stateTag = advisoryState.getTag();
              }
            }
          }
          tempDisplay = tempValue.getStatus().isValid() ? tempValue.getDisplay('value') : '';
          summaryDisplay = '';
          iconName = this.$getWeatherIconName(stateTag, sunDown);
        }
        return {
          useAlarmBrush: useAlarmBrush,
          tempDisplay: tempDisplay,
          stateDisplay: stateDisplay,
          summaryDisplay: summaryDisplay,
          iconName: iconName
        };
      }

      /**
       * @private
       * @returns {baja.Icon}
       */
    }, {
      key: "$getWeatherIcon",
      value: function $getWeatherIcon() {
        return this.jq().find('img');
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/Label}
       */
    }, {
      key: "$getTemperatureLabel",
      value: function $getTemperatureLabel() {
        return this.queryWidget('**/temperatureLabel');
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/Label}
       */
    }, {
      key: "$getStateLabel",
      value: function $getStateLabel() {
        return this.queryWidget('**/stateLabel');
      }

      /**
       * @private
       * @returns {module:nmodule/bajaui/rc/ux/Label}
       */
    }, {
      key: "$getSummaryLabel",
      value: function $getSummaryLabel() {
        return this.queryWidget('**/summaryLabel');
      }
    }]);
  }(spandrel(function (uxModel, state) {
    var self = state.self,
      props = state.props,
      rootElement = state.rootElement;
    var weatherCondition = uxModel.getValue();
    var style = rootElement.style;
    if (!weatherCondition) {
      return;
    }
    self.$applyAlignment(style, props);
    return self.$buildEditor(weatherCondition, props);
  }, {
    strategy: 'niagara'
  }));
  return UxCurrentWeatherView;
});
