/*
spandrel and JSX
================

You can also build spandrel widgets using JSX. Use the "spandrel.jsx" pragma to
enable JSX support.

Please note that JSX is not React and just using JSX does not turn your widget
into a React component. It just provides an easier way of building out your
structure of HTML and child widgets.

Because we find that spandrel and JSX work well together in almost all cases,
all the following examples will use JSX. JSX is not a requirement and spandrel
provides its own method of building widgets using a custom JSON format. More
details on this are in the bajaux tutorials.

If you are using grunt-niagara version 2 or later, it will include everything
you need to enable Babel transpilation and JSX support. grunt-init-niagara will
walk you through the process of enabling it.

Here is another simple example demonstrating the use of JSX to build a spandrel
widget. Again, you do not need to load a value into it.
*/

/** @jsx spandrel.jsx */

define([ 'bajaux/spandrel' ], function (spandrel) {

  'use strict';

  /*
    in JSX, the "style" attribute can be either a string as usual, or an object
    literal mapping CSS attributes to their values.
  */
  const HelloWorldWidget = spandrel(
    <span style={{ color: 'blue', fontWeight: 'bold' }}>
      Hello world!
    </span>
  );

  return HelloWorldWidget;
});
