/*
  This widget demonstrates how to use the responsive layout mixin.

  The responsive layout can be used to add and remove CSS classes to a
  widget's DOM element based upon the size of the widget.
*/

define([
  'bajaux/Widget',
  'bajaux/mixin/responsiveMixIn',
  'css!nmodule/docDeveloper/examples/bajaux/ResponsiveWidgetStyle' ], function (
  Widget,
  responsiveMixIn) {

  'use strict';

  class ResponsiveWidget extends Widget {
    constructor() {
      super(...arguments);
      // Applying this mixin adds responsive layout capabilities to a
      // Widget.
      responsiveMixIn(this, {
        // The 'example-medium' and 'example-small' classes are toggled on the
        // widget depending on the widget's width.
        'example-medium': { maxWidth: 750, minWidth: 501 },
        'example-small': { maxWidth: 500 }
      });
    }

    doInitialize(dom) {
      dom.html(`
        <div class='responsive-widget-example'>
          <p>
            This is an example of a responsive widget. Changing the size of this
            widget will cause the background color to change accordingly. This is done
            by the underlying widget framework toggling classes on the widget's DOM element.
          </p>
        </div>
      `);
    }
  }

  return ResponsiveWidget;
});
