/*
  This is the first example as discussed in...

  module://docDeveloper/doc/jsdoc/bajaux-ux/tutorial-10-mfw-gettingStarted.html
  
  Please note, this is a playground learning environment for creating widgets. 
  If you want to create a view or something that can be used in a production
  environment, you'll need to embed your widget into a niagara module. This is
  described in the getting started guide. 

  Hit the play button to try this Widget out. When playing the Widget, remember 
  to select the Ramp from /BajauxExamples/Components/Ramp.
*/

// This 'define' part of RequireJS and defines a usable module of JavaScript. 
// For more information, please see http://requirejs.org/.
define([
  'bajaux/Widget',
  'bajaux/mixin/subscriberMixIn',
  'underscore' ], function (
  Widget,
  subscriberMixIn,
  _) {

  'use strict';

  // Return the constructor for a Widget subclass. This return value will define the contents of
  // this RequireJS module.
  return class MyFirstWidget extends Widget {
    constructor() {
      // This calls the super constructor.
      super(...arguments);

      // Applying a Subscriber MixIn adds subscription capabilities to a
      // Widget. Once added, the value passed into 'doLoad' is fully subscribed
      // and 'live'.
      subscriberMixIn(this);
    }

    /**
     * @param {JQuery} dom
     */
    doInitialize(dom) {
      // Widget initialization is where the HTML for the widget gets injected
      // into the browser's DOM. The 'dom' parameter has a jQuery wrapper around it
      // to make manipulating the DOM easier.

      const initialValue = 'value goes here';

      // when building HTML directly, remember to perform proper escaping to prevent XSS vulnerabilities.
      // _.escape() is only one of many ways to do this. Calling .text() instead of .html() on a
      // jQuery object is another.
      dom.html(`<input type="text" value="${ _.escape(initialValue) }" >`);

      // Update the DOM whenever a property changes on a component that has been loaded. Remember
      // a loaded component is guaranteed to be subscribed thanks to subscriberMixIn.
      this.getSubscriber().attach('changed', () => this.$updateDom(this.value()));
    }

    /**
     * When a new Ramp is loaded, immediately update the DOM to show its current properties.
     *
     * @param {baja.Component} ramp a `kitControl:Ramp`
     */
    doLoad(ramp) {
      this.$updateDom(ramp);
    }

    /**
     * @private
     * @param {baja.Component} ramp - a `kitControl:Ramp`
     */
    $updateDom(ramp) {
      this.jq().children('input').val(ramp.getOut().getValueDisplay());
    }
  };
});
