function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * @copyright 2024 Tridium, Inc. All Rights Reserved.
 */

/*eslint-env browser */

define(['underscore'], function (_) {
  'use strict';

  /**
   * API Status: **Private**
   *
   * Shared utility functions for accelerators.
   *
   * @exports bajaux/util/acceleratorUtils
   * @since Niagara 4.15
   */
  var exports = {};
  var invert = _.invert;
  var stringToKeyCode = {
    backspace: 8,
    tab: 9,
    space: 32,
    pageup: 33,
    pagedown: 34,
    left: 37,
    up: 38,
    right: 39,
    down: 40,
    "delete": 46,
    // 127 in BAccelerator
    end: 35,
    esc: 27,
    home: 36,
    insert: 45,
    // 155 in BAccelerator;
    f1: 112,
    f2: 113,
    f3: 114,
    f4: 115,
    f5: 116,
    f6: 117,
    f7: 118,
    f8: 119,
    f9: 120,
    f10: 121,
    f11: 122,
    f12: 123
  };
  var keyCodeToString = invert(stringToKeyCode);

  /**
   * Return true if the jq is within the Profile Level Command Group.
   * @param {JQuery} jq
   * @returns {boolean}
   */
  exports.isProfileCommandGroup = function (jq) {
    var commandButtonGroup = jq.closest(".CommandButtonGroup");
    return commandButtonGroup.length > 0 && commandButtonGroup.closest(".WebShell-content").find(".CommandButtonGroup").first()[0] === commandButtonGroup[0];
  };

  /**
   * Parse the accelerator.
   * @param {String|Object} acc
   * @returns {Object}
   */
  exports.parseAccelerator = function (acc) {
    var a = null,
      codes,
      c,
      i;
    if (acc) {
      if (acc && _typeof(acc) === "object") {
        a = acc;
      } else {
        a = {
          keyCode: acc.toUpperCase()
        };
      }

      // If we have a String then convert the character code.
      if (typeof a.keyCode === "string") {
        codes = a.keyCode.split("+");
        for (i = 0; i < codes.length; ++i) {
          c = codes[i];
          if (c.length === 1) {
            // Process keycode
            a.keyCode = c.charCodeAt(0);
          } else {
            c = c.toLowerCase();
            // Process modifiers
            if (c === "alt") {
              a.alt = true;
            } else if (c === "shift") {
              a.shift = true;
            } else if (c === "ctrl") {
              a.ctrl = true;
            } else if (c === "meta") {
              a.meta = true;
            } else {
              a.keyCode = stringToKeyCode[c];
            }
          }
        }
      }
      a.toString = function () {
        return toFriendlyAccelerator(a);
      };
    }
    return a;
  };

  /**
   * @param {module:bajaux/commands/Command} command
   * @param {Event} event
   * @param {boolean} [matchWhenDisabled=false]
   * @returns {boolean}
   */
  exports.isAcceleratorMatch = function (command, event) {
    var matchWhenDisabled = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var accelerator = command.getAccelerator();
    if (!matchWhenDisabled && !command.isEnabled() || !command.getAccelerator() || !(event instanceof KeyboardEvent)) {
      return false;
    }
    return event.keyCode === accelerator.keyCode && event.altKey === !!accelerator.alt && event.ctrlKey === !!accelerator.ctrl && event.shiftKey === !!accelerator.shift && event.metaKey === !!accelerator.meta;
  };

  /**
   * @param {String|Object} acc
   * @returns {string}
   */
  function toFriendlyAccelerator(acc) {
    if (!acc) {
      return '';
    }
    var objectStr;
    if (_typeof(acc) === "object") {
      var strings = [];
      if (acc.alt) {
        strings.push("alt");
      }
      if (acc.ctrl) {
        strings.push("ctrl");
      }
      if (acc.shift) {
        strings.push("shift");
      }
      if (acc.meta) {
        strings.push("meta");
      }
      if (acc.meta) {
        strings.push("meta");
      }
      if (acc.keyCode) {
        if (typeof acc.keyCode === "number") {
          if (keyCodeToString[acc.keyCode]) {
            strings.push(keyCodeToString[acc.keyCode]);
          } else {
            strings.push(String.fromCharCode(acc.keyCode));
          }
        } else {
          strings.push(acc.keyCode);
        }
      }
      objectStr = strings.join('+');
    } else {
      objectStr = acc;
    }

    // Split the input string into an array of words
    var str = objectStr.toLowerCase().split("+");

    // Iterate through each word in the array
    for (var i = 0, x = str.length; i < x; i++) {
      // Capitalize the first letter of each word and concatenate it with the rest of the word

      str[i] = str[i][0].toUpperCase() + str[i].substring(1);
    }

    // Join the modified array of words back into a string
    return str.join("+");
  }
  return exports;
});
