function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 */

define(['log!bajaux.spandrel', 'log!bajaux.spandrel.dom', 'log!bajaux.spandrel.lifecycle', 'log!bajaux.spandrel.timing', 'bajaux/spandrel/symbols', 'nmodule/js/rc/log/Log'], function (spandrelLog, domLog, lifecycleLog, timingLog, symbols, Log) {
  'use strict';

  var _Log$Level = Log.Level,
    FINE = _Log$Level.FINE,
    FINER = _Log$Level.FINER,
    FINEST = _Log$Level.FINEST;
  var INSTANCE_COUNTER_SYMBOL = symbols.INSTANCE_COUNTER_SYMBOL;
  var LIFECYCLE_LEVEL = FINE;
  var LIFECYCLE_DETAILS_LEVEL = FINER;
  var TIMING_DETAILS_LEVEL = FINEST;
  var DOM_DETAILS_LEVEL = FINEST;

  /**
   * API Status: **Private**
   * @exports bajaux/spandrel/logging
   */
  var exports = {};

  /**
   * @returns {boolean} whether we should log lifecycle events (coarse-grained diffing information)
   */
  exports.isLifecycleLoggable = function () {
    return spandrelLog.isLoggable(LIFECYCLE_LEVEL);
  };

  /**
   * @returns {boolean} whether we should log lifecycle details (finer info about exactly what is being diffed)
   */
  exports.areLifecycleDetailsLoggable = function () {
    return spandrelLog.isLoggable(LIFECYCLE_DETAILS_LEVEL);
  };

  /**
   * @returns {boolean} whether we should log very fine-grained timing info - "starting rerender",
   * "finished rerender", etc.
   */
  exports.areTimingDetailsLoggable = function () {
    return spandrelLog.isLoggable(TIMING_DETAILS_LEVEL);
  };

  /**
   * @returns {boolean} whether we want to see details about DOM changes (very chatty)
   */
  exports.areDomDetailsLoggable = function () {
    return domLog.isLoggable(DOM_DETAILS_LEVEL);
  };

  /**
   * @param {module:bajaux/Widget} owner
   * @param {string} msg
   * @param {...*} args
   * @returns {Promise}
   */
  exports.logLifecycle = function (owner, msg) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }
    return ownerLog(lifecycleLog, LIFECYCLE_LEVEL, owner, msg, args);
  };

  /**
   * @param {module:bajaux/Widget} owner
   * @param {string} msg
   * @param {...*} args
   * @returns {Promise}
   */
  exports.logLifecycleDetails = function (owner, msg) {
    for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
      args[_key2 - 2] = arguments[_key2];
    }
    return ownerLog(lifecycleLog, LIFECYCLE_DETAILS_LEVEL, owner, msg, args);
  };

  /**
   * @param {module:bajaux/Widget} owner
   * @param {string} msg
   * @param {...*} args
   * @returns {Promise}
   */
  exports.logTimingDetails = function (owner, msg) {
    for (var _len3 = arguments.length, args = new Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
      args[_key3 - 2] = arguments[_key3];
    }
    return ownerLog(timingLog, TIMING_DETAILS_LEVEL, owner, msg, args);
  };

  /**
   * @param {module:bajaux/Widget} owner
   * @param {string} msg
   * @param {...*} args
   * @returns {Promise}
   */
  exports.logDomDetails = function (owner, msg) {
    for (var _len4 = arguments.length, args = new Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
      args[_key4 - 2] = arguments[_key4];
    }
    return ownerLog(domLog, DOM_DETAILS_LEVEL, owner, msg, args);
  };

  /**
   * @param {module:bajaux/Widget} widget
   * @returns {string}
   */
  exports.widgetName = function (widget) {
    if (!widget) {
      return '<no widget>';
    }
    var name = widget.constructor.name;
    var counter = widget[INSTANCE_COUNTER_SYMBOL];
    return name + (counter ? " $(\"[data-spandrel-instance-counter=".concat(counter, "]\")[0]") : '');
  };

  /**
   * Turns on finest-level logging even if not configured in the station
   * @private
   */
  exports.$trace = function () {
    [spandrelLog, domLog, lifecycleLog, timingLog].forEach(function (l) {
      return l.setLevel(FINEST);
    });
  };
  function ownerLog(log, level, owner, msg, args) {
    return log.log.apply(log, [level, exports.widgetName(owner) + ': ' + msg].concat(_toConsumableArray(args)));
  }
  return exports;
});
