function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

define(['bajaux/spandrel', 'bajaux/Widget', 'bajaux/spandrel/jsx', 'bajaux/spandrel/symbols', 'bajaux/spandrel/util', 'Promise', 'underscore', 'nmodule/js/rc/asyncUtils/asyncUtils'], function (spandrel, Widget, jsx, symbols, util, Promise, _, asyncUtils) {
  'use strict';

  var isFunction = _.isFunction,
    isString = _.isString,
    once = _.once;
  var doRequire = asyncUtils.doRequire;
  var toEl = util.toEl;
  var jsxToSpandrel = jsx.jsxToSpandrel,
    $normalizeJsxEventHandlers = jsx.$normalizeJsxEventHandlers;
  var IS_SPANDREL_SYMBOL = symbols.IS_SPANDREL_SYMBOL,
    JSX_TYPE_SYMBOL = symbols.JSX_TYPE_SYMBOL,
    JSX_PROPS_SYMBOL = symbols.JSX_PROPS_SYMBOL,
    JSX_KIDS_SYMBOL = symbols.JSX_KIDS_SYMBOL,
    REIFY_SYMBOL = symbols.REIFY_SYMBOL;
  var IS_WIDGET_TAG_SYMBOL = Symbol('isWidgetTag');
  var requireUxModel = once(function () {
    return doRequire('bajaux/model/UxModel');
  }); // avoid circular dependency

  /**
   * API Status: **Private**
   * @since Niagara 4.14
   * @exports bajaux/model/jsxToUxModel
   */
  var exports = {};

  /**
   * Converts a chunk of JSX into spandrel data, using UxModel to configure the children of any
   * widgets that support them (e.g. Panes).
   *
   * This can return a promise that resolves directly to spandrel data, or a function that returns
   * the same. Both of these are valid widget node definitions to spandrel.
   *
   * @param {string|Function} type DOM tag name, or Widget constructor
   * @param {object} props configured properties, e.g. "className" for DOM or "formFactor" for Widget
   * @param {Array.<module:bajaux/spandrel/jsx~JsxInstructions>} jsxKids any child JSX nodes will
   * be Thenables at runtime. Note this is an array not varargs for ease of implementation here;
   * UxModel.jsx itself performs the conversion
   * @returns {module:bajaux/spandrel~SpandrelData}
   */
  exports.jsx = function (type, props, jsxKids) {
    var isWidgetTag = type === 'widget';
    if (isWidgetTag) {
      /*
      NCCB-64716: swap in an "any" tag so spandrel.jsx doesn't interpret <widget> as a raw dom element.
       */
      type = 'any';
      var uxModel = props.src;

      /*
       * here we manage the interactions where one "container" class receives instructions on how to
       * build a widget, and has the job of building it into a child element...
       *
       * // i'm Container and my job is to apply some CSS style to your widget!
       * class Container extends spandrel((uxModel) => (
       *   <widget className="my-special-css-style"                            // line A
       *           src={uxModel.get('content')}
       *           onclick={() => console.log('Container says hi')} />;
       * )) {}
       *
       * ...and another "wrapper" class that receives instruction on how to build a widget, and has
       * the job of handing directly off to that container class...
       *
       * // i'm Wrapper and my job is to put your widget into a Container!
       * class Wrapper extends spandrel((uxModel) => (
       *   <Container>
       *     <widget src={uxModel}                                             // line B
       *             name="content"
       *             onclick={() => console.log('Wrapper says hi')} />
       *   </Container>
       * )) {}
       *
       * our job here, is to ensure that any instructions that the container applies are respected,
       * and to *also* ensure that any instructions from the wrapper are respected by merging in
       * with the container instructions.
       *
       * when tracing through this function, imagine it running from the perspective of Container.
       * it's going to build out the widget the way it's configured to do so, and it's going to make
       * sure that it takes the instructions given to it from Wrapper into account as it does so.
       */
      if (uxModel) {
        var toSpandrel = uxModel.toSpandrel;
        (uxModel.$propsQueue || (uxModel.$propsQueue = [])).push(props);
        uxModel.toSpandrel = function () {
          // first, eat the event listeners out of the JSX. this will also update
          // props.properties.$quiet if needed. these handlers are yanked out from the element on line B.
          var spOn = $normalizeJsxEventHandlers(props);

          // let UxModel generate instructions on how to build the widget, taking into account all
          // instructions from line B...
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          return Promise.resolve(toSpandrel.apply(uxModel, args)).then(function (sp) {
            // let any values explicitly declared in the JSX (line A) override those instructions...
            sp = jsx.$clobber(sp, props);

            // ...and merge event handlers from JSX back in with those from the UxModel.
            sp.on = spOn.concat(sp.on || []);
            return sp;
          });
        };
        props.spandrelSrc = uxModel;
      }
      delete props.src;
    }
    var jsxInstructions = jsxToSpandrel.apply(void 0, [type, props].concat(_toConsumableArray(jsxKids)));
    type = jsxInstructions[JSX_TYPE_SYMBOL];
    props = jsxInstructions[JSX_PROPS_SYMBOL];
    jsxKids = jsxInstructions[JSX_KIDS_SYMBOL];
    if (isWidgetTag) {
      jsxInstructions[IS_WIDGET_TAG_SYMBOL] = true;
    }
    var isLoadingValue = props.hasOwnProperty('value') || props.hasOwnProperty('complex') && props.hasOwnProperty('slot');
    /*
     why is isWidget false when processing a <widget> tag?
      isWidget is when the widget type is coming straight from the jsx instructions, like when
     the developer types <BorderPane><Label/><BorderPane>. in this case we have to traverse the
     jsx tree and generate a UxModel that represents the widget tree intended by the developer.
      when using <widget>, it's a "leaf node" that hands off the definition of the widget structure
     to somebody else. like if i'm a BorderPane, i'd have a <widget src={uxModel.get('content')} />.
     the contents of that uxModel are invisible to me.
     */
    var isWidget = !isWidgetTag && (type === 'any' || isAssignableFrom(Widget, type));
    if (isWidget) {
      if (isLoadingValue) {
        if (jsxKids.length) {
          /*
          TODO: this *feels* like something you *should* be able to do.
          but i can't come up with a valid use case right now.
           */
          throw new Error('cannot load value and configure children at the same time');
        }

        // if a value is already specified, no reason to create a UxModel - it might already be one.
        // just build as normal.
        return jsxInstructions;
      }

      // we have a widget specified with no value being loaded. either we (a) don't care what value
      // gets loaded, in which case the UxModel will have no effect, or (b) a UxModel is what is
      // expected (and there are likely child widgets configured as well). so transmogrify this
      // whole tree into a UxModel.
      var makeUxModelForJsxNode = function makeUxModelForJsxNode() {
        return exports.toUxModel(jsxInstructions);
      };

      /**
       * There are now two code paths every JSX node that is converted to a UxModel can take.
       *
       * First, the "main" code path, that serves as the entry point for spandrel itself. This
       * takes the form of a function that spandrel will use when converting JSX to spandrel data
       * at runtime. The argument is the state of the owning widget (the widget who is instantiating
       * the SplitPane/BorderPane/whatever widget needs the UxModel). When going down this code
       * path, we will search the whole JSX structure for bind keys and ensure they are all bound
       * to the actual owner widget. This allows, say, the BorderPane's "content" widget to be
       * bound to the widget that's instantiating the BorderPane, and not to the BorderPane itself.
       * Only the top-level widget goes down this path.
       *
       * The second code path is just to convert the data to a UxModel, because the child widgets of
       * a UxModel are themselves defined by UxModels. We tack on a reference to this code path as
       * `makeUxModel` for consumption by the child nodes. This path skips the state key stealing
       * phase.
       */
      return _defineProperty(_defineProperty(_defineProperty({}, REIFY_SYMBOL, function (ownerState) {
        confiscateBindKeys(jsxInstructions, ownerState.self);
        return exports.toUxModel(jsxInstructions, {
          jsxDirect: true
        }).then(function (uxModel) {
          props.value = uxModel;
          // the definitions of kid nodes in the JSX have been swallowed up into the UxModel itself.
          jsxInstructions[JSX_KIDS_SYMBOL] = [];
          return jsxInstructions;
        });
      }), IS_SPANDREL_SYMBOL, true), "makeUxModel", makeUxModelForJsxNode);
    }
    return jsxInstructions;
  };
  function confiscateBindKeys(jsxInstructions, owner) {
    var props = jsxInstructions[JSX_PROPS_SYMBOL];
    var jsxKids = jsxInstructions[JSX_KIDS_SYMBOL];
    var bindKey = props && props.bindKey;
    if (bindKey) {
      delete props.bindKey;
      props.stateBinding = {
        key: bindKey,
        target: owner
      };
    }
    if (jsxKids) {
      jsxKids.forEach(function (kid) {
        return confiscateBindKeys(kid, owner);
      });
    }
  }

  /**
   * @param {module:bajaux/spandrel/jsx~JsxInstructions} jsxInstructions
   * @param {object} [params]
   * @param {boolean} [params.jsxDirect] true if the purpose of this UxModel is simply to load into
   * the widget specified by this JSX element. it will not override toSpandrel or eat event handlers
   * in this case.
   * @returns {Promise.<module:bajaux/model/UxModel>}
   */
  exports.toUxModel = function (jsxInstructions, params) {
    var type = jsxInstructions[JSX_TYPE_SYMBOL],
      props = jsxInstructions[JSX_PROPS_SYMBOL],
      kids = jsxInstructions[JSX_KIDS_SYMBOL],
      isWidgetTag = jsxInstructions[IS_WIDGET_TAG_SYMBOL];
    var isWidget = isFunction(type) || type === 'any' || isWidgetTag;
    var jsxDirect = params && params.jsxDirect;
    if (type === 'any') {
      type = undefined;
    } else if (!isWidget) {
      type = spandrel(kids.map(function (kid) {
        if (isString(kid)) {
          // vanilla spandrel treats a string as an HTML string; in JSX world only actual text
          // content is a string so can safely wrap it in a span.
          // TODO: i need a spandrel.TextNode or something so i can actually do <div>My Widget: <Widget/></div>
          var span = document.createElement('span');
          span.textContent = kid;
          return _defineProperty({
            dom: span
          }, IS_SPANDREL_SYMBOL, true);
        }
        return kid;
      }));
    }
    var name = props.name,
      spandrelKey = props.spandrelKey,
      value = props.value;
    if (name && spandrelKey) {
      throw new Error('cannot apply spandrelKey to named UxModel children (if binding, use bindKey instead)');
    }
    delete props.name; // name is for the UxModel, not for the DOM element

    return requireUxModel().then(function (UxModel) {
      var uxModel = isWidgetTag && props.spandrelSrc instanceof UxModel && props.spandrelSrc;
      if (uxModel) {
        if (kids.length) {
          throw new Error('cannot combine widget/src with child elements');
        }
        uxModel.$obj.name = name;
        return uxModel;
      }
      return resolveKidUxModels(UxModel, value, kids).then(function (kidUxModels) {
        // $normalizeJsxEventHandlers has to get called before we pull the properties out.
        // this is because it sets $quiet: false to ensure that quieted events like initialize
        // still propagate, and this is core bajaux/Widget behavior, so it has to get applied
        // in properties when the widget is built.
        var on = !jsxDirect && $normalizeJsxEventHandlers(props);

        // grab the state binding that was already populated by the top-level widget...
        var properties = props.properties,
          value = props.value,
          readonly = props.readonly,
          formFactor = props.formFactor,
          lax = props.lax,
          stateBinding = props.stateBinding,
          bindings = props.bindings;

        // ... and make sure the state binding gets applied to the child widgets defined by the UxModel

        return UxModel.make({
          type: type,
          name: name,
          properties: properties,
          value: value,
          readonly: readonly,
          formFactor: formFactor,
          bindings: bindings,
          kids: kidUxModels
        }).then(function (uxModel) {
          if (jsxDirect) {
            return uxModel;
          }
          var toSpandrel = uxModel.toSpandrel;
          uxModel.toSpandrel = function (params) {
            if (isDom(params)) {
              params = {
                dom: params
              };
            }
            if (params && params.dom) {
              var dom = toEl(params.dom);
              jsx.$applyJsxToDom(jsxInstructions, dom);
              params.dom = dom;
            }
            var sp = toSpandrel.call(uxModel, params);
            if (!isWidget) {
              delete sp.value;
            }
            sp.stateBinding = stateBinding;
            sp.lax = lax;
            sp.on = on;
            return sp;
          };
          return uxModel;
        });
      });
    });
  };
  function isDom(dom) {
    return typeof dom === 'string' || dom instanceof HTMLElement;
  }
  function resolveKidUxModels(UxModel, value, kids) {
    if (value instanceof UxModel) {
      return Promise.resolve([value]);
    }

    // kids that are JSX instructions, or derived from JSX instructions.
    // omit plain text nodes.

    var jsxInstructionKids = kids.filter(function (kid) {
      return kid && typeof kid !== 'string';
    });
    return Promise.all(jsxInstructionKids.map(function (kid) {
      return unwrapPromise(kid).then(function (_ref3) {
        var kid = _ref3.kid;
        if (isFunction(kid.makeUxModel)) {
          return kid.makeUxModel();
        }
        return exports.toUxModel(kid);
      });
    }));
  }

  /**
   * A kid may be defined async, like any spandrel kid (i.e. it's thenable, but *not* thenable like
   * JsxInstructions is thenable-to-reify) - resolve it to actual spandrel data before processing.
   * Can't just pass it straight to Promise.resolve() because it's not ready to be reified yet.
   * @param {Promise.<module:bajaux/spandrel~SpandrelData>|module:bajaux/spandrel~SpandrelData} kid
   * @returns {Promise.<{ kid: module:bajaux/spandrel~SpandrelData}>}
   */
  function unwrapPromise(kid) {
    if (kid[IS_SPANDREL_SYMBOL]) {
      return Promise.resolve({
        kid: kid
      });
    }
    return Promise.resolve(kid).then(function (kid) {
      return {
        kid: kid
      };
    });
  }
  function isAssignableFrom(superClass, subClass) {
    if (!superClass || !subClass) {
      return false;
    }
    var superCtor = typeof superClass === 'function' ? superClass : superClass.constructor,
      subCtor = typeof subClass === 'function' ? subClass : subClass.constructor;
    return Object.create(subCtor.prototype) instanceof superCtor;
  }
  return exports;
});
