function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Development**
 * @module bajaux/model/binding/BindingList
 */
define(['Promise'], function (Promise) {
  'use strict';

  /**
   * Data structure for storing a collection of Bindings.
   * @class
   * @alias module:bajaux/model/binding/BindingList
   */
  return /*#__PURE__*/function () {
    function BindingList() {
      var bindings = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      _classCallCheck(this, BindingList);
      this.$setNewBindingsArray(bindings);
    }

    /**
     * @returns {Array.<module:bajaux/model/binding/IBinding>}
     */
    return _createClass(BindingList, [{
      key: "getBindings",
      value: function getBindings() {
        return this.$bindings.slice();
      }

      /**
       * Saves all bindings.
       * @returns {Promise}
       */
    }, {
      key: "saveAll",
      value: function saveAll() {
        return Promise.all(this.$bindings.map(function (b) {
          return b.save();
        }));
      }

      /**
       * Run an (optionally async) function against each binding in the list.
       * All function calls will run in serial, not parallel.
       * @param {Function} func function to receive the binding and the index in
       * the binding array
       * @returns {Promise.<Array.<*>>} results of each function call
       */
    }, {
      key: "map",
      value: function map(func) {
        var results = [];
        return this.$bindings.reduce(function (prom, b, i) {
          return prom.then(function () {
            return func(b, i);
          }).then(function (r) {
            return results.push(r);
          });
        }, Promise.resolve()).then(function () {
          return results;
        });
      }

      /**
       * @private
       * @param {Array.<module:bajaux/model/binding/IBinding>} bindings 
       */
    }, {
      key: "$setNewBindingsArray",
      value: function $setNewBindingsArray(bindings) {
        var _this = this;
        this.$bindings = bindings;
        bindings.forEach(function (binding) {
          binding.$bindingList = _this;
        });
      }
    }]);
  }();
});
