function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Development**
 * @module bajaux/model/UxModel
 */
define(['bajaux/Widget', 'Promise', 'underscore', 'bajaux/mixin/mixinUtils', 'bajaux/model/binding/BindingList', 'bajaux/model/jsxToUxModel'], function (Widget, Promise, _, mixinUtils, BindingList, jsxToUxModel) {
  'use strict';

  var first = _.first,
    map = _.map,
    rest = _.rest;
  var _jsx = jsxToUxModel.jsx;
  var hasMixin = mixinUtils.hasMixin;

  /**
   * we use this to cache the default properties
   * @type {symbol}
   */
  var DEFAULT_PROPS_SYMBOL = Symbol('$defaultProperties');

  /**
   * we use this to cache the meta properties
   * @type {symbol}
   */
  var META_PROPS_SYMBOL = Symbol('$metaProperties');

  /**
   * Represents all information needed to create one widget, and its children.
   *
   * Note that this is not `spandrel` data. This is an intermediate, abstracted
   * data model that is a representation of a tree of widgets and bindings that
   * would make up a graphic or portion of a graphic. (In other words, a `.px`
   * file would translate readily into a `UxModel`.) But `UxModel` is also
   * intended to provide usable `spandrel` data to be used at rendering time.
   *
   * @class
   * @alias module:bajaux/model/UxModel
   */
  var UxModel = /*#__PURE__*/function () {
    /**
     * Don't call directly - use `make()` instead.
     * @private
     */
    function UxModel() {
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _classCallCheck(this, UxModel);
      this.$obj = extendParams(obj);
      delete this.$obj.bindings;
      delete this.$obj.metaProperties;
      this.$obj.kids = processKids(obj.kids);
      this.$bindingList = new BindingList(obj.bindings);
      this.$obj[META_PROPS_SYMBOL] = obj.metaProperties || {};
    }

    /**
     * @private
     * @param {module:bajaux/Widget} widget
     * @returns {module:bajaux/model/UxModel|null} the UxModel loaded into this widget, whether it has
     * UxModelSupport or not.
     * @since Niagara 4.15
     */
    return _createClass(UxModel, [{
      key: "clone",
      value:
      /**
       * Creates a new, equivalent copy of this UxModel, including cloning all of its kids.
       *
       * @param {module:bajaux/model/UxModel~UxModelParams} params if specified, these parameters
       * will be applied to the clone (not including `kids`)
       * @returns {Promise.<module:bajaux/model/UxModel>} to be resolved to a clone of this UxModel
       * @since Niagara 4.15
       */
      function clone(params) {
        var metaProperties = Object.assign({}, this.$obj[META_PROPS_SYMBOL]);
        var obj = extendParams(this.$obj, {
          bindings: this.getBindingList().getBindings(),
          metaProperties: metaProperties
        }, params);
        return Promise.all((obj.kids || []).map(function (kid) {
          return kid.clone();
        })).then(function (kidClones) {
          obj.kids = kidClones;
          return new UxModel(obj);
        });
      }

      /**
       * @returns {string}
       */
    }, {
      key: "getName",
      value: function getName() {
        return this.$obj.name;
      }

      /**
       * @param {string|string[]} path
       * @returns {module:bajaux/model/UxModel|module:bajaux/model/binding/IBinding|undefined} the UxModel
       * kid by the given name. If an array of names is given, this will follow the
       * path down through the UxModel structure.
       */
    }, {
      key: "get",
      value: function get(path) {
        if (!Array.isArray(path)) {
          path = [path];
        }
        return byName(this, path);
      }

      /**
       * @returns {Function} constructor for the widget to create
       */
    }, {
      key: "getType",
      value: function getType() {
        return this.$obj.type;
      }

      /**
       * @returns {module:bajaux/model/binding/BindingList}
       */
    }, {
      key: "getBindingList",
      value: function getBindingList() {
        return this.$bindingList;
      }

      /**
       * @returns {Array.<module:bajaux/model/UxModel>} UxModel
       * instances for this widget's children
       */
    }, {
      key: "getKids",
      value: function getKids() {
        var _this$$obj$kids = this.$obj.kids,
          kids = _this$$obj$kids === void 0 ? [] : _this$$obj$kids;
        return kids.slice();
      }

      /**
       * @returns {object} object literal describing this widget's properties. This includes any
       * default properties configured in the Widget's constructor.
       */
    }, {
      key: "getProperties",
      value: function getProperties() {
        var obj = this.$obj;
        var properties = obj.properties || {};
        if (!this.$widgetPropertiesApplied) {
          var Ctor = this.getType();
          if (Ctor) {
            var newProps = this.$getDefaultProperties(properties);
            properties = obj.properties = newProps;
          }
          this.$widgetPropertiesApplied = true;
        }
        return properties;
      }

      /**
       * @returns {object} object literal describing this widget's default properties
       * @since Niagara 4.15
       */
    }, {
      key: "getDefaultProperties",
      value: function getDefaultProperties() {
        return this.$getDefaultProperties();
      }

      /**
       * @private
       * @param [properties] Additional properties to add onto the Default Properties
       * @returns {Object} properties
       * @since Niagara 4.15
       */
    }, {
      key: "$getDefaultProperties",
      value: function $getDefaultProperties() {
        var properties = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        return this.$getDefaultPropertiesInfo(properties).properties;
      }

      /**
       * Get information about the default properties of a bajaux Widget. These are the properties
       * that are set in the JS constructor of the bajaux Widget, typically passed as `defaults` to
       * the Widget constructor.
       *
       * @private
       * @param {Object} [properties] Additional properties to add onto the Default Properties
       * @returns {Object} obj an object with properties and metaProperties
       * @since Niagara 4.15
       */
    }, {
      key: "$getDefaultPropertiesInfo",
      value: function $getDefaultPropertiesInfo() {
        var properties = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var Ctor = this.getType();
        var currentMetaProperties = this.$obj[META_PROPS_SYMBOL] || {};
        if (Ctor) {
          var propertyInfo = getDefaultPropertiesInfo(Ctor);
          var defaultProperties = this.$obj[DEFAULT_PROPS_SYMBOL] = propertyInfo.properties;
          var _metaProperties = this.$obj[META_PROPS_SYMBOL] = Object.assign(shallowClone(currentMetaProperties), propertyInfo.metaProperties);
          return {
            properties: Object.assign(shallowClone(defaultProperties), properties),
            metaProperties: _metaProperties
          };
        }
        var metaProperties = this.$obj[META_PROPS_SYMBOL] || {};
        return {
          properties: properties,
          metaProperties: metaProperties
        };
      }

      /**
       * adds information to the metaProperties of a UxModel for web widget properties
       * @private
       * @param {Object} webWidgetMetaProperties
       * @returns {Object}
       */
    }, {
      key: "$addWebWidgetMetaProperties",
      value: function $addWebWidgetMetaProperties(webWidgetMetaProperties) {
        var currentMetaProperties = this.$obj[META_PROPS_SYMBOL] || {};
        Object.keys(webWidgetMetaProperties).forEach(function (key) {
          var prop = webWidgetMetaProperties[key];
          prop.webWidgetProperty = true;
        });
        currentMetaProperties = this.$obj[META_PROPS_SYMBOL] = Object.assign(shallowClone(currentMetaProperties), webWidgetMetaProperties);
        return currentMetaProperties;
      }

      /**
       * @private
       * @param {function} superCtor
       * @returns {Boolean} if the type of this UxModel is the given constructor, or a subclass of it
       */
    }, {
      key: "$represents",
      value: function $represents(superCtor) {
        return isAssignableFrom(superCtor, this.getType());
      }

      /**
       * returns the meta properties information for a property
       * @private
       * @param {String} propName the name of the property in the UxModel that you want the meta
       * properties information for
       * @returns {Object}
       */
    }, {
      key: "$getMetaPropertyInfo",
      value: function $getMetaPropertyInfo(propName) {
        return this.$getDefaultPropertiesInfo().metaProperties[propName];
      }

      /**
       * Returns any metadata provided to the constructor.
       *
       * @since Niagara 4.15
       * @returns {object}
       */
    }, {
      key: "getMetadata",
      value: function getMetadata() {
        return this.$obj.metadata || {};
      }

      /**
       * @returns {*|null} the value to be loaded into this widget
       */
    }, {
      key: "getValue",
      value: function getValue() {
        return this.$obj.value;
      }

      /**
       * @since Niagara 4.14
       * @returns {boolean} true if this widget should be readonly
       */
    }, {
      key: "isReadonly",
      value: function isReadonly() {
        return !!this.$obj.readonly;
      }

      /**
       * @since Niagara 4.14
       * @returns {string|undefined} the form factor this widget should be constructed with, if known
       */
    }, {
      key: "getFormFactor",
      value: function getFormFactor() {
        return this.$obj.formFactor;
      }

      /**
       * Produce a `spandrel` config object that represents this Ux element as
       * rendered in the DOM. The `value` property will always be `this`, as the
       * `UxModel` will be loaded into the `spandrel` widget as the value.
       *
       * Remember that the `spandrel` data will contain any bindings present in
       * the model as well! Beware of simply passing back `toSpandrel()` results
       * from the `UxModel` passed to your render function - you may get duplicate
       * bindings. `toSpandrel()` is typically more appropriate for calling on
       * kids.
       *
       * @param {object|string|Function} params parameters used for generating the
       * `spandrel` data; can also be `dom` passed directly as a string or
       * function
       * @param {string|Function} params.dom the DOM element into which to render
       * this element. Can be a function that receives an object with
       * `properties`, which are the properties of this Ux element, to be used to
       * generate the DOM
       * @param {Array.<object>|Function} [params.kids] You can specify the `kids`
       * property of the `spandrel` config directly. Alternately, this can be a
       * function that receives each `UxModel` in `getKids()`, and returns
       * `kid.toSpandrel()` or a `spandrel` object of your choosing.
       * @returns {object} an object fit to be passed as a `spandrel` argument
       */
    }, {
      key: "toSpandrel",
      value: function toSpandrel() {
        var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        if (isDom(params) || typeof params === 'function') {
          params = {
            dom: params
          };
        }
        var _params = params,
          dom = _params.dom,
          kids = _params.kids;
        var properties = this.getProperties();
        if (typeof dom === 'function') {
          dom = dom({
            properties: properties
          });
        }
        if (typeof kids === 'function') {
          kids = this.getKids().map(kids);
        }
        var value = this.getValue();
        return {
          dom: dom,
          enabled: properties.enabled !== false,
          kids: kids,
          properties: properties,
          readonly: this.$obj.readonly,
          formFactor: this.getFormFactor(),
          type: this.getType(),
          value: value === undefined ? this : value,
          data: {
            bindingList: this.getBindingList()
          }
        };
      }

      /**
       * @returns {string}
       * @since Niagara 4.15
       */
    }, {
      key: "toString",
      value: function toString() {
        var name = this.getName() || '{none}';
        var type = this.getType();
        var typeName = type ? type.name : '{none}';
        var properties = this.getProperties();
        var propsString = "properties={".concat(Object.keys(properties).map(function (key) {
          return "".concat(key, "=").concat(properties[key]);
        }).join(', '), "}");
        return "UxModel[name=".concat(name, ", type=").concat(typeName, ", ").concat(propsString, "]");
      }

      /**
       * Visit this model and all their kid models, calling the passed in function
       * along the way.
       * @param {Function} func called for every model and its kid models. The model 
       *                        itself will be passed as the first parameter. 
       *                        Visiting stops once the function returns false.
       * @returns {Promise<*>}
       * @since Niagara 4.15
       */
    }, {
      key: "visit",
      value: function visit(func) {
        var _this = this;
        return Promise.resolve(func(this)).then(function (returnValue) {
          if (returnValue === false) {
            return false;
          }
          return Promise.all(_this.getKids().map(function (kid) {
            return Promise.resolve(kid.visit(func));
          }));
        });
      }

      /**
       * @private
       * @param {...module:bajaux/model/UxModel~UxModelParams} [args]
       * @returns {module:bajaux/model/UxModel~UxModelParams}
       * @since Niagara 4.15
       */
    }], [{
      key: "in",
      value: function _in(widget) {
        var uxModel = null;
        if (widget) {
          if (hasMixin(widget, 'UxModelSupport')) {
            uxModel = widget.getModel();
          } else {
            uxModel = widget.value();
          }
        }
        return uxModel instanceof UxModel ? uxModel : null;
      }

      /**
       * Creates a new UxModel from a configuration object. If an existing `UxModel` is given, this
       * creates a clone of that model.
       *
       * @param {module:bajaux/model/UxModel~UxModelParams} obj
       * @returns {Promise.<module:bajaux/model/UxModel>} a newly configured `UxModel` instance, or a
       * clone
       */
    }, {
      key: "make",
      value: function make(obj) {
        if (obj instanceof UxModel) {
          return obj.clone();
        } else {
          // TODO: resolve baja types in properties/bindings
          return Promise.resolve(new UxModel(obj));
        }
      }

      /**
       * @private
       * @see module:bajaux/model/jsxToUxModel
       */
    }, {
      key: "jsx",
      value: function jsx(type, props) {
        for (var _len = arguments.length, kids = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
          kids[_key - 2] = arguments[_key];
        }
        return _jsx(type, props || {}, kids);
      }
    }, {
      key: "$extendParams",
      value: function $extendParams() {
        return extendParams.apply(void 0, arguments);
      }
    }]);
  }();
  function processKids(kids) {
    if (!kids) {
      return [];
    }
    return map(kids, function (kid, name) {
      if (!(kid instanceof UxModel)) {
        kid = new UxModel(kid);
      }
      var obj = kid.$obj;
      obj.name = obj.name || String(name);
      return kid;
    });
  }
  function byName(model, path) {
    if (!path.length) {
      return model;
    }
    var obj = model.$obj;
    var name = first(path);
    var kids = obj.kids;
    var kid;
    if (Array.isArray(kids)) {
      kid = kids.find(function (k) {
        return k.getName() === String(name);
      });
    } else {
      kid = kids[name];
    }
    if (!kid) {
      var binding = model.$bindingList.getBindings().find(function (b) {
        return b.getName() === name;
      });
      return binding || undefined;
    }
    return byName(kid, rest(path));
  }
  function isDom(dom) {
    return typeof dom === 'string' || dom instanceof HTMLElement;
  }
  function getDefaultPropertiesInfo(Ctor) {
    var ctorProperties = {};
    var ctorMetaProperties = {};
    var widget = new Ctor();
    if (widget instanceof Widget) {
      // accessing via private variables is bad - but this is a super
      // hotspot so must be fast
      var arr = widget.$properties.$array;
      for (var i = 0, len = arr.length; i < len; ++i) {
        var prop = arr[i];
        var def = prop.defaultValue;
        if (def !== null && def !== undefined) {
          ctorProperties[prop.name] = def;
          ctorMetaProperties[prop.name] = prop;
        }
      }
    }
    return {
      properties: ctorProperties,
      metaProperties: ctorMetaProperties
    };
  }

  /**
   * _.extend doesn't support Symbols.
   * @param {...object} objs
   * @returns {object}
   */
  function extend() {
    return Object.assign.apply(Object, arguments);
  }
  function shallowClone(obj) {
    return extend({}, obj);
  }
  function extendParams() {
    return Array.prototype.slice.call(arguments).reduce(function () {
      var baseParams = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var subParams = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return extend(shallowClone(baseParams), subParams, {
        properties: extend(shallowClone(baseParams.properties), subParams.properties),
        metadata: extend(shallowClone(baseParams.metadata), subParams.metadata)
      });
    }, {});
  }

  /**
   * Check to see if one constructor is a subclass of another constructor.
   *
   * @param {Function} superCtor constructor function
   * @param {Function} subCtor constructor function
   * @returns {Boolean} true if subCtor inherits from superCtor, or if they
   * are the same constructor
   */
  function isAssignableFrom(superCtor, subCtor) {
    if (typeof superCtor !== 'function' || typeof subCtor !== 'function') {
      return false;
    }
    return Object.create(subCtor.prototype) instanceof superCtor;
  }
  return UxModel;
});

/**
 * @typedef {object} module:bajaux/model/UxModel~UxModelParams
 * @property {string} [name] the name of the widget represented by this
 * `UxModel`. This will be automatically set on child nodes; a parent-less
 * root widget may have no name or a name arbitrarily chosen.
 * @property {Function} [type] the Type of the widget to create
 * @property {object} [properties] an object literal of the widget's
 * properties
 * @property {boolean} [readonly] true if the widget should be readonly
 * @property {string} [formFactor] the form factor this widget should be constructed with, if known
 * @property {Array.<object|module:bajaux/model/UxModel>} [kids] objects
 * describing the widget's children
 * @property {Array.<module:bajaux/model/binding/IBinding>} [bindings] bindings
 * to propagate data updates to the widget (these will be assigned to a
 * `BindingList`)
 * @property {*} [value] can be specified if loading a value
 * @property {object} [metadata] (since Niagara 4.15) append any special-purpose metadata to this
 * UxModel. This data is for framework use and will not be applied to the actual Widget built by
 * this UxModel.
 */
