function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/* eslint-env browser */

/**
 * The bajaux Container for a Workbench environment.
 * This Container works in conjunction with custom Java callbacks
 * so the widget can load as appropriate in a Workbench Java environment.
 * This JavaScript is only intended to run in the Workbench Web Browser.
 *
 * @module bajaux/container/wb/wbContainer
 * @private
 */
define(['baja!', 'hbs!bajaux/container/error', 'lex!bajaux', 'log!nmodule.bajaux.rc.container.wb.wbContainer', 'bajaux/events', 'bajaux/Widget', 'bajaux/commands/Command', 'bajaux/container/wb/Clipboard', 'bajaux/container/util', 'dialogs', 'jquery', 'Promise', 'underscore'], function (baja, errorTemplate, lexs, log, events, Widget, Command, Clipboard, util, dialogs, $, Promise, _) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    bajauxLex = _lexs[0];
  var logSevere = log.severe.bind(log);
  var applyWebPropertyToWidget = util.applyWebPropertyToWidget,
    encodeToWebPropertyDefinition = util.encodeToWebPropertyDefinition;
  function defer() {
    var res,
      rej,
      // eslint-disable-next-line promise/avoid-new
      promise = new Promise(function (resolve, reject) {
        res = resolve;
        rej = reject;
      });
    return {
      resolve: res,
      reject: rej,
      promise: promise
    };
  }
  var exports = {},
    initDf,
    loadDf,
    containerJq,
    jq,
    errorJq,
    bodyJq,
    setValueOptions = "ext",
    setMetadataOptions = "ext",
    detachDom = false,
    // Switched off by default as it's causing too many problems.
    containerOptions,
    updateProperties,
    UNRECOVERABLE_FAIL_EVENTS = [events.INITIALIZE_FAIL_EVENT, events.LOAD_FAIL_EVENT, events.DESTROY_FAIL_EVENT],
    RUNTIME_FAIL_EVENTS = [events.ENABLE_FAIL_EVENT, events.DISABLE_FAIL_EVENT, events.SAVE_FAIL_EVENT, events.READONLY_FAIL_EVENT, events.WRITABLE_FAIL_EVENT
    //        events.command.FAIL_EVENT //SAVE_FAIL_EVENT and command FAIL_EVENT double up.
    ],
    isSavePending = false;
  baja.comm.setCommFailCallback(function commFail(err) {
    // TODO: once Workbench dialogs are implemented, we should make a pop up here
    // for this error (just like Hx).
    baja.error("Comms fail: " + err);
  });

  /**
   * This is an object used only for Java-JS interop. Calling methods on it will call straight
   * through to methods that act on the Java BWebWidget.
   *
   * To learn about this object's interface, see how it is built up in `WebWidgetInterop.java`.
   *
   * @returns {object}
   */
  function getWbInteropUtil() {
    return window.niagara.wb.util;
  }

  /**
   * This is an object used in the same way as the usual `niagara.env` namespace, but implemented
   * using Java-JS interop. It is also built up in `WebWidgetInterop.java`.
   *
   * @returns {object}
   */
  function getWbInteropEnv() {
    return window.niagara.env;
  }

  /**
   * Get the current bajaux Widget that is the content of the BWebWidget. Returns undefined if it
   * is not instantiated yet.
   *
   * @returns {module:bajaux/Widget|undefined}
   */
  function getContentWidget() {
    return window.wbWidget;
  }

  /**
   * Delete the current content widget.
   *
   * @param {module:bajaux/Widget} [widget] if known, the new webWidget to be assigned to `window.wbWidget`
   * @returns {module:bajaux/Widget | undefined} the existing content widget, if there was one
   */
  function wipeContentWidget(widget) {
    var wbWidget = getContentWidget();
    delete window.wbWidget;
    if (widget) {
      //Rapid refreshes can happen, so we need to make sure that the pending wbWidget gets set as soon as possible
      window.wbWidget = widget;
    }
    return wbWidget;
  }

  /**
   * @returns {Promise}
   */
  function layoutContentWidget() {
    var wbWidget = getContentWidget();
    return Promise.resolve(wbWidget && wbWidget.isInitialized() && wbWidget.layout());
  }

  /**
   * Used to convert an ORD to a hyperlink. In the case of Workbench, no conversion is required
   * including replacement of backups ("../").  For details regarding backups replacement see
   * NCCB-18551.
   *
   * @inner
   *
   * @param  {String} ordStr The ORD String.
   * @returns {Promise} The promise that resolves with the
   * converted ORD.
   */
  function toHyperlink(ordStr) {
    return Promise.resolve(ordStr);
  }

  /**
   * Translate a drag operation into Workbench world.
   *
   * @inner
   *
   * @param {String|Object} json a JSON encoded string, or an object to
   * be encoded to JSON. The encoded object should have a String `mime`
   * property, and an Array `data` property.
   * @param {JQuery.Event} ev the jQuery dragstart event
   * @returns {boolean} false to cancel?
   */
  function startDrag(json, ev) {
    var wbutil = getWbInteropUtil(),
      modifiers = 0;
    if (ev.shiftKey) {
      modifiers |= 1;
    }
    if (ev.ctrlKey) {
      modifiers |= 2;
    }
    if (ev.altKey) {
      modifiers |= 8;
    }
    if (typeof json !== "string") {
      json = $.isArray(json) ? json : [json];
      json = JSON.stringify(json);
    }

    // This corresponds to BWebWidget$WebWidgetUtil#startDrag
    wbutil.startDrag(JSON.stringify({
      drag: json,
      x: ev.pageX || 0,
      y: ev.pageY || 0,
      modifiers: modifiers
    }));
    return false;
  }

  /**
   * Close any open dialogs boxes.
   */
  function closeAllDialogs() {
    dialogs.each(function (i, dlg) {
      dlg.close();
    });
  }

  /**
   * Called when an error occurs in bajaux.
   *
   * @private
   *
   * @param  widget The widget instance the error occurred on.
   * @param  {String} type The type of error that occurred.
   * @param  err The error information.
   */
  function error(widget, type, err) {
    baja.error(err);
    jq.hide();
    var params = {
      title: bajauxLex.get("error.title"),
      message: bajauxLex.get("error.message"),
      details: bajauxLex.get("error.details"),
      type: type,
      moduleName: widget ? widget.$moduleName : "bajaux",
      keyName: widget ? widget.$keyName : "widget",
      stack: err + (err && err.stack ? '\n' + err.stack : '')
    };

    // Remove any existing error messages
    errorJq.empty();
    errorJq.html(errorTemplate(params));
    errorJq.show();
    closeAllDialogs();
    var wbWidget = getContentWidget();
    if (wbWidget) {
      // Remove the widget
      wipeContentWidget();
      if (wbWidget.isInitialized()) {
        wbWidget.destroy();
      }

      // This should stop the commands from being shown.
      getWbInteropUtil().buildCommands(null);
    }
    getWbInteropUtil().error(err instanceof Error ? err.message : err);
  }

  /**
   * Handles runtime errors that are triggered. If save is pending, the error will
   * not display until after the save if complete.
   * @param {jQuery.Event} e
   * @param {module:bajaux/Widget} sourceWidget
   * @param {Error} err
   */
  function handleRuntimeError(e, sourceWidget, err) {
    var widget = getContentWidget();
    var isBaseWidget = widget && widget === sourceWidget;
    if (isBaseWidget) {
      baja.error(err);
      var error = err instanceof Error ? err.message : err;
      if (isSavePending) {
        showNativeErrorDialog(error);
      } else {
        dialogs.showOk({
          title: bajauxLex.get('error.title'),
          text: err instanceof Error ? err.message : err
        });
      }
    }
  }

  /**
   * Shows a native error dialog. Requires widget to be in the save process for
   * dialog to display.
   * @param {string} msg
   */
  function showNativeErrorDialog(msg) {
    getWbInteropUtil().saveFail(msg);
  }
  function reattachContainer() {
    if (!containerJq.parent().length) {
      bodyJq.append(containerJq);
      // TODO return this promise
      layoutContentWidget()["catch"](logSevere);
    }
  }

  /**
   * @param {module:bajaux/Widget} widget
   * @param {string} propName
   * @param {module:bajaux/Properties~PropertyDefinition} updatedProp
   * @returns {Promise}
   */
  function updateProperty(widget, propName, updatedProp) {
    var properties = widget.properties();
    var existingProp = properties.get(propName);
    var value = updatedProp.value,
      metadata = updatedProp.metadata;
    if (existingProp) {
      return applyWebPropertyToWidget(Object.assign({
        name: propName
      }, updatedProp), widget, {
        setValueOptions: setValueOptions,
        setMetadataOptions: setMetadataOptions
      });
    } else if (propName === 'enabled') {
      // 'enabled' is the only property we're allowed to add
      // TODO because ____
      properties.add({
        name: propName,
        value: value
      });
      if (metadata) {
        properties.setMetadata(propName, metadata, setMetadataOptions);
      }
    }
    return Promise.resolve();
  }
  $(window).resize(function () {
    layoutContentWidget()["catch"](logSevere);
  });

  /**
   * Sets the options for the life time of the container. This is called once
   * when the container is first created.
   *
   * @param {Object} options An object that contains the options for
   * the container.
   */
  exports.initializeContainer = function initializeContainer(options) {
    containerOptions = options;
    containerJq = $("#bajaux-container");
    jq = $("#bajaux-widget");
    errorJq = $("#bajaux-error");
    bodyJq = $("body");
    bodyJq.css('margin', '0px'); /* NCCB-20798 */
  };

  /**
   * Update a Widget's properties.
   *
   * @param {String} propsStr A JSON encoded string that contains the properties we're going to update.
   * @returns {Promise}
   */
  exports.updateProperties = updateProperties = function updateProperties(propsStr) {
    var widget = getContentWidget();
    if (!propsStr || !widget) {
      return Promise.resolve();
    }
    var updatedProps = JSON.parse(propsStr);
    return Promise.all(Object.keys(updatedProps).map(function (propName) {
      return updateProperty(widget, propName, updatedProps[propName]);
    }));
  };

  /**
   * Handles the initialize lifecycle of a widget.
   *
   * @private
   *
   * @param widget The widget to be initialized.
   * @param  {Object} parameters Parameters to load as widget properties.
   * @returns {Promise} Returns a promise that will be resolved once
   * the widget has been initialized.
   */
  exports.initialize = function initialize(widget, parameters) {
    var wbutil = getWbInteropUtil();
    var env = getWbInteropEnv();
    var failureEvents = UNRECOVERABLE_FAIL_EVENTS.join(" ");
    var properties = widget.properties();

    //store the last re-initialize time incase any caches like uxBuilder want to check if they should clear their caches that normally
    //require a browser refresh.
    window.$wbContainerInitialize = new Date();

    // Remove the container from the DOM while loading.
    if (detachDom) {
      containerJq.remove();
    }
    initDf = defer();
    if (env) {
      jq.parent().toggleClass(Widget.css.designTime, !!env.designTime);
      env.toHyperlink = toHyperlink;
      env.startDrag = startDrag;
    }

    // If a widget is currently loaded then destroy it.
    function cleanup() {
      closeAllDialogs();
      errorJq.empty().hide();
      jq.show();
      var wbWidget = getContentWidget();
      if (wbWidget) {
        wipeContentWidget(widget);
        if (wbWidget.isInitialized()) {
          wbutil.destroying();
          util.preDestroy(wbWidget);
          return wbWidget.destroy().then(function () {
            wbutil.destroyed();
          });
        }
      }
    }
    function armFailureHandlers() {
      // Listen for failure events and only handle this once.
      jq.one(failureEvents, function (ev, v, err) {
        error(widget, ev.type, err);
      });
      jq.on(RUNTIME_FAIL_EVENTS.join(' '), handleRuntimeError);
    }
    function errorHandler(err) {
      reattachContainer();
      initDf && initDf.reject(err);
      wipeContentWidget();
      throw err;
    }
    function propsFromParameters() {
      if (parameters) {
        $.each(parameters, function (name, value) {
          value = util.decodeValueFromParameter(properties, name, value);
          if (value !== null) {
            properties.setValue(name, value, setValueOptions);
          }
        });
      }
    }

    /**
     * Configure the enabled state based off the initial value of the enabled property.
     * @return {Promise}
     */
    function configureEnabled() {
      if (properties.getValue("enabled") === false && widget.isEnabled()) {
        return widget.setEnabled(false);
      }
      return Promise.resolve();
    }

    // Resolve and initialize simultaneously as they're
    // independent of each other.
    function init() {
      // Cache the widget instance so it can be accessed globally
      window.wbWidget = widget;
      return configureEnabled().then(function () {
        return updateProperties(wbutil.getProperties());
      }).then(function () {
        wbutil.initializing();
        var oldWidget = Widget["in"](jq);
        return oldWidget && oldWidget.destroy();
      }).then(function () {
        return widget.initialize(jq);
      });
    }
    function initCommands() {
      if (wbutil.isCommandBarVisible()) {
        return util.initCommandBar(widget, containerJq);
      }
    }
    function encodeCommand(cmd) {
      var data = {},
        promises = [];
      if (cmd.isCommand()) {
        data.id = cmd.getId();
        data.toggle = cmd.isToggleCommand();

        //here we are switching back to module prefix for Workbench commands
        data.icon = cmd.getIcon().replace("https://workbench/module/", "module://");
        data.icon = data.icon.replace("/module/", "module://");
        data.enabled = cmd.isEnabled();
        data.menu = cmd.hasFlags(Command.flags.MENU_BAR);
        data.toolbar = cmd.hasFlags(Command.flags.TOOL_BAR);
        data.selected = cmd.isToggleCommand() && cmd.isSelected();
        data.command = true;
        promises.push(cmd.toDescription().then(function (description) {
          data.description = description;
        }));
      } else {
        data.command = false;
        data.kids = [];
      }
      promises.push(cmd.toDisplayName().then(function (displayName) {
        data.displayName = displayName;
      }));
      return Promise.all(promises).then(function () {
        return data;
      });
    }
    function encodeCommandTree(cmd) {
      return encodeCommand(cmd).then(function (data) {
        return cmd.isCommand() ? data : Promise.all(cmd.getChildren().map(function (c) {
          return encodeCommandTree(c);
        })).then(function (kids) {
          data.kids = kids;
          return data;
        });
      });
    }

    /**
     * @returns {Promise}
     */
    function buildCommands() {
      return widget.getCommandGroup().loading().then(function () {
        return encodeCommandTree(widget.getCommandGroup());
      }).then(function (data) {
        wbutil.buildCommands(JSON.stringify(data));
      });
    }

    /**
     * Uses Java-JS interop to sync the current property values of the content bajaux Widget up to
     * the hosting BWebWidget in Workbench. Properties will be encoded to the format that
     * `WebProperty` wants before sending. The updated property values Workbench will be applied
     * back from Workbench to the content widget.
     *
     * @param {module:bajaux/Widget} widget the content widget whose properties to sync
     * @returns {Promise} to be resolved after all properties are sync
     */
    function syncProperties(widget) {
      var props = widget.properties().get();
      var inWebPropertyFormat = props.map(function (prop) {
        return encodeToWebPropertyDefinition(prop);
      });
      var updatedBWidgetPropertiesJSON = wbutil.syncProperties(JSON.stringify(inWebPropertyFormat));
      return updateProperties(updatedBWidgetPropertiesJSON);
    }

    /**
     * @returns {Promise}
     */
    function register() {
      // Attach handlers to listen to Commands
      jq.on(events.command.CHANGE_EVENT, function (event, cmd) {
        encodeCommand(cmd).then(function (data) {
          wbutil.updateCommand(JSON.stringify(data));
        })["catch"](baja.error);
      });

      // Attach handlers to listen to CommandGroups
      jq.on(events.command.GROUP_CHANGE_EVENT, buildCommands);

      // When the widget is modified, update Workbench.
      jq.on(events.MODIFY_EVENT, function () {
        wbutil.setModified();
      });

      // When the widget is unmodified, update Workbench.
      jq.on(events.UNMODIFY_EVENT, function () {
        wbutil.clearModified();
      });

      // When Properties are added and removed, update Workbench.
      jq.on(events.PROPERTY_ADDED + " " + events.PROPERTY_REMOVED, function (ev, w) {
        if (w !== widget) {
          return;
        }
        syncProperties(widget)["catch"](logSevere);
      });

      // When a Property is changed, update Workbench.
      jq.on(events.PROPERTY_CHANGED, function (ev, w, name, value, params) {
        if (params !== setValueOptions && w === widget) {
          wbutil.propertyChanged(name, value);
        }
      });

      // When a Property's metadata is changed, update Workbench.
      jq.on(events.METADATA_CHANGED, function (ev, w, name, metadata, params) {
        if (params !== setMetadataOptions && w === widget) {
          wbutil.metadataChanged(name, metadata);
        }
      });

      // When the Command Group changes, reinitialize the Command Bar.
      jq.on(events.command.GROUP_CHANGE_EVENT, initCommands);

      // When a save happens, call the Workbench save command on everything.
      jq.on(events.SAVE_EVENT, function () {
        wbutil.save();
      });

      // Now the widget has loaded, register it with Workbench.
      wbutil.initialized();

      // Synchronize the Properties.
      return Promise.all([buildCommands(), syncProperties(widget)]).then(function () {
        if (containerOptions.attachAfterInit) {
          reattachContainer();
        }

        // Resolve the promise
        initDf && initDf.resolve();
      });
    }
    return Promise.resolve(armFailureHandlers()).then(cleanup).then(propsFromParameters).then(init).then(initCommands).then(register)["catch"](errorHandler);
  };
  var currentLoad;
  /**
   * Handles the load lifecycle for a widget. This will
   * resolve an ORD and load that into the widget.
   *
   * @private
   *
   * @param  {String} ord The ORD to resolve and load into the widget.
   * @returns {Promise} Returns a promise that will be resolved
   * once the widget has loaded.
   */
  exports.load = function load(ord) {
    var resolveProm,
      widget,
      wbutil = getWbInteropUtil();
    widget = getContentWidget();
    if (!initDf) {
      if (widget) {
        initDf = Promise["try"](function () {
          return exports.initialize(widget);
        });
      } else {
        return Promise.reject(new Error("Not initialized"));
      }
    }
    loadDf = defer();
    return Promise.resolve(initDf && initDf.promise).then(function () {
      return currentLoad = Promise.resolve(currentLoad).then(function () {
        widget = getContentWidget();
        if (widget) {
          resolveProm = widget.resolve(ord);
        }
      });
    }).then(function () {
      widget = getContentWidget();
      if (resolveProm) {
        return resolveProm;
      } else {
        return widget && widget.resolve(ord);
      }
    }).then(function (value) {
      widget = getContentWidget();
      return widget && widget.load(value);
    }).then(function () {
      reattachContainer();
      wbutil.loaded();
      loadDf.resolve();
      widget = getContentWidget();
      return widget && widget.layout();
    })["catch"](function (err) {
      reattachContainer();
      if (!widget.isDestroyed()) {
        loadDf.reject(err);
        throw err;
      } else {
        loadDf.resolve();
      }
    });
  };

  /**
   * Handles the save lifecycle of a widget.
   *
   * @private
   *
   * @returns {Promise} Returns a promise that will be
   * resolved once the widget has been saved.
   */
  exports.save = function save() {
    var wbutil = getWbInteropUtil();
    var widget = getContentWidget();

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      function ok() {
        wbutil.saveOk();
        resolve();
      }
      function fail(err) {
        wbutil.saveFail(err ? err.toString() : "Error saving value!");
        reject(err);
      }
      function doSave() {
        try {
          if (widget && widget.isModified()) {
            // Save the widget
            isSavePending = true;
            widget.save().then(ok, fail)["finally"](function () {
              isSavePending = false;
            });
          } else {
            ok();
          }
        } catch (e) {
          fail(e);
        }
      }
      if (loadDf || initDf) {
        (loadDf || initDf).promise.then(doSave, fail);
      } else {
        doSave();
      }
    });
  };

  /**
   * Handles the destroy lifecycle of a widget.
   *
   * @private
   *
   * @returns {Promise} Returns a promise that's resolved
   * once the widget has been fully destroyed and deactivated.
   */
  exports.deactivate = function deactivate() {
    var widget = getContentWidget();
    var wbutil = getWbInteropUtil();

    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      function ok() {
        reattachContainer();
        wbutil.destroyed();
        wbutil.deactivated();
        initDf = null;
        loadDf = null;
        resolve();
      }
      function fail(err) {
        reattachContainer();
        wbutil.deactivated();
        if (!widget || widget && !widget.isDestroyed()) {
          error(widget, "deactivate", err);
          baja.error(err);
        }
        initDf = null;
        loadDf = null;
        reject(err);
      }
      function doDeactivate() {
        try {
          closeAllDialogs();
          if (widget && widget.isInitialized()) {
            if (detachDom) {
              containerJq.remove();
            }
            wbutil.destroying();
            util.preDestroy(widget);
            Promise.all([widget.destroy(), util.destroyCommandBar(containerJq)]).then(ok, fail);
          } else {
            ok();
          }
        } catch (err) {
          fail(err);
        }
      }
      currentLoad = null;
      if (loadDf || initDf) {
        (loadDf || initDf).promise.then(doDeactivate, fail);
      } else {
        doDeactivate();
      }
    });
  };

  /**
   * Handles a request from Java to request to update the transform options.
   * @param {String} exporterBson
   * @return {Promise.<String>} Resolve to either emptyString for no changes, or the bson encoded result.
   * @since Niagara 4.14
   */
  exports.updateTransformOptions = function (exporterBson) {
    return Promise["try"](function () {
      var widget = getContentWidget();
      if (!widget || !widget.updateTransformOptions) {
        return '';
      }
      return baja.bson.decodeAsync(JSON.parse(exporterBson)).then(function (exporter) {
        return widget.updateTransformOptions(exporter);
      }).then(function (modifiedExporter) {
        return JSON.stringify(baja.bson.encodeValue(modifiedExporter));
      });
    });
  };

  /**
   * Called from Workbench when a drag over operations happens.
   *
   * @private
   * @function
   */
  exports.dragover = Clipboard.dragover;

  /**
   * Called from Workbench when a drop operation happens.
   *
   * @private
   * @function
   */
  exports.drop = Clipboard.drop;

  // Export this as global wbContainer so Workbench can
  // access this through the Web Engine.
  window.wbContainer = exports;
  return exports;
});
