function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _readOnlyError(r) { throw new TypeError('"' + r + '" is read-only'); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @copyright 2021 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module bajaux/commands/UndoManager
 */
define(['bajaux/commands/Command', 'underscore', 'Promise', 'nmodule/js/rc/asyncUtils/asyncUtils', 'nmodule/js/rc/tinyevents/tinyevents'], function (Command, _, Promise, asyncUtils, tinyevents) {
  'use strict';

  var compact = _.compact,
    last = _.last,
    once = _.once;
  var doRequire = asyncUtils.doRequire;
  var global;
  var resolveSystemProperties = _.once(function () {
    return doRequire('niagaraSystemProperties')["catch"](_.constant({}));
  });

  /**
   * This class manages a stack of undoable commands, and allows traversal back
   * and forth through the undo/redo stack.
   *
   * @alias module:bajaux/commands/UndoManager
   * @mixes tinyevents
   * @since Niagara 4.11
   */
  var UndoManager = /*#__PURE__*/function () {
    /**
     * @param {object} params
     * @param {number} [params.stackLimit] the maximum undo stack size limit. If not provided or is zero, this will be set to
     * either 100 or to the system property for `niagara.browser.maxUndoHistory` once it has time to be retrieved.
     */
    function UndoManager() {
      var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        stackLimit = _ref.stackLimit;
      _classCallCheck(this, UndoManager);
      this.$stackLimit = stackLimit;
      this.$undos = [];
      this.$redos = [];
      tinyevents(this);
    }

    /**
     * Invoke a Command. If the Command is undoable, its undo/redo information
     * will be registered with the UndoManager. Otherwise, it will be invoked
     * as normal.
     *
     * @param {module:bajaux/commands/Command} cmd
     * @param {Array.<*>} args
     * @returns {Promise}
     */
    return _createClass(UndoManager, [{
      key: "invoke",
      value: function invoke(cmd) {
        var _this = this;
        var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
        if (!cmd.isUndoable()) {
          return cmd.invoke.apply(cmd, _toConsumableArray(args));
        }
        return this.$ensureStackLimitIsSet().then(function () {
          return cmd.undoable.apply(cmd, _toConsumableArray(args));
        }).then(function (undoable) {
          if (!undoable) {
            return;
          }
          var undos = _this.$undos;
          var undo = {
            cmd: cmd,
            undoable: undoable
          };
          undos.push(undo);
          _this.$redos = [];
          if (undos.length > _this.$stackLimit) {
            undos.shift();
          }
          return undoable.redo().then(function (result) {
            return Promise.all([updateUndoCommand(_this, undo), updateRedoCommand(_this, null)]).then(function () {
              return result;
            });
          });
        });
      }

      /**
       * Undoes whatever undoable command was most recently invoked - i.e. moves
       * once backwards through the undo stack.
       *
       * @returns {Promise}
       */
    }, {
      key: "undo",
      value: function undo() {
        var _this2 = this;
        var undos = this.$undos;
        if (!undos.length) {
          return Promise.resolve();
        }
        var undo = undos.pop();
        this.$redos.push(undo);
        return undo.undoable.undo().then(function (result) {
          return Promise.all([updateUndoCommand(_this2, last(undos)), updateRedoCommand(_this2, undo)]).then(function () {
            return result;
          });
        })["catch"](function (err) {
          return _this2.wipe().then(function () {
            throw err;
          });
        });
      }

      /**
       * Redoes whatever undoable command was most recently undone - i.e. moves
       * once forwards through the redo stack.
       *
       * @returns {Promise}
       */
    }, {
      key: "redo",
      value: function redo() {
        var _this3 = this;
        var redos = this.$redos;
        if (!redos.length) {
          return Promise.resolve();
        }
        var redo = redos.pop();
        this.$undos.push(redo);
        return redo.undoable.redo().then(function (result) {
          return Promise.all([updateUndoCommand(_this3, redo), updateRedoCommand(_this3, last(redos))]).then(function () {
            return result;
          });
        })["catch"](function (err) {
          return _this3.wipe().then(function () {
            throw err;
          });
        });
      }

      /**
       * If an undo or redo fails, wipe the manager clean. Continuing to traverse
       * the undo stack after a failure can lead you into an inconsistent state.
       * @returns {Promise}
       */
    }, {
      key: "wipe",
      value: function wipe() {
        this.$undos = [];
        this.$redos = [];
        return Promise.all([updateUndoCommand(this, null), updateRedoCommand(this, null)]);
      }

      /**
       * @private
       * @returns {Promise}
       */
    }, {
      key: "$ensureStackLimitIsSet",
      value: function $ensureStackLimitIsSet() {
        var _this4 = this;
        if (!this.$stackLimit) {
          return resolveSystemProperties().then(function (niagaraSystemProperties) {
            var maxUndoHistory = parseInt(niagaraSystemProperties['niagara.browser.maxUndoHistory']);
            _this4.$stackLimit = isNaN(maxUndoHistory) || !maxUndoHistory ? 100 : maxUndoHistory;
          });
        }
        return Promise.resolve();
      }
    }]);
  }();
  /**
   * @private
   * @param {module:bajaux/commands/UndoManager} def a default global manager
   * to use if one is not already installed
   * @returns {module:bajaux/commands/UndoManager} the actual global instance
   */
  UndoManager.$ensureGlobal = function (def) {
    if (!global) {
      global = def || new UndoManager();
      Command.$installGlobalUndoManager(global);
    }
    return global;
  };

  /**
   * Install a global UndoManager instance to be shared across iframes.
   *
   * @private
   * @returns {Promise.<module:bajaux/commands/UndoManager>}
   */
  UndoManager.$installGlobal = once(function () {
    return getAllUndoManagerConstructors(window).then(function (undoManagerConstructors) {
      var global;
      undoManagerConstructors.forEach(function (um) {
        global = um.$ensureGlobal(global);
      });
      return global;
    });
  });

  /**
   * @param {Window} window
   * @returns {Promise.<function[]>} to be resolved with all UndoManager
   * constructors up the iframe chain, with window.top's at index 0.
   */
  function getAllUndoManagerConstructors(window) {
    return Promise.all(getAllWindows(window).map(getUndoManagerConstructor)).then(compact);
  }

  /**
   * @param {Window} window starting window
   * @returns {Window[]} all windows walking down through any iframes to my own
   * window. first is window.top, last is my own window.
   */
  function getAllWindows(window) {
    var windows = [window];
    while (window = getParentWindow(window)) {
      windows.push(window);
    }
    return windows.reverse();
  }

  /**
   * @param {Window} window
   * @returns {Window|undefined}
   */
  function getParentWindow(window) {
    var parent = window.parent;
    return window !== parent && parent;
  }

  /**
   * @param {Window} window
   * @returns {Promise.<function>}
   */
  function getUndoManagerConstructor(window) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve) {
      if (typeof window.require === 'function') {
        window.require(['bajaux/commands/UndoManager'], resolve, function () {
          return resolve(undefined);
        });
      } else {
        resolve();
      }
    });
  }
  function updateUndoCommand(mgr, undo) {
    var _ref2 = undo || {},
      cmd = _ref2.cmd,
      undoable = _ref2.undoable;
    return Promise.all([cmd && cmd.toDisplayName(), undoable && undoable.undoText(), undo && undoable && undoable.canUndo()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
        displayName = _ref4[0],
        undoText = _ref4[1],
        canUndo = _ref4[2];
      var undoDisplay = displayName ? "%lexicon(bajaux:commands.undo.displayCommandToUndo:".concat(displayName, ")%") : '%lexicon(bajaux:commands.undo.displayName)%';
      mgr.emit('undoStatus', {
        enabled: !!canUndo,
        displayName: undoDisplay,
        description: undoText || undoDisplay
      });
    });
  }
  function updateRedoCommand(mgr, redo) {
    var _ref5 = redo || {},
      cmd = _ref5.cmd,
      undoable = _ref5.undoable;
    return Promise.all([cmd && cmd.toDisplayName(), undoable && undoable.redoText(), redo && undoable && undoable.canRedo()]).then(function (_ref6) {
      var _ref7 = _slicedToArray(_ref6, 3),
        displayName = _ref7[0],
        redoText = _ref7[1],
        canRedo = _ref7[2];
      var redoDisplay = displayName ? "%lexicon(bajaux:commands.redo.displayCommandToRedo:".concat(displayName, ")%") : '%lexicon(bajaux:commands.redo.displayName)%';
      mgr.emit('redoStatus', {
        enabled: !!canRedo,
        displayName: redoDisplay,
        description: redoText || redoDisplay
      });
    });
  }
  return UndoManager;
});
