function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/fe/AlarmPrioritiesEditor
 */
define(['jquery', 'nmodule/alarm/rc/baja/AlarmPriorities', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'css!nmodule/alarm/rc/fe/alarmEditors'], function ($, AlarmPriorities, CompositeEditor, CompositeBuilder) {
  'use strict';

  //TODO: i18n
  var KEYS = ['toOffnormal', 'toFault', 'toNormal', 'toAlert'];

  /**
   * Editor for handling `alarm:AlarmPriorities` values.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/alarm/rc/fe/AlarmPrioritiesEditor
   */
  var AlarmPrioritiesEditor = function AlarmPrioritiesEditor() {
    var that = this;
    CompositeEditor.apply(that, arguments);
  };
  AlarmPrioritiesEditor.prototype = Object.create(CompositeEditor.prototype);
  AlarmPrioritiesEditor.prototype.constructor = AlarmPrioritiesEditor;

  /**
   * The builder for an `AlarmPrioritiesEditor` will create numeric editors
   * for the four fields of an `alarm:AlarmPriorities` value.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  AlarmPrioritiesEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getConfigFor = function (key) {
      return {
        formFactor: 'mini',
        properties: {
          max: AlarmPriorities.MAX_PRIORITY,
          min: AlarmPriorities.MIN_PRIORITY,
          prelabel: key,
          precision: 0
        }
      };
    };
    builder.getDomFor = function () {
      return $('<span/>').appendTo(that.jq());
    };
    builder.getKeys = function () {
      return KEYS.slice();
    };
    builder.getValueFor = function (key) {
      var ap = this.getDataSource();
      switch (key) {
        case 'toOffnormal':
          return ap.getToOffnormal();
        case 'toFault':
          return ap.getToFault();
        case 'toNormal':
          return ap.getToNormal();
        case 'toAlert':
          return ap.getToAlert();
      }
    };
    return builder;
  };

  /**
   * Read all numeric editors and construct an `alarm:AlarmPriorities` instance.
   *
   * @returns {Promise}
   */
  AlarmPrioritiesEditor.prototype.doRead = function () {
    return this.getBuilder().readAll().then(function (args) {
      return AlarmPriorities.make.apply(AlarmPriorities, _toConsumableArray(args));
    });
  };
  return AlarmPrioritiesEditor;
});
