/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Jeremy Narron
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/fe/AlarmNotesEditor
 */
define(['Promise', 'bajaux/Properties', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (Promise, Properties, CompositeEditor, CompositeBuilder) {
  'use strict';

  /**
   * Editor for adding notes before acking a alarms
   * for a given source in the Alarm Console.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/alarm/rc/fe/AlarmNotesEditor
   */
  var AlarmNotesEditor = function AlarmNotesEditor() {
    CompositeEditor.apply(this, arguments);
  };
  AlarmNotesEditor.prototype = Object.create(CompositeEditor.prototype);
  AlarmNotesEditor.prototype.constructor = AlarmNotesEditor;

  /**
   * Configures the composite builder for the loaded string value. Ensures
   * the editor displaying current notes is readonly.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  AlarmNotesEditor.prototype.makeBuilder = function () {
    var that = this,
      builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['currentNotes', 'newNotes'];
    };
    builder.getValueFor = function (key) {
      switch (key) {
        case 'currentNotes':
          return this.getDataSource();
        case 'newNotes':
          return '';
      }
    };
    builder.getConfigFor = function (key) {
      switch (key) {
        case 'currentNotes':
          return {
            readonly: true,
            formFactor: 'mini',
            properties: new Properties({
              multiLine: true
            })
          };
        case 'newNotes':
          return {
            formFactor: 'mini',
            properties: new Properties({
              multiLine: true
            })
          };
      }
    };
    builder.getDomFor = function (key) {
      return that.jq().children('.js-' + key);
    };
    return builder;
  };

  /**
   * Create the DOM structure displaying the current alarm notes in one editor
   * and allowing the user to enter new notes in another.
   *
   * @param {jQuery} dom
   */
  AlarmNotesEditor.prototype.doInitialize = function (dom) {
    dom.html('<div class="js-currentNotes"/><div class="js-newNotes"/>');
    return CompositeEditor.prototype.doInitialize.apply(this, arguments) || Promise.resolve();
  };

  /**
   * Read the value out of the newNotes editor.
   *
   * @returns {Promise.<String>}
   */
  AlarmNotesEditor.prototype.doRead = function () {
    return this.getBuilder().getEditorFor('newNotes').read();
  };
  return AlarmNotesEditor;
});
