/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/db/DatabaseView
 */
define(['nmodule/alarm/rc/db/DatabaseMaintenance', 'underscore'], function (DatabaseMaintenance, _) {
  "use strict";

  /**
   * A module that displays a paged table of alarms from an alarm database
   *
   * @class
   * @alias module:nmodule/alarm/rc/db/DatabaseView
   * @extends module:nmodule/alarm/rc/db/DatabaseMaintenance
   * @param params
   */
  var DatabaseView = function DatabaseView(params) {
    params = params || {};
    DatabaseMaintenance.call(this, _.extend({
      moduleName: 'alarm',
      keyName: 'DatabaseView'
    }, params));
  };
  DatabaseView.prototype = Object.create(DatabaseMaintenance.prototype);
  DatabaseView.prototype.constructor = DatabaseView;
  DatabaseView.prototype.isMaintenanceView = function () {
    return false;
  };
  return DatabaseView;
});
