/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Danesh Kamal
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/console/support/AlarmConsoleSupport
 */
define([], function () {
  'use strict';

  /**
   * AlarmConsoleSupport is the top-level interface defining support methods for a corresponding AlarmConsoleViewModel
   * Conforming implementations are required to implement the methods in this interface depending
   * on the application specific requirements for their alarm console views
   *
   * @class
   * @alias module:nmodule/alarm/rc/console/support/AlarmConsoleSupport
   */
  var AlarmConsoleSupport = function AlarmConsoleSupport() {};

  /////////////////////////////////////////////////////////////////
  //Lifecycle
  /////////////////////////////////////////////////////////////////

  /**
   * Loads the support instance
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.load = function () {
    throw new Error('load() not implemented');
  };

  /**
   * Destroys the support instance
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.destroy = function () {
    throw new Error('destroy() not implemented');
  };

  /////////////////////////////////////////////////////////////////
  //Support Utilities
  /////////////////////////////////////////////////////////////////

  /**
   * Returns the default options
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getDefaultAlarmConsoleOptions = function () {
    throw new Error('getDefaultAlarmConsoleOptions() not implemented');
  };

  /**
   * Returns the time range to initialize on the first load of the alarm console
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getDefaultTimeRange = function () {
    throw new Error('getDefaultTimeRange() not implemented');
  };

  /**
   * Returns the default zero-indexed page offset at which to start displaying record
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getDefaultPageIndex = function () {
    throw new Error('getDefaultPageIndex() not implemented');
  };

  /**
   * Returns the default page size for each page of alarm records
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getDefaultPageSize = function () {
    throw new Error('getDefaultPageSize() not implemented');
  };

  /**
   * Returns the default table model to initially load into the alarm table
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getDefaultTableModel = function () {
    throw new Error('getDefaultTableModel() not implemented');
  };

  /**
   * Returns an instance of an alarm column for custom alarm data
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.createAlarmDataColumn = function () {
    throw new Error('createAlarmDataColumn() not implemented');
  };

  /////////////////////////////////////////////////////////////////
  //Data Channel
  /////////////////////////////////////////////////////////////////

  /**
   * Loads the alarm summary from the remote host into the alarm table
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.loadAlarmSummary = function () {
    throw new Error('loadAlarmSummary() not implemented');
  };

  /**
   * Gets a list of the user-defined alarm data fields for an alarm record
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getAlarmFields = function () {
    throw new Error('getAlarmFields() not implemented');
  };
  AlarmConsoleSupport.prototype.getMostRecentAlarms = function () {
    throw new Error('getMostRecentAlarms() not implemented');
  };

  /**
   * Gets the current summary of open alarms from the remote host
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.getAlarmSummary = function () {
    throw new Error('getAlarmSummary() not implemented');
  };

  /**
   * Acknowledge the selected alarms in the alarm table
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.ackAlarms = function () {
    throw new Error('ackAlarms() not implemented');
  };

  /**
   * Force clear the selected alarms in the alarm table
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.forceClearAlarms = function () {
    throw new Error('forceClearAlarms() not implemented');
  };

  /**
   * Add notes to the selected alarms in the alarm table
   * @throws {Error}
   */
  AlarmConsoleSupport.prototype.addNoteToAlarms = function () {
    throw new Error('addNoteToAlarms() not implemented');
  };
  return AlarmConsoleSupport;
});
