/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/alarm/rc/baja/ext/AlarmAlgorithm
 */
define(['baja!'], function (baja) {
  'use strict';

  var Component = baja.Component;

  /**
   * BajaScript representation of an `alarm:AlarmAlgorithm` value.
   *
   * @class
   * @extends baja.Component
   * @alias module:nmodule/alarm/rc/baja/ext/AlarmAlgorithm
   */
  var AlarmAlgorithm = function AlarmAlgorithm() {
    Component.apply(this, arguments);
  };
  AlarmAlgorithm.prototype = Object.create(Component.prototype);
  AlarmAlgorithm.prototype.constructor = AlarmAlgorithm;

  /**
   * Return the parent `alarm:AlarmSourceExt`.
   * @returns {baja.Complex} the parent `AlarmSourceExt` or `null` if not
   * present
   */
  AlarmAlgorithm.prototype.getParentExt = function () {
    var parent = this.getParent();
    //TODO: NCCB-16622
    if (baja.lt('alarm:AlarmSourceExt') && baja.hasType(parent, 'alarm:AlarmSourceExt')) {
      return parent;
    }
    return null;
  };

  /**
   * Return the parent ext's parent `control:ControlPoint`.
   * @returns {baja.Complex} the parent `ControlPoint` or `null` if not present
   */
  AlarmAlgorithm.prototype.getParentPoint = function () {
    var ext = this.getParentExt();
    if (ext) {
      //TODO: control:PointExtension type ext
      var point = ext.getParent();
      //TODO: NCCB-16622
      if (baja.lt('control:ControlPoint') && baja.hasType(point, 'control:ControlPoint')) {
        return point;
      }
    }
    return null;
  };

  /**
   * Returns the parent point's `facets` slot, or `baja.Facets.DEFAULT` if
   * no parent point present.
   * @returns {baja.Facets}
   */
  AlarmAlgorithm.prototype.getPointFacets = function () {
    var parent = this.getParentPoint();
    return parent ? parent.get('facets') : baja.Facets.DEFAULT;
  };
  return AlarmAlgorithm;
});
