/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.util;

import com.tridium.history.db.BLocalHistoryDatabase;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryPointList;
import javax.baja.history.BHistoryPointListItem;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="fileNameIdentity", type="String", defaultValue="NameID")
@NiagaraAction(name="export", flags=16)
public class BHistoryPointsExport
extends BComponent {
    public static final Property fileNameIdentity = BHistoryPointsExport.newProperty((int)0, (String)"NameID", null);
    public static final Action export = BHistoryPointsExport.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BHistoryPointsExport.class);

    public String getFileNameIdentity() {
        return this.getString(fileNameIdentity);
    }

    public void setFileNameIdentity(String v) {
        this.setString(fileNameIdentity, v, null);
    }

    public void export() {
        this.invoke(export, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        boolean ret = false;
        if (parent instanceof BHistoryPointList) {
            ret = super.isParentLegal(parent);
        }
        return ret;
    }

    public void doExport() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        String names = "Time";
        int nbrPnts = 0;
        int po = 0;
        BComponent par = (BComponent)this.getParent();
        par.loadSlots();
        BHistoryPointListItem[] pnts = (BHistoryPointListItem[])par.getChildren(BHistoryPointListItem.class);
        nbrPnts = pnts.length;
        for (BHistoryPointListItem p : pnts) {
            BHistoryExt he = (BHistoryExt)p.getHistoryExtension().resolve((BObject)par).get();
            names = names + "," + he.resolveHistoryName();
            BHistoryId id = he.getHistoryConfig().getId();
            BHistoryService srv = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BLocalHistoryDatabase db = (BLocalHistoryDatabase)srv.getDatabase();
            try {
                db.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (db != null && db.hasHistoryEventListeners()) {
                db.fireHistoryEvent(BHistoryEvent.makeDbSaved());
            }
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                int pntOrdinal = po++;
                BIHistory history = conn.getHistory(id);
                Cursor c = conn.scan(history);
                while (c.next()) {
                    CharSequence[] split;
                    BHistoryRecord rec = (BHistoryRecord)c.get();
                    String d = rec.toDataSummary(null).split(" ")[0];
                    BAbsTime norm = BAbsTime.make((int)rec.getTimestamp().getYear(), (BMonth)rec.getTimestamp().getMonth(), (int)rec.getTimestamp().getDay(), (int)rec.getTimestamp().getHour(), (int)rec.getTimestamp().getMinute());
                    long key = norm.getMillis();
                    String recStr = "";
                    String dataStr = "";
                    if (map.containsKey(key)) {
                        split = ((String)map.get(key)).split(",");
                        split[pntOrdinal + 1] = d;
                        recStr = String.join((CharSequence)",", split);
                    } else {
                        for (int i = 0; i < nbrPnts; ++i) {
                            dataStr = dataStr + " ";
                            if (i + 1 >= nbrPnts) continue;
                            dataStr = dataStr + ",";
                        }
                        split = dataStr.split(",");
                        split[pntOrdinal] = d;
                        recStr = rec.getTimestamp().toDateString(null) + " " + rec.getTimestamp().toTimeString(null) + "," + String.join((CharSequence)",", split);
                    }
                    map.put(key, recStr);
                }
            }
        }
        if (map.size() > 0) {
            Collection coll = map.values();
            Iterator iterator = coll.iterator();
            String fname = "^exp_" + this.getFileNameIdentity() + "_" + String.valueOf(BAbsTime.now().getMillis()) + ".csv";
            BIFile file = null;
            try {
                file = (BIFile)BOrd.make((String)("file:" + fname)).get((BObject)this);
            }
            catch (UnresolvedException e) {
                FilePath fp = new FilePath(fname);
                try {
                    file = BFileSystem.INSTANCE.makeFile(fp, null);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw new RuntimeException(ex);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            try {
                PrintWriter out = new PrintWriter(file.getStore().getOutputStream());
                out.println(names);
                out.flush();
                while (iterator.hasNext()) {
                    String fruit = (String)iterator.next();
                    try {
                        out.println(fruit);
                        out.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

