/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.service;

import com.lynxspring.onyxxwallmodule.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxwallmodule.property.BCanFSInterfaceValue;
import com.lynxspring.onyxxwallmodule.property.wallmodule.BWallModuleMonitors;
import com.lynxspring.onyxxwallmodule.property.wallmodule.BWallModuleSettings;
import com.lynxspring.onyxxwallmodule.property.wallmodule.BWallModuleStatus;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModFirmwareVersion;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModService;
import com.lynxspring.onyxxwallmodule.service.UpdateParams;
import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.ndriver.util.SfUtil;
import java.io.File;
import java.util.ArrayList;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", flags=75, defaultValue="BStatus.ok"), @NiagaraProperty(name="enable", type="boolean", defaultValue="true"), @NiagaraProperty(name="health", type="BPingHealth", flags=65, defaultValue="new BPingHealth()"), @NiagaraProperty(name="autoSyncInterval", type="BTimeTrigger", flags=4, defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeSeconds(30)))"), @NiagaraProperty(name="Versioning", type="BOnyxxWallModFirmwareVersion", defaultValue="new BOnyxxWallModFirmwareVersion()"), @NiagaraProperty(name="pollScheduler", type="BBasicPollScheduler", defaultValue="new BBasicPollScheduler()"), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.make(0)"), @NiagaraProperty(name="Monitoring", type="BWallModuleMonitors", defaultValue="new BWallModuleMonitors()"), @NiagaraProperty(name="Settings", type="BWallModuleSettings", defaultValue="new BWallModuleSettings()"), @NiagaraProperty(name="runtimeStatus", type="BWallModuleStatus", defaultValue="new BWallModuleStatus()"), @NiagaraProperty(name="farenheitCelsius", type="boolean", flags=5, defaultValue="true"), @NiagaraProperty(name="devicePath", type="String", defaultValue="", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="powerCycled", type="boolean", flags=5, defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="runUpdate", flags=16), @NiagaraAction(name="ping", flags=16), @NiagaraAction(name="syncFromWallModule", flags=16), @NiagaraAction(name="syncToWallModule", flags=16), @NiagaraAction(name="changeEnable", flags=16), @NiagaraAction(name="updateFirmware", flags=16)})
public class BOnyxxWallModule
extends BComponent
implements BCanFSInterfaceValue,
BIBasicPollable {
    public static final Property status = BOnyxxWallModule.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property enable = BOnyxxWallModule.newProperty((int)0, (boolean)true, null);
    public static final Property health = BOnyxxWallModule.newProperty((int)65, (BValue)new BPingHealth(), null);
    public static final Property autoSyncInterval = BOnyxxWallModule.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)30))), null);
    public static final Property Versioning = BOnyxxWallModule.newProperty((int)0, (BValue)new BOnyxxWallModFirmwareVersion(), null);
    public static final Property pollScheduler = BOnyxxWallModule.newProperty((int)0, (BValue)new BBasicPollScheduler(), null);
    public static final Property pollFrequency = BOnyxxWallModule.newProperty((int)0, (BValue)BPollFrequency.make((int)0), null);
    public static final Property Monitoring = BOnyxxWallModule.newProperty((int)0, (BValue)new BWallModuleMonitors(), null);
    public static final Property Settings = BOnyxxWallModule.newProperty((int)0, (BValue)new BWallModuleSettings(), null);
    public static final Property runtimeStatus = BOnyxxWallModule.newProperty((int)0, (BValue)new BWallModuleStatus(), null);
    public static final Property farenheitCelsius = BOnyxxWallModule.newProperty((int)5, (boolean)true, null);
    public static final Property devicePath = BOnyxxWallModule.newProperty((int)0, (String)"", (BFacets)SfUtil.incl((String)"ed"));
    public static final Property powerCycled = BOnyxxWallModule.newProperty((int)5, (boolean)false, null);
    public static final Action runUpdate = BOnyxxWallModule.newAction((int)16, null);
    public static final Action ping = BOnyxxWallModule.newAction((int)16, null);
    public static final Action syncFromWallModule = BOnyxxWallModule.newAction((int)16, null);
    public static final Action syncToWallModule = BOnyxxWallModule.newAction((int)16, null);
    public static final Action changeEnable = BOnyxxWallModule.newAction((int)16, null);
    public static final Action updateFirmware = BOnyxxWallModule.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BOnyxxWallModule.class);
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxWallModService.class).getModuleName());
    private static final String PING_FILE_NAME = "ping_status";
    private static final long PING_MAX = 5000L;
    private long devicePingStatusRuntime = -1L;
    private static final String WM_SUBSYSTEM_PATH = "wm_subsystem/";
    private static final String WM_STATUS_FOLDER = "wm_status/";
    private static final String WM_REFRESH_NAME = "requestRefresh";
    private static final String WM_SETTINGS_FOLDER = "wm_settings/";
    private static final String WM_FILE_NAME = "uxConfig";
    private static final int WM_CHIP = 9;
    public static final String WM_FIRMWARE = "1.0.1";
    public static final String WALLMOD_VERSION = "1.0.1";
    private int readFaultCount = 0;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getEnable() {
        return this.getBoolean(enable);
    }

    public void setEnable(boolean v) {
        this.setBoolean(enable, v, null);
    }

    public BPingHealth getHealth() {
        return (BPingHealth)this.get(health);
    }

    public void setHealth(BPingHealth v) {
        this.set(health, (BValue)v, null);
    }

    public BTimeTrigger getAutoSyncInterval() {
        return (BTimeTrigger)this.get(autoSyncInterval);
    }

    public void setAutoSyncInterval(BTimeTrigger v) {
        this.set(autoSyncInterval, (BValue)v, null);
    }

    public BOnyxxWallModFirmwareVersion getVersioning() {
        return (BOnyxxWallModFirmwareVersion)this.get(Versioning);
    }

    public void setVersioning(BOnyxxWallModFirmwareVersion v) {
        this.set(Versioning, (BValue)v, null);
    }

    public BBasicPollScheduler getPollScheduler() {
        return (BBasicPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BBasicPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BWallModuleMonitors getMonitoring() {
        return (BWallModuleMonitors)this.get(Monitoring);
    }

    public void setMonitoring(BWallModuleMonitors v) {
        this.set(Monitoring, (BValue)v, null);
    }

    public BWallModuleSettings getSettings() {
        return (BWallModuleSettings)this.get(Settings);
    }

    public void setSettings(BWallModuleSettings v) {
        this.set(Settings, (BValue)v, null);
    }

    public BWallModuleStatus getRuntimeStatus() {
        return (BWallModuleStatus)this.get(runtimeStatus);
    }

    public void setRuntimeStatus(BWallModuleStatus v) {
        this.set(runtimeStatus, (BValue)v, null);
    }

    public boolean getFarenheitCelsius() {
        return this.getBoolean(farenheitCelsius);
    }

    public void setFarenheitCelsius(boolean v) {
        this.setBoolean(farenheitCelsius, v, null);
    }

    public String getDevicePath() {
        return this.getString(devicePath);
    }

    public void setDevicePath(String v) {
        this.setString(devicePath, v, null);
    }

    public boolean getPowerCycled() {
        return this.getBoolean(powerCycled);
    }

    public void setPowerCycled(boolean v) {
        this.setBoolean(powerCycled, v, null);
    }

    public void runUpdate() {
        this.invoke(runUpdate, null, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public void syncFromWallModule() {
        this.invoke(syncFromWallModule, null, null);
    }

    public void syncToWallModule() {
        this.invoke(syncToWallModule, null, null);
    }

    public void changeEnable() {
        this.invoke(changeEnable, null, null);
    }

    public void updateFirmware() {
        this.invoke(updateFirmware, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.doPing();
        this.propagatePowerCycled(this.checkIfPowerCycled());
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != null && this.isRunning() && Sys.atSteadyState() && property.getName().startsWith("enable")) {
            if (!this.getEnable()) {
                this.setStatus(BStatus.disabled);
            } else {
                this.setStatus(BStatus.ok);
            }
        }
    }

    public void manageStatus(BStatus s, String fault) {
        this.setStatus(s);
        if (s == BStatus.ok) {
            this.getHealth().setDown(false);
            this.getHealth().setAlarm(false);
            this.getHealth().setLastOkTime(BAbsTime.now());
        } else {
            this.getHealth().setDown(true);
            this.getHealth().setAlarm(true);
            this.getHealth().setLastFailTime(BAbsTime.now());
            this.getHealth().setLastFailCause(fault);
        }
    }

    public BOnyxxWallModService getWallModService() {
        return (BOnyxxWallModService)this.getParent();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        try {
            BLink l = (BLink)this.get("syncLink");
            if (l == null) {
                BLink lk = new BLink(this.getAutoSyncInterval().getSlotPathOrd(), "fireTrigger", "syncToWallModule", true);
                this.add("syncLink", (BValue)lk);
                this.getPollScheduler().setFastRate(BRelTime.makeSeconds((int)3));
                this.getPollScheduler().setNormalRate(BRelTime.makeSeconds((int)30));
                this.getPollScheduler().setSlowRate(BRelTime.makeMinutes((int)1));
            }
        }
        catch (Exception l) {
            // empty catch block
        }
        if (this.getDevicePath() == null || this.getDevicePath() == "") {
            this.setDevicePath("onyxx_");
        }
        if (!this.getEnable()) {
            this.setStatus(BStatus.disabled);
        } else {
            this.setStatus(BStatus.ok);
        }
        BOnyxxWallModule dev = this;
        if (dev != null) {
            String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
            String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
            try {
                OnyxxFileAccess.FileIO(networkPath + devicePath + WM_STATUS_FOLDER, WM_REFRESH_NAME, "1", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getPollScheduler().subscribe((BIPollable)this);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BOnyxxWallModService;
    }

    protected void runTriggerAppRefresh(boolean all) {
    }

    protected void performNewWallModSetup() {
    }

    public void doRunUpdate() {
        String val = "";
        BOnyxxWallModule dev = this;
        if (this.getStatus() != BStatus.disabled && this.getEnable()) {
            try {
                this.doPing();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getCommOk(this) && dev != null) {
                String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
                String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
                try {
                    val = OnyxxFileAccess.FileIO(networkPath + devicePath + WM_STATUS_FOLDER, WM_REFRESH_NAME, "", false);
                }
                catch (Exception e) {
                    LOG.log(2, "OnyxxWallModule:doRunUpdate", (Throwable)e);
                    this.setModuleStatus(BStatus.fault, "", e, dev);
                }
                if (val != "") {
                    boolean all = false;
                    Integer i = new Integer(val);
                    short sv = i.shortValue();
                    if (sv == 4) {
                        all = true;
                    }
                    if (sv == 2 || sv == 4) {
                        BComponent[] kids;
                        try {
                            OnyxxFileAccess.FileIO(networkPath + devicePath + WM_STATUS_FOLDER, WM_REFRESH_NAME, "0", true);
                        }
                        catch (Exception e) {
                            this.setModuleStatus(BStatus.fault, "", e, dev);
                            LOG.log(2, "OnyxxWallModule:doRunUpdate:refreshReq", (Throwable)e);
                        }
                        for (BComponent c : kids = this.getRuntimeStatus().getChildComponents()) {
                            if (!(c instanceof BCanFSInterfaceValue)) continue;
                            ((BCanFSInterfaceValue)c).triggerRefreshToWallMod(all);
                        }
                        for (BComponent c : kids = this.getSettings().getChildComponents()) {
                            if (!(c instanceof BCanFSInterfaceValue)) continue;
                            ((BCanFSInterfaceValue)c).triggerRefreshToWallMod(all);
                        }
                        this.runTriggerAppRefresh(all);
                    } else {
                        this.performNewWallModSetup();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFirmwareVersion() {
        String wm_version = "";
        String devicePath = this.getDevicePath();
        String networkPath = this.getWallModService().getNetworkPath();
        devicePath = BOnyxxWallModule.checkTrailSlash(devicePath);
        networkPath = BOnyxxWallModule.checkTrailSlash(networkPath);
        try {
            wm_version = OnyxxFileAccess.FileIO(networkPath + devicePath + WM_SUBSYSTEM_PATH, "version", "", false);
        }
        catch (Exception e) {
            wm_version = "1.0.1";
        }
        finally {
            this.getVersioning().setWallModuleVersion(wm_version);
        }
    }

    public static String checkTrailSlash(String pathStr) {
        if (!pathStr.endsWith("/")) {
            pathStr = pathStr + "/";
        }
        return pathStr;
    }

    public void doPing() {
        this.populateFirmwareVersion();
        long previousRuntime = this.devicePingStatusRuntime;
        long pingTime = this.readPingFile();
        if (pingTime == -1L) {
            LOG.trace("System Error.  No Ping File found!");
            this.setModuleStatus(BStatus.fault, "Ping failure", null, this);
        } else if (pingTime < 5000L && previousRuntime != this.devicePingStatusRuntime) {
            LOG.trace("Onyxx Device Ping:  " + this.getDisplayName(null) + " is up : " + pingTime);
            this.setModuleStatus(BStatus.ok, "", null, this);
        } else {
            pingTime = this.readPingFile();
            if (pingTime != -1L && pingTime < 5000L) {
                LOG.trace("Onyxx Device Ping:  " + this.getDisplayName(null) + " is up : " + pingTime);
                this.setModuleStatus(BStatus.ok, "", null, this);
            } else {
                this.setModuleStatus(BStatus.down, "Ping failure", null, this);
                LOG.trace(this.getDisplayName(null) + " has stopped communicating.\n\t\tEnsure device is powered and gray network cable is plugged in to all devices.\n\t\tIssue is not with Onyxx Network : " + pingTime);
            }
        }
    }

    public long readPingFile() {
        String textValue = "";
        long currentPingValue = 0L;
        Object br = null;
        try {
            textValue = OnyxxFileAccess.FileIO(this.getFullDevicePath(), this.getPingFileName(), "", false);
        }
        catch (Exception e) {
            LOG.error("Error when reading Ping file: " + this.getDevicePath());
            return -1L;
        }
        this.devicePingStatusRuntime = Long.parseLong(textValue.substring(0, textValue.indexOf(",")));
        currentPingValue = Long.parseLong(textValue.substring(textValue.indexOf(",") + 1));
        return currentPingValue;
    }

    public String getFullDevicePath() {
        String devicePath = this.getDevicePath();
        String networkPath = this.getWallModService().getNetworkPath();
        devicePath = BOnyxxWallModule.checkTrailSlash(devicePath);
        networkPath = BOnyxxWallModule.checkTrailSlash(networkPath);
        return networkPath + devicePath;
    }

    public String getPingFileName() {
        return PING_FILE_NAME;
    }

    public void checkDevice() {
        try {
            File devDir = new File(this.getWallModService().getNetworkPath(), this.getDevicePath());
            if (!devDir.exists() && !devDir.isDirectory()) {
                LOG.trace("Device Check: Device Directory not Found.  readFaultCount incremented");
                ++this.readFaultCount;
            } else {
                LOG.trace("Device Check:  Device Directory Found.  readFaultCount reset to 0.");
                this.readFaultCount = 0;
            }
            if (this.readFaultCount >= 2) {
                LOG.trace("Device Check:  failed 2 or more times.  Putting device in Fault");
                this.setStatus(BStatus.fault);
            } else {
                this.setStatus(this.getStatus());
            }
        }
        catch (Exception e) {
            LOG.trace("Checking Device failed", (Throwable)e);
        }
    }

    public String getCanbusID() {
        String devicePath = this.getDevicePath();
        devicePath = BOnyxxWallModule.checkTrailSlash(devicePath);
        String strCanId = devicePath.substring(devicePath.indexOf("_") + 1, devicePath.length() - 1);
        return strCanId;
    }

    public UpdateParams getUpdateParams() {
        int lg = this.getWallModService().getKuroLog() ? 1 : 0;
        UpdateParams up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 9, this.getWallModService().getKuroAckDelay(), this.getWallModService().getKuroPacketCount(), this.getWallModService().getKuroTransmitDelay(), lg);
        return up;
    }

    public long getPingMax() {
        return 5000L;
    }

    @Override
    public boolean dataValidCheck(String val) {
        return true;
    }

    @Override
    public void triggerUpdate() {
        this.invoke(runUpdate, null);
    }

    public boolean checkIfPowerCycled() {
        boolean ret = true;
        String val1 = "";
        String val2 = "";
        boolean fault = false;
        BOnyxxWallModule dev = this;
        if (dev != null) {
            String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
            String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
            try {
                val1 = OnyxxFileAccess.FileIO(networkPath + devicePath + WM_SETTINGS_FOLDER, WM_FILE_NAME, "", false);
            }
            catch (Exception e) {
                fault = true;
                LOG.log(2, "OnyxxWallModule:check if power cycle", (Throwable)e);
                this.setModuleStatus(BStatus.fault, "", e, dev);
            }
            if (!fault) {
                ret = val1.length() > 0 && val1 != "" && val1.matches("000000000000");
            }
        }
        return ret;
    }

    public void doSyncFromWallModule() {
        BOnyxxWallModule dev = this;
        if (this.getEnable() && dev != null) {
            String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
            String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
            try {
                OnyxxFileAccess.FileIO(networkPath + devicePath + WM_STATUS_FOLDER, WM_REFRESH_NAME, "3", true);
            }
            catch (Exception e) {
                this.setModuleStatus(BStatus.fault, "", e, dev);
            }
        }
    }

    public void doSyncToWallModule() {
        BOnyxxWallModule dev = this;
        if (this.getEnable() && dev != null && this.getCommOk(this)) {
            String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
            String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
            try {
                OnyxxFileAccess.FileIO(networkPath + devicePath + WM_STATUS_FOLDER, WM_REFRESH_NAME, "4", true);
            }
            catch (Exception e) {
                this.setModuleStatus(BStatus.fault, "", e, dev);
            }
        }
    }

    @Override
    public void setPowerCycledFlag(boolean pwr) {
        this.setPowerCycled(pwr);
    }

    public void propagatePowerCycled(boolean p) {
        BComponent[] kids;
        for (BComponent c : kids = this.getRuntimeStatus().getChildComponents()) {
            if (!(c instanceof BCanFSInterfaceValue)) continue;
            ((BCanFSInterfaceValue)c).setPowerCycledFlag(p);
        }
        for (BComponent c : kids = this.getSettings().getChildComponents()) {
            if (!(c instanceof BCanFSInterfaceValue)) continue;
            ((BCanFSInterfaceValue)c).setPowerCycledFlag(p);
        }
    }

    public void doChangeEnable() {
        if (this.getEnable()) {
            this.setEnable(false);
            this.setStatus(BStatus.disabled);
        } else {
            this.setEnable(true);
            this.setStatus(BStatus.ok);
        }
    }

    public void doUpdateFirmware() {
        this.getWallModService();
        String productStr = BOnyxxWallModService.getProductStr();
        boolean update_needed = false;
        BOnyxxWallModule[] mods = new BOnyxxWallModule[]{this};
        this.getWallModService().updateWallMods(mods);
    }

    public void checkWallModUpdateNeed(ArrayList<UpdateParams> al, boolean autoUpdate, int compCounter) {
        boolean downgradeAttempt = false;
        if (BOnyxxWallModService.checkVersion(this.getVersioning().getWallModuleVersion(), "1.0.1") == 1) {
            downgradeAttempt = true;
        }
        if (!autoUpdate) {
            int chk = BOnyxxWallModService.checkVersion(this.getVersioning().getWallModuleVersion(), "1.0.1");
            if (chk == -1 || chk == 0) {
                int lg = this.getWallModService().getKuroLog() ? 1 : 0;
                UpdateParams up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 9, this.getWallModService().getKuroAckDelay(), this.getWallModService().getKuroPacketCount(), this.getWallModService().getKuroTransmitDelay(), lg);
                up.setCompletionCounter(compCounter);
                al.add(up);
            }
            if (downgradeAttempt) {
                LOG.message("");
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                      !! FIRMWARE VERSION NOTICE !!                          --");
                LOG.message("--     One or more firmware versions are higher than the available version.    --");
                LOG.message("--            Downgrading those chips during this upgrade process.             --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        } else {
            int chk = BOnyxxWallModService.checkVersion(this.getVersioning().getWallModuleVersion(), "1.0.1");
            if (chk == -1 || chk == 0) {
                int lg = this.getWallModService().getKuroLog() ? 1 : 0;
                UpdateParams up = new UpdateParams(TYPE.toString(), this.getCanbusID(), 9, this.getWallModService().getKuroAckDelay(), this.getWallModService().getKuroPacketCount(), this.getWallModService().getKuroTransmitDelay(), lg);
                al.add(up);
            }
            if (downgradeAttempt) {
                LOG.message("---------------------------------------------------------------------------------");
                LOG.message("--                      !! FIRMWARE VERSION NOTICE !!                          --");
                LOG.message("--     One or more firmware versions are higher than the available version.    --");
                LOG.message("--                     To avoid unintentional downgrading,                     --");
                LOG.message("--              Automatic Update has been stopped for those chips.             --");
                LOG.message("---------------------------------------------------------------------------------");
            }
        }
    }

    @Override
    public void triggerRefreshToWallMod(boolean all) {
    }

    @Override
    public BOnyxxWallModule getMyDevice(BComponent c) {
        return BCanFSInterfaceValue.super.getMyDevice(c);
    }

    @Override
    public void setModuleStatus(BStatus stat, String msg, Exception e, BOnyxxWallModule dev) {
        BCanFSInterfaceValue.super.setModuleStatus(stat, msg, e, dev);
    }

    public void poll() {
        this.triggerUpdate();
    }
}

