/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.service;

import com.lynxspring.onyxxwallmodule.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModFirmUpdateJob;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModule;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModuleVAV;
import com.lynxspring.onyxxwallmodule.service.UpdateParams;
import com.lynxspring.platOnyxx.BOnyxxPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import java.security.AccessController;
import java.util.ArrayList;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enable", type="boolean", defaultValue="true"), @NiagaraProperty(name="networkPath", type="String", flags=4, defaultValue="/home/niagara/shared/mp/"), @NiagaraProperty(name="maxFileReadLines", type="int", flags=4, defaultValue="25"), @NiagaraProperty(name="unassignedMAC", type="String", flags=4, defaultValue=""), @NiagaraProperty(name="completionCounter", type="int", flags=4, defaultValue="100"), @NiagaraProperty(name="refreshInterval", type="BTimeTrigger", flags=4, defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeSeconds(30)))"), @NiagaraProperty(name="refreshManager", type="boolean", flags=4, defaultValue="false"), @NiagaraProperty(name="autoAddWallModules", type="boolean", flags=4, defaultValue="true"), @NiagaraProperty(name="kuroAckDelay", type="int", flags=4, defaultValue="20"), @NiagaraProperty(name="kuroPacketCount", type="int", flags=4, defaultValue="1024"), @NiagaraProperty(name="kuroTransmitDelay", type="int", flags=4, defaultValue="400"), @NiagaraProperty(name="kuroLog", type="boolean", flags=4, defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="addWallModule", parameterType="baja:String", flags=16, defaultValue="BString.make(\"\")"), @NiagaraAction(name="refreshWallModService", flags=20), @NiagaraAction(name="removeOldWallModules", flags=16), @NiagaraAction(name="refreshUnassignedMAC", returnType="baja:String"), @NiagaraAction(name="updateFirmware", flags=16)})
public class BOnyxxWallModService
extends BComponent
implements BIService {
    public static final Property enable = BOnyxxWallModService.newProperty((int)0, (boolean)true, null);
    public static final Property networkPath = BOnyxxWallModService.newProperty((int)4, (String)"/home/niagara/shared/mp/", null);
    public static final Property maxFileReadLines = BOnyxxWallModService.newProperty((int)4, (int)25, null);
    public static final Property unassignedMAC = BOnyxxWallModService.newProperty((int)4, (String)"", null);
    public static final Property completionCounter = BOnyxxWallModService.newProperty((int)4, (int)100, null);
    public static final Property refreshInterval = BOnyxxWallModService.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeSeconds((int)30))), null);
    public static final Property refreshManager = BOnyxxWallModService.newProperty((int)4, (boolean)false, null);
    public static final Property autoAddWallModules = BOnyxxWallModService.newProperty((int)4, (boolean)true, null);
    public static final Property kuroAckDelay = BOnyxxWallModService.newProperty((int)4, (int)20, null);
    public static final Property kuroPacketCount = BOnyxxWallModService.newProperty((int)4, (int)1024, null);
    public static final Property kuroTransmitDelay = BOnyxxWallModService.newProperty((int)4, (int)400, null);
    public static final Property kuroLog = BOnyxxWallModService.newProperty((int)4, (boolean)false, null);
    public static final Action addWallModule = BOnyxxWallModService.newAction((int)16, (BValue)BString.make((String)""), null);
    public static final Action refreshWallModService = BOnyxxWallModService.newAction((int)20, null);
    public static final Action removeOldWallModules = BOnyxxWallModService.newAction((int)16, null);
    public static final Action refreshUnassignedMAC = BOnyxxWallModService.newAction((int)0, null);
    public static final Action updateFirmware = BOnyxxWallModService.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BOnyxxWallModService.class);
    public static boolean update_running = false;
    public static boolean networkResetIsEnabled = true;
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxWallModule.class).getModuleName());
    public static Log COMM_LOG = Log.getLog((String)(Sys.getModuleForClass(BOnyxxWallModule.class).getModuleName() + "Comm"));

    public boolean getEnable() {
        return this.getBoolean(enable);
    }

    public void setEnable(boolean v) {
        this.setBoolean(enable, v, null);
    }

    public String getNetworkPath() {
        return this.getString(networkPath);
    }

    public void setNetworkPath(String v) {
        this.setString(networkPath, v, null);
    }

    public int getMaxFileReadLines() {
        return this.getInt(maxFileReadLines);
    }

    public void setMaxFileReadLines(int v) {
        this.setInt(maxFileReadLines, v, null);
    }

    public String getUnassignedMAC() {
        return this.getString(unassignedMAC);
    }

    public void setUnassignedMAC(String v) {
        this.setString(unassignedMAC, v, null);
    }

    public int getCompletionCounter() {
        return this.getInt(completionCounter);
    }

    public void setCompletionCounter(int v) {
        this.setInt(completionCounter, v, null);
    }

    public BTimeTrigger getRefreshInterval() {
        return (BTimeTrigger)this.get(refreshInterval);
    }

    public void setRefreshInterval(BTimeTrigger v) {
        this.set(refreshInterval, (BValue)v, null);
    }

    public boolean getRefreshManager() {
        return this.getBoolean(refreshManager);
    }

    public void setRefreshManager(boolean v) {
        this.setBoolean(refreshManager, v, null);
    }

    public boolean getAutoAddWallModules() {
        return this.getBoolean(autoAddWallModules);
    }

    public void setAutoAddWallModules(boolean v) {
        this.setBoolean(autoAddWallModules, v, null);
    }

    public int getKuroAckDelay() {
        return this.getInt(kuroAckDelay);
    }

    public void setKuroAckDelay(int v) {
        this.setInt(kuroAckDelay, v, null);
    }

    public int getKuroPacketCount() {
        return this.getInt(kuroPacketCount);
    }

    public void setKuroPacketCount(int v) {
        this.setInt(kuroPacketCount, v, null);
    }

    public int getKuroTransmitDelay() {
        return this.getInt(kuroTransmitDelay);
    }

    public void setKuroTransmitDelay(int v) {
        this.setInt(kuroTransmitDelay, v, null);
    }

    public boolean getKuroLog() {
        return this.getBoolean(kuroLog);
    }

    public void setKuroLog(boolean v) {
        this.setBoolean(kuroLog, v, null);
    }

    public void addWallModule(BString parameter) {
        this.invoke(addWallModule, (BValue)parameter, null);
    }

    public void refreshWallModService() {
        this.invoke(refreshWallModService, null, null);
    }

    public void removeOldWallModules() {
        this.invoke(removeOldWallModules, null, null);
    }

    public BString refreshUnassignedMAC() {
        return (BString)this.invoke(refreshUnassignedMAC, null, null);
    }

    public void updateFirmware() {
        this.invoke(updateFirmware, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        AccessController.doPrivileged(() -> {
            try {
                System.loadLibrary("onyxxwallmodule");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.initEnables();
        try {
            BLink l = (BLink)this.get("syncLink");
            if (l == null) {
                BLink lk = new BLink(this.getRefreshInterval().getSlotPathOrd(), "fireTrigger", "refreshWallModService", true);
                this.add("syncLink", (BValue)lk);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doRefreshWallModService() {
        this.initEnables();
        this.autoAddWallModules();
        this.setRefreshManager(!this.getRefreshManager());
    }

    public void doRemoveOldWallModules() {
        OnyxxFileAccess.clearDevIds(this.getFullNetworkPath());
    }

    public void autoAddWallModules() {
        String[] wms;
        if (this.getEnable() && this.getAutoAddWallModules() && (wms = this.getUnassignedWallMods()).length > 0) {
            for (String id : wms) {
                this.doAddWallModule(BString.make((String)id));
            }
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if ((context == null || context != null && !context.toString().contains("decoding")) && property.getType() instanceof BComponent) {
            BComponent c = (BComponent)this.getParentComponent().get(property.getName());
            c.loadSlots();
            if (c instanceof BOnyxxWallModule) {
                String[] wms;
                BOnyxxWallModule w = (BOnyxxWallModule)c;
                if (((BOnyxxWallModule)c).getDevicePath() == "" && (wms = this.getUnassignedWallMods()).length > 0) {
                    w.setDevicePath("onyxx_" + wms[0] + "/");
                }
                w.performNewWallModSetup();
            }
        }
    }

    public void initEnables() {
        BOnyxxWallModule[] devs;
        for (BOnyxxWallModule d : devs = (BOnyxxWallModule[])this.getChildren(BOnyxxWallModule.class)) {
            if (!this.getEnable()) {
                d.setStatus(BStatus.disabled);
                continue;
            }
            if (d.getEnable()) {
                d.setStatus(BStatus.ok);
                continue;
            }
            if (d.getEnable()) continue;
            d.setStatus(BStatus.disabled);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && Sys.atSteadyState() && property.getName().startsWith("enable")) {
            this.initEnables();
        }
    }

    public String getFullNetworkPath() {
        String networkPath = this.getNetworkPath();
        networkPath = BOnyxxWallModule.checkTrailSlash(networkPath);
        return networkPath;
    }

    public BString doRefreshUnassignedMAC() {
        String[] unAss_devs = this.getUnassignedWallMods();
        String val = "";
        for (String ud : unAss_devs) {
            val = val + ud + ",";
        }
        if (val != "") {
            val = val.substring(0, val.lastIndexOf(","));
        }
        this.setUnassignedMAC(val);
        String ret = "";
        if (unAss_devs.length > 0) {
            ret = unAss_devs[0];
        }
        return BString.make((String)ret);
    }

    public void doAddWallModule(BString devid) {
        if (devid.getString().length() == 6) {
            BOnyxxWallModuleVAV wm = new BOnyxxWallModuleVAV();
            wm.setDevicePath("onyxx_" + devid + "/");
            for (int i = 0; i < 10; ++i) {
                String nme = "WallModule" + (i + 1);
                if (this.get(nme) != null) continue;
                this.add(nme, (BValue)wm, 0);
                this.loadSlots();
                this.setUnassignedMAC("");
                break;
            }
        }
    }

    public boolean isDevidAssigned(String devid) {
        BOnyxxWallModule[] mods;
        boolean ret = false;
        for (BOnyxxWallModule m : mods = (BOnyxxWallModule[])this.getChildren(BOnyxxWallModule.class)) {
            if (!m.getDevicePath().contains(devid)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public String[] getUnassignedWallMods() {
        String[] chip_ids;
        ArrayList<String> unAss = new ArrayList<String>();
        for (String cid : chip_ids = this.getDevChipIds()) {
            boolean isAss;
            String[] devChip = cid.split(",");
            if (Integer.parseInt(devChip[1]) != 9 || (isAss = this.isDevidAssigned(devChip[0]))) continue;
            unAss.add(devChip[0]);
        }
        return unAss.toArray(new String[0]);
    }

    public String[] getDevChipIds() {
        ArrayList<String> cids = new ArrayList<String>();
        String[] dvids = OnyxxFileAccess.getDevIds(this.getFullNetworkPath(), this.getMaxFileReadLines());
        String val = "";
        for (String s : dvids) {
            if (s == "" || s == null) continue;
            try {
                val = "";
                val = OnyxxFileAccess.FileIO(this.getFullNetworkPath() + "onyxx_" + s + "/", "chip_id", "", false);
                val = val.trim();
                if (val.isEmpty() || Integer.parseInt(val) != 9) continue;
                cids.add(s + "," + val);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return cids.toArray(new String[0]);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStopped() throws Exception {
    }

    public void sleepTime(int x) {
        try {
            Thread.sleep(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int checkVersion(String systemVer, String currentVer) {
        String[] systemVersion = systemVer.split("\\.");
        String[] currentVersion = currentVer.split("\\.");
        for (int i = 0; i < systemVersion.length || i < currentVersion.length; ++i) {
            if (i < systemVersion.length && i < currentVersion.length) {
                if (Integer.parseInt(systemVersion[i]) < Integer.parseInt(currentVersion[i])) {
                    return -1;
                }
                if (Integer.parseInt(systemVersion[i]) > Integer.parseInt(currentVersion[i])) {
                    return 1;
                }
                if (Integer.parseInt(systemVersion[i]) != Integer.parseInt(currentVersion[i])) continue;
                return 0;
            }
            if (i < systemVersion.length) {
                if (Integer.parseInt(systemVersion[i]) == 0) continue;
                return 1;
            }
            if (i >= currentVersion.length || Integer.parseInt(currentVersion[i]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public static String getProductStr() {
        BSystemPlatformService sps;
        BPlatformServiceContainer psc;
        String productStr = ((BOnyxxPlatformService)Sys.getService((Type)BOnyxxPlatformService.TYPE)).getProduct();
        if (productStr.isEmpty() && (psc = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE)) != null && (sps = (BSystemPlatformService)psc.get("SystemService")) != null) {
            productStr = sps.getProduct();
        }
        return productStr;
    }

    protected void updateWallMods(BOnyxxWallModule[] mods) {
        boolean update_needed = false;
        ArrayList<UpdateParams> devParamList = new ArrayList<UpdateParams>();
        boolean isAutoUpdate = false;
        for (int i = 0; i < mods.length; ++i) {
            if (!mods[i].getEnable()) {
                LOG.message("------   ONYXX UPDATE: Skipping device " + mods[i].getCanbusID() + "; device is disabled.");
                continue;
            }
            if (!mods[i].getStatus().isOk()) {
                LOG.message("------   ONYXX UPDATE: Skipping device " + mods[i].getCanbusID() + "; device status is " + mods[i].getStatus() + ".");
                continue;
            }
            if (!(mods[i] instanceof BOnyxxWallModule)) continue;
            BOnyxxWallModule device = mods[i];
            device.checkWallModUpdateNeed(devParamList, isAutoUpdate, this.getCompletionCounter());
        }
        if (!devParamList.isEmpty()) {
            update_needed = true;
            BJobService.getService().submit((BJob)new BOnyxxWallModFirmUpdateJob(this, devParamList), this.getSession().getSessionContext());
        }
        if (!update_needed) {
            LOG.message(" ");
            LOG.message("------------------------------------------------------------------------------------------");
            LOG.message("            >>>>>>>>>  No Onyxx Updates Needed At This Time  <<<<<<<<<");
            LOG.message("------------------------------------------------------------------------------------------");
            LOG.message(" ");
        }
    }

    public void doUpdateFirmware() {
        String productStr = BOnyxxWallModService.getProductStr();
        boolean update_needed = false;
        BOnyxxWallModule[] mods = (BOnyxxWallModule[])this.getChildren(BOnyxxWallModule.class);
        this.updateWallMods(mods);
    }
}

