/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.service;

import com.lynxspring.onyxxDriver.network.BOnyxxNetwork;
import com.lynxspring.onyxxwallmodule.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModService;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModule;
import com.lynxspring.onyxxwallmodule.service.OnyxxJobsUtil;
import com.lynxspring.onyxxwallmodule.service.UpdateParams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import javax.baja.driver.BDriverContainer;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnyxxWallModFirmUpdateJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnyxxWallModFirmUpdateJob.class);
    private BOnyxxWallModService net = null;
    private ArrayList<UpdateParams> devChipList = null;
    private int numberOfTries = 0;
    public static final Log log = BOnyxxWallModService.LOG;
    private static final int MAX_ATTEMPTS = 20;

    public Type getType() {
        return TYPE;
    }

    public BOnyxxWallModFirmUpdateJob() {
    }

    public BOnyxxWallModFirmUpdateJob(BOnyxxWallModService network, ArrayList<UpdateParams> al) {
        this.net = network;
        this.devChipList = al;
    }

    public int getProgress() {
        return super.getProgress();
    }

    public void setProgress(int i) {
        super.setProgress(i);
    }

    public boolean isAlive() {
        return super.isAlive();
    }

    public void doRun(Context context) {
        super.doRun(context);
    }

    public void doCancel(Context context) {
        this.numberOfTries = 999;
        String cmd = "";
        cmd = "kill -9 $(pidof Kuro)";
        OnyxxJobsUtil.runCommand(cmd);
    }

    private void message(String msg) {
        this.log().message(msg);
        log.message(msg);
    }

    private void message(String msg, String detail) {
        this.log().message(msg, detail);
        log.message(msg);
    }

    public void run(Context context) throws Exception {
        int stepNumber = 0;
        int numSteps = 0;
        boolean isFile = false;
        this.setProgress(0);
        String cmd = "";
        String tarFileName = "OnyxxWallModuleUpdate_Firmware.tar.gz";
        String scriptName = "OnyxxWallModule_Firmware.bash";
        ++numSteps;
        numSteps += this.devChipList.size();
        ++numSteps;
        log.message("");
        log.message("---------------------------------------------------------------------------------");
        log.message("------                   !! FIRMWARE UPDATE NEED DETECTED !!                   --");
        log.message("------   One or more Onyxx devices was found to need a firmware update.        --");
        log.message("------   Job progress will be displayed below and output lines are             --");
        log.message("------   signified by \"------\".                                                --");
        log.message("---------------------------------------------------------------------------------");
        for (int attempts = 0; BOnyxxWallModService.update_running && attempts <= 20; ++attempts) {
            if (attempts == 20) {
                log.message("------   ---> Firmware Update: Max Attempts reached.  Exiting upgrade!! ...");
                log.message("------   ---> Firmware Update: Will try again at next Station Start");
                return;
            }
            this.net.sleepTime(30000);
            log.message("------   ---> Firmware Update:  Other Upgrade Running (File System) -- Pausing 30 sec...");
        }
        BOnyxxWallModService.update_running = true;
        BOnyxxWallModService.networkResetIsEnabled = false;
        this.net.setEnable(false);
        log.trace("OnyxxWallModService state: now disabled.");
        BDriverContainer drv = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
        BOnyxxNetwork[] on = (BOnyxxNetwork[])drv.getChildren(BOnyxxNetwork.class);
        if (on.length > 0) {
            on[0].setEnabled(false);
            log.trace("OnyxxNetwork state: now disabled.");
        }
        this.setProgress(5);
        log.message("------   ---> Firmware Update Progress:  " + this.getProgress() + "%   --  Firmware Upgrade Started...");
        ++stepNumber;
        this.transferTarBall();
        cmd = "rm -fr /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        this.setProgress(100 / numSteps * stepNumber);
        log.message("------   ---> Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Needed Files have been Unzipped...");
        this.log().success("Needed Files have been unzipped for Firmware Upgrade Process");
        scriptName = "OnyxxWallModule_Firmware.bash";
        cmd = "chmod 777 /tmp/resources/Firmware/" + scriptName;
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/Firmware/Kuro";
        OnyxxJobsUtil.runCommand(cmd);
        for (UpdateParams up : this.devChipList) {
            ++stepNumber;
            String scriptCheck = "";
            String devType = up.getDeviceType();
            String devName = "";
            String canID = up.getCanID();
            String chipID = up.getChipID().toString();
            devName = "Onyxx_WM";
            cmd = "echo DeviceName:" + devName + " > /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo CanID:" + canID + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo ChipID:" + chipID + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            String logName = "FirmwareUpdate_" + devName + "_" + canID + "_" + chipID + ".log";
            String checkFilename = "" + devName + "_" + canID + "_" + chipID + '_' + "Process.txt";
            cmd = "echo LogName: " + logName + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo kuroAckDelay: " + up.getKuroAckDelay() + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo kuroPacketCount: " + up.getKuroPacketCount() + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo kuroTransmitDelay: " + up.getKuroTransmitDelay() + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            cmd = "echo kuroLog: " + up.getKuroLog() + " >> /tmp/resources/Firmware/parameters.txt";
            OnyxxJobsUtil.runCommand(cmd);
            log.message("------ <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            log.message("------   Running Firmware upgrade for device " + devName + " -- " + canID);
            log.message("------     -- Updating Chip Number " + chipID + ".");
            log.message("------ <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            cmd = "/bin/bash /tmp/resources/Firmware/" + scriptName + "&";
            OnyxxJobsUtil.runCommand(cmd);
            isFile = false;
            this.numberOfTries = 0;
            while (!isFile) {
                log.message("------     Checking for Completion...");
                File f = new File("/tmp/resources/Firmware/" + checkFilename);
                if (f.exists()) {
                    isFile = true;
                    scriptCheck = OnyxxFileAccess.FileIO("/tmp/resources/Firmware", checkFilename, null, false);
                    continue;
                }
                if (this.numberOfTries >= up.getCompletionCounter()) {
                    TimeoutException exception = new TimeoutException("Update of device " + canID + " chip " + chipID + " exceeded allotted time.");
                    log.message("------   #### ERROR:  FIRMWARE UPDATE FAILED!!! ####");
                    log.message("------   #### Exiting Update Job... ####");
                    this.log().failed("Update of device " + canID + " chip " + chipID + " did not complete in the expected time", (Throwable)exception);
                    BOnyxxWallModService.update_running = false;
                    this.net.setEnable(true);
                    log.trace("Restored OnyxxNetwork state: enabled = " + this.net.getEnable() + ".");
                    throw exception;
                }
                int t = up.getCompletionCounter() - this.numberOfTries;
                log.message("----   Still running, Time outs remaining: " + t + " ...checking again in 5 seconds!");
                this.net.sleepTime(5000);
                ++this.numberOfTries;
            }
            this.setProgress(100 / numSteps * stepNumber);
            BOnyxxWallModule[] devices = (BOnyxxWallModule[])this.net.getChildren(BOnyxxWallModule.class);
            String devDisName = "";
            for (BOnyxxWallModule dev : devices) {
                if (!dev.getCanbusID().equals(canID)) continue;
                devDisName = dev.getDisplayName(null);
            }
            if (scriptCheck.equals("complete")) {
                log.message("------   ---> Firmware Update Progress (" + stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%  --  Chip " + chipID + " Firmware updated on device " + devDisName + "...");
                this.log().success("Firmware Update Complete for chip " + chipID + " on device " + devDisName + ".");
                if (up.getChipID() != 1) continue;
                try {
                    OnyxxFileAccess.FileIO(this.net.getNetworkPath() + "platform/", "heartbeat", "running", true);
                }
                catch (Exception e) {
                    log.error("Error when resetting heartbeat LED's state: " + e.getMessage());
                }
                continue;
            }
            Exception exception = new Exception("An error occurred while updating device " + canID + " chip " + chipID + ".");
            log.message("------   #### ERROR:  FIRMWARE UPDATE FAILED!!! ####");
            log.message("------   #### Exiting Update Job... ####");
            this.log().failed("Update of device " + canID + " chip " + chipID + " encountered an error", (Throwable)exception);
            BOnyxxWallModService.update_running = false;
            this.net.setEnable(true);
            log.trace("OnyxxWallModuleService state: now enabled.");
            if (on.length > 0) {
                on[0].setEnabled(true);
                log.trace("OnyxxNetwork state: now enabled.");
            }
            throw exception;
        }
        cmd = "rm -rf /tmp/resources/Firmware";
        this.setProgress(100);
        log.message("------   ---> Firmware Update Progress (" + ++stepNumber + "/" + numSteps + "):  " + this.getProgress() + "%");
        log.message("--------------------------------------------------------------------------------------");
        log.message("------   ~~ FIRMWARE UPDATE HAS FINISHED FOR ALL DEVICES ON THE ONYXX NETWORK ~~    --");
        log.message("--------------------------------------------------------------------------------------");
        log.message("");
        log.message("");
        BOnyxxWallModService.update_running = false;
        BOnyxxWallModService.networkResetIsEnabled = true;
        this.net.setEnable(true);
        log.trace("OnyxxWallModuleService state: now enabled.");
        if (on.length > 0) {
            on[0].setEnabled(true);
            log.trace("OnyxxNetwork state: now enabled.");
        }
        this.log().success("Un-needed Files have been removed.");
    }

    private void transferTarBall() {
        String cmd = null;
        Object helixxEnvironmentVariableContents = null;
        String jarPath = "/opt/niagara/modules/onyxxwallmodule-rt.jar";
        String resourcesPath = "/home/niagara/stations/" + Sys.getStation().getStationName() + "/resources";
        cmd = "rm -rf /tmp/resources";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /tmp/resources/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "cat /etc/os-release > /tmp/resources/Firmware/os_release.txt";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "chmod 777 /tmp/resources/Firmware/os_release.txt";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = this.running_on_Debian() ? "/usr/lib/jvm/jdk1.8.0_101/bin/jar xf " + jarPath + " resources/" : "unzip -q -d . " + jarPath + " resources/*";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mv " + resourcesPath + "/* /tmp/resources/";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "tar xfz /tmp/resources/OnyxxWallModuleUpdate_Firmware.tar.gz -C /tmp/resources/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "rm -rf /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
        cmd = "mkdir -p /var/log/updateLogs/Firmware";
        OnyxxJobsUtil.runCommand(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean running_on_Debian() {
        boolean returnValue = false;
        String line = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("/tmp/resources/Firmware/os_release.txt"));
            line = br.readLine();
            while (line != null) {
                if (line.indexOf("Debian GNU/Linux") > -1) {
                    returnValue = true;
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Error reading OS Definition file");
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                log.error("Error occurred during buffered reader close method for OS definition file", (Throwable)e);
            }
        }
        return returnValue;
    }
}

