/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.property.wallmodule;

import com.lynxspring.onyxxwallmodule.property.BCanFSInterfaceValue;
import com.lynxspring.onyxxwallmodule.property.BWallModulePropertyBase;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModule;
import com.tridium.basicdriver.util.BIBasicPollable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.make(2)"), @NiagaraProperty(name="out", type="BStatusString", flags=267, defaultValue="new BStatusString()"), @NiagaraProperty(name="lastUpdateSuccess", type="boolean", flags=1, defaultValue="false"), @NiagaraProperty(name="lastUpdateTimeMS", type="long", flags=1, defaultValue="0"), @NiagaraProperty(name="propertyBase", type="BWallModulePropertyBase", flags=5, defaultValue="BWallModulePropertyBase.make(0)"), @NiagaraProperty(name="powerCycled", type="boolean", flags=5, defaultValue="false")})
@NiagaraAction(name="runUpdate", flags=16)
public class BWallModTime
extends BComponent
implements BCanFSInterfaceValue,
BIBasicPollable {
    public static final Property pollFrequency = BWallModTime.newProperty((int)0, (BValue)BPollFrequency.make((int)2), null);
    public static final Property out = BWallModTime.newProperty((int)267, (BValue)new BStatusString(), null);
    public static final Property lastUpdateSuccess = BWallModTime.newProperty((int)1, (boolean)false, null);
    public static final Property lastUpdateTimeMS = BWallModTime.newProperty((int)1, (int)0, null);
    public static final Property propertyBase = BWallModTime.newProperty((int)5, (BValue)BWallModulePropertyBase.make(0), null);
    public static final Property powerCycled = BWallModTime.newProperty((int)5, (boolean)false, null);
    public static final Action runUpdate = BWallModTime.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BWallModTime.class);
    private String val = "";
    private static final String WM_STATUS_FOLDER = "wm_status/";
    private static final String WM_TIME_NAME = "time";

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public BStatusString getOut() {
        return (BStatusString)this.get(out);
    }

    public void setOut(BStatusString v) {
        this.set(out, (BValue)v, null);
    }

    public boolean getLastUpdateSuccess() {
        return this.getBoolean(lastUpdateSuccess);
    }

    public void setLastUpdateSuccess(boolean v) {
        this.setBoolean(lastUpdateSuccess, v, null);
    }

    public long getLastUpdateTimeMS() {
        return this.getLong(lastUpdateTimeMS);
    }

    public void setLastUpdateTimeMS(long v) {
        this.setLong(lastUpdateTimeMS, v, null);
    }

    public BWallModulePropertyBase getPropertyBase() {
        return (BWallModulePropertyBase)this.get(propertyBase);
    }

    public void setPropertyBase(BWallModulePropertyBase v) {
        this.set(propertyBase, (BValue)v, null);
    }

    public boolean getPowerCycled() {
        return this.getBoolean(powerCycled);
    }

    public void setPowerCycled(boolean v) {
        this.setBoolean(powerCycled, v, null);
    }

    public void runUpdate() {
        this.invoke(runUpdate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.setPropertyBase(BWallModulePropertyBase.ServiceOwned);
        BOnyxxWallModule wm = this.getMyDevice(this);
        wm.getPollScheduler().subscribe((BIPollable)this);
    }

    public String toString(Context context) {
        return this.getOut().toString();
    }

    public static String writeFile(byte[] data, String path, String file, int sz) throws Exception {
        FileOutputStream fs = null;
        try {
            File valueFile = new File(path, file);
            fs = new FileOutputStream(valueFile);
            fs.write(data, 0, sz);
            fs.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occured during print writer close method for " + path + "/" + file, e);
            }
        }
        return "0";
    }

    public void doRunUpdate() {
        try {
            final BOnyxxWallModule dev = this.getMyDevice(this);
            if (dev != null && this.getCommOk(this)) {
                final String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
                final String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
                new Thread(){

                    @Override
                    public void run() {
                        String val = "";
                        try {
                            Instant instl = Instant.now();
                            long epSec = instl.getEpochSecond();
                            byte[] buf = new byte[]{(byte)(epSec & 0xFFL), (byte)((epSec & 0xFF00L) >> 8), (byte)((epSec & 0xFF0000L) >> 16), (byte)((epSec & 0xFFFFFFFFFF000000L) >> 24), 0, 0};
                            val = BAbsTime.now().toLocalTime().toString();
                            long elapsed = System.currentTimeMillis();
                            BWallModTime.this.setLastUpdateSuccess(false);
                            BWallModTime.writeFile(buf, networkPath + devicePath + BWallModTime.WM_STATUS_FOLDER, BWallModTime.WM_TIME_NAME, 6);
                            BWallModTime.this.setLastUpdateTimeMS(System.currentTimeMillis() - elapsed);
                            BWallModTime.this.setLastUpdateSuccess(true);
                            BWallModTime.this.getOut().setValue(val);
                        }
                        catch (Exception e) {
                            BWallModTime.this.setModuleStatus(BStatus.fault, "", e, dev);
                        }
                    }
                }.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPowerCycledFlag(boolean pwr) {
        boolean p = pwr;
        if (this.getPropertyBase().getOrdinal() == 2) {
            p = false;
        }
        this.setPowerCycled(p);
    }

    @Override
    public void triggerRefreshToWallMod(boolean all) {
        this.runUpdate();
    }

    @Override
    public boolean dataValidCheck(String val) {
        return true;
    }

    @Override
    public void triggerUpdate() {
        this.invoke(runUpdate, null);
    }

    @Override
    public BOnyxxWallModule getMyDevice(BComponent c) {
        return BCanFSInterfaceValue.super.getMyDevice(c);
    }

    public void poll() {
        this.triggerUpdate();
    }
}

