/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.property.wallmodule;

import com.lynxspring.onyxxwallmodule.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxwallmodule.property.BCanFSRawValue;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModule;
import java.util.Arrays;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="radarInstalled", type="boolean", defaultValue="false", flags=1, facets={@Facet(value="BFacets.makeBoolean(\"Installed\", \"Not Installed\")")}), @NiagaraProperty(name="radarSensor", type="boolean", defaultValue="true", facets={@Facet(value="BFacets.makeBoolean(\"Enable\", \"Disable\")")}), @NiagaraProperty(name="radarThreshold", type="BDynamicEnum", defaultValue="BDynamicEnum.make(3)"), @NiagaraProperty(name="radarHoldTime", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0)"), @NiagaraProperty(name="radarPLLFrequency", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0)"), @NiagaraProperty(name="firstTimeInit", type="boolean", defaultValue="true", flags=5)})
public class BWallModRadarConfig
extends BCanFSRawValue {
    public static final Property radarInstalled = BWallModRadarConfig.newProperty((int)1, (boolean)false, (BFacets)BFacets.makeBoolean((String)"Installed", (String)"Not Installed"));
    public static final Property radarSensor = BWallModRadarConfig.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"Enable", (String)"Disable"));
    public static final Property radarThreshold = BWallModRadarConfig.newProperty((int)0, (BValue)BDynamicEnum.make((int)3), null);
    public static final Property radarHoldTime = BWallModRadarConfig.newProperty((int)0, (BValue)BDynamicEnum.make((int)0), null);
    public static final Property radarPLLFrequency = BWallModRadarConfig.newProperty((int)0, (BValue)BDynamicEnum.make((int)0), null);
    public static final Property firstTimeInit = BWallModRadarConfig.newProperty((int)5, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BWallModRadarConfig.class);
    private static final String WM_READINGS_FOLDER = "wm_settings/";
    private static final String WM_READING_NAME = "radarConfig";
    private static final String WM_STATUS_FOLDER = "wm_status/";
    private static final String WM_STATUS_NAME = "op_status";
    private boolean installed = false;
    private byte[] updatedValue = new byte[]{0, 0, 0, 0, 0, 0};

    public boolean getRadarInstalled() {
        return this.getBoolean(radarInstalled);
    }

    public void setRadarInstalled(boolean v) {
        this.setBoolean(radarInstalled, v, null);
    }

    public boolean getRadarSensor() {
        return this.getBoolean(radarSensor);
    }

    public void setRadarSensor(boolean v) {
        this.setBoolean(radarSensor, v, null);
    }

    public BDynamicEnum getRadarThreshold() {
        return (BDynamicEnum)this.get(radarThreshold);
    }

    public void setRadarThreshold(BDynamicEnum v) {
        this.set(radarThreshold, (BValue)v, null);
    }

    public BDynamicEnum getRadarHoldTime() {
        return (BDynamicEnum)this.get(radarHoldTime);
    }

    public void setRadarHoldTime(BDynamicEnum v) {
        this.set(radarHoldTime, (BValue)v, null);
    }

    public BDynamicEnum getRadarPLLFrequency() {
        return (BDynamicEnum)this.get(radarPLLFrequency);
    }

    public void setRadarPLLFrequency(BDynamicEnum v) {
        this.set(radarPLLFrequency, (BValue)v, null);
    }

    public boolean getFirstTimeInit() {
        return this.getBoolean(firstTimeInit);
    }

    public void setFirstTimeInit(boolean v) {
        this.setBoolean(firstTimeInit, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BWallModRadarConfig() {
        this.setAllowSendToWallModule(true);
        this.setFolderName(WM_READINGS_FOLDER);
        this.setPointName(WM_READING_NAME);
    }

    public void reloadValues() {
        if (this.getFirstTimeInit()) {
            this.setSavedRaw("060400000000");
            this.setFirstTimeInit(false);
        }
        if (this.getCommOk(this)) {
            byte[] zeroCheck = new byte[]{0, 0, 0, 0, 0, 0};
            byte[] currentValue = this.getRawData();
            if (!Arrays.equals(currentValue, zeroCheck)) {
                System.arraycopy(currentValue, 0, this.updatedValue, 0, 6);
                if (this.getRadarInstalled()) {
                    if ((currentValue[0] & 1) == 1) {
                        this.setRadarSensor(true);
                    } else {
                        this.setRadarSensor(false);
                    }
                    int thrs = (currentValue[0] & 0x1E) >> 1;
                    String[] thresholds = new String[]{SlotPath.escape((String)"66"), SlotPath.escape((String)"90"), SlotPath.escape((String)"136"), SlotPath.escape((String)"248"), SlotPath.escape((String)"384"), SlotPath.escape((String)"640"), SlotPath.escape((String)"1344"), SlotPath.escape((String)"2560")};
                    this.setRadarThreshold(BDynamicEnum.make((int)thrs, (BEnumRange)BEnumRange.make((String[])thresholds)));
                    int holdTime = (currentValue[0] & 0xE0) >> 5;
                    String[] hldTimes = new String[]{SlotPath.escape((String)"3sec"), SlotPath.escape((String)"10sec"), SlotPath.escape((String)"60sec"), SlotPath.escape((String)"90sec"), SlotPath.escape((String)"5min"), SlotPath.escape((String)"15min")};
                    this.setRadarHoldTime(BDynamicEnum.make((int)holdTime, (BEnumRange)BEnumRange.make((String[])hldTimes)));
                    int pll = currentValue[1] & 3;
                    String[] pllFreqs = new String[]{SlotPath.escape((String)"61.1Ghz"), SlotPath.escape((String)"61.2Ghz"), SlotPath.escape((String)"61.3Ghz"), SlotPath.escape((String)"61.4Ghz")};
                    this.setRadarPLLFrequency(BDynamicEnum.make((int)pll, (BEnumRange)BEnumRange.make((String[])pllFreqs)));
                }
            }
        }
    }

    public void started() throws Exception {
        super.started();
    }

    @Override
    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.reloadValues();
    }

    @Override
    public void setSignalValueChange(boolean v) {
        super.setSignalValueChange(v);
        if (this.getSignalValueChange()) {
            this.reloadValues();
        }
    }

    @Override
    public boolean dataValidCheck(String val) {
        boolean ret = false;
        if (!val.matches("000000000000")) {
            ret = true;
        }
        return ret;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context != null && this.isRunning() && Sys.atSteadyState()) {
            byte v;
            if (property.getName().startsWith("radarSensor")) {
                v = (byte)(this.getRadarSensor() ? 1 : 0);
                this.updatedValue[0] = (byte)(this.updatedValue[0] & 0xFFFFFFFE | v);
            }
            if (property.getName().startsWith("radarThreshold")) {
                v = (byte)(this.getRadarThreshold().getOrdinal() << 1);
                this.updatedValue[0] = (byte)(this.updatedValue[0] & 0xFFFFFFE1 | v);
            }
            if (property.getName().startsWith("radarHoldTime")) {
                v = (byte)(this.getRadarHoldTime().getOrdinal() << 5);
                this.updatedValue[0] = (byte)(this.updatedValue[0] & 0xFFFFFF1F | v);
            }
            if (property.getName().startsWith("radarPLLFreq")) {
                v = (byte)this.getRadarPLLFrequency().getOrdinal();
                this.updatedValue[1] = (byte)(this.updatedValue[0] & 0xFFFFFFFC | v);
            }
            this.setRawData(this.updatedValue);
        }
    }

    @Override
    public void doRunUpdate() {
        super.doRunUpdate();
        if (this.getCommOk(this)) {
            this.installed = this.readRadarInstalled();
            if (this.installed) {
                this.setRadarInstalled(true);
                this.setFlags((Slot)radarSensor, this.getFlags((Slot)radarSensor) & 0xFFFFFFFE);
                this.setFlags((Slot)radarThreshold, this.getFlags((Slot)radarThreshold) & 0xFFFFFFFE);
                this.setFlags((Slot)radarHoldTime, this.getFlags((Slot)radarHoldTime) & 0xFFFFFFFE);
                this.setFlags((Slot)radarPLLFrequency, this.getFlags((Slot)radarPLLFrequency) & 0xFFFFFFFE);
            } else {
                this.setRadarInstalled(false);
                this.setFlags((Slot)radarSensor, this.getFlags((Slot)radarSensor) | 1);
                this.setFlags((Slot)radarThreshold, this.getFlags((Slot)radarThreshold) | 1);
                this.setFlags((Slot)radarHoldTime, this.getFlags((Slot)radarHoldTime) | 1);
                this.setFlags((Slot)radarPLLFrequency, this.getFlags((Slot)radarPLLFrequency) | 1);
            }
        }
    }

    private boolean readRadarInstalled() {
        boolean ret;
        block5: {
            ret = false;
            try {
                BOnyxxWallModule dev = this.getMyDevice(this);
                if (dev == null) break block5;
                String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
                String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
                String val = "";
                try {
                    Integer i;
                    short sv;
                    val = OnyxxFileAccess.FileIO(networkPath + devicePath + WM_STATUS_FOLDER, WM_STATUS_NAME, "", false);
                    if (val != "" && ((sv = (i = new Integer(val)).shortValue()) & 2) == 2) {
                        ret = true;
                    }
                }
                catch (Exception e) {
                    this.setModuleStatus(BStatus.fault, "", e, dev);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

