/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.property.proxy;

import com.lynxspring.onyxxwallmodule.property.proxy.BWallModConversion;
import com.lynxspring.onyxxwallmodule.property.proxy.BWallModuleProxyValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BWallModLinearConv
extends BWallModConversion {
    public static final BWallModLinearConv DEFAULT = new BWallModLinearConv(1.0, 0.0);
    public static final Type TYPE = Sys.loadType(BWallModLinearConv.class);
    private double scale;
    private double offset;
    private int hashCode = -1;

    public static BWallModLinearConv make(double scale, double offset) {
        if (scale == 1.0 && offset == 0.0) {
            return DEFAULT;
        }
        return (BWallModLinearConv)new BWallModLinearConv(scale, offset).intern();
    }

    private BWallModLinearConv(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public double getScale() {
        return this.scale;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public void convertDeviceToProxy(BWallModuleProxyValue ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            BWallModLinearConv.convert(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true, this.scale, this.offset);
        } else {
            proxyValue.copyFrom((BComplex)deviceValue);
        }
    }

    @Override
    public void convertProxyToDevice(BWallModuleProxyValue ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            BWallModLinearConv.convert(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false, this.scale, this.offset);
        } else {
            deviceValue.copyFrom((BComplex)proxyValue);
        }
    }

    static void convert(BWallModuleProxyValue ext, BStatusNumeric from, BStatusNumeric to, boolean deviceToProxy, double scale, double offset) {
        double fromValue = from.getValue();
        double toValue = deviceToProxy ? fromValue * scale + offset : (fromValue - offset) / scale;
        to.setStatus(from.getStatus());
        to.setValue(toValue);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + Double.doubleToRawLongBits(this.offset);
            hash = hash * 37L + Double.doubleToRawLongBits(this.scale);
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BWallModLinearConv) {
            BWallModLinearConv x = (BWallModLinearConv)((Object)obj);
            return this.scale == x.scale && this.offset == x.offset;
        }
        return false;
    }

    public String toString(Context context) {
        StringBuffer s = new StringBuffer();
        s.append(TYPE.getDisplayName(context));
        if (this.scale != 1.0) {
            s.append(" *").append(BDouble.toString((double)this.scale, (Context)context));
        }
        if (this.offset < 0.0) {
            s.append(' ').append(BDouble.toString((double)this.offset, (Context)context));
        } else if (this.offset > 0.0) {
            s.append(" +").append(BDouble.toString((double)this.offset, (Context)context));
        }
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.offset);
    }

    public BObject decode(DataInput in) throws IOException {
        return BWallModLinearConv.make(in.readDouble(), in.readDouble());
    }

    public String encodeToString() {
        return BDouble.encode((double)this.scale) + ";" + BDouble.encode((double)this.offset);
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(59);
        return BWallModLinearConv.make(BDouble.decode((String)s.substring(0, semi)), BDouble.decode((String)s.substring(semi + 1)));
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

