/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.property;

import com.lynxspring.onyxxwallmodule.fileIO.OnyxxFileAccess;
import com.lynxspring.onyxxwallmodule.property.BCanFSInterfaceValue;
import com.lynxspring.onyxxwallmodule.property.BWallModulePropertyBase;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModService;
import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModule;
import com.tridium.basicdriver.util.BIBasicPollable;
import java.util.Arrays;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.make(0)"), @NiagaraProperty(name="allowSendToWallModule", type="boolean", flags=4, defaultValue="false"), @NiagaraProperty(name="allowUpdateFromWallModule", type="boolean", flags=4, defaultValue="true"), @NiagaraProperty(name="triggerUpdateToWallModule", type="boolean", flags=4, defaultValue="false"), @NiagaraProperty(name="folderName", type="String", flags=4, defaultValue=""), @NiagaraProperty(name="pointName", type="String", flags=4, defaultValue=""), @NiagaraProperty(name="signalValueChange", type="boolean", flags=4, defaultValue="false"), @NiagaraProperty(name="lastUpdateSuccess", type="boolean", flags=5, defaultValue="false"), @NiagaraProperty(name="lastUpdateTimeMS", type="long", flags=5, defaultValue="0"), @NiagaraProperty(name="propertyBase", type="BWallModulePropertyBase", flags=5, defaultValue="BWallModulePropertyBase.make(0)"), @NiagaraProperty(name="powerCycled", type="boolean", flags=5, defaultValue="false"), @NiagaraProperty(name="savedRaw", type="String", flags=5, defaultValue="")})
@NiagaraAction(name="runUpdate", flags=16)
public class BCanFSRawValue
extends BComponent
implements BCanFSInterfaceValue,
BIBasicPollable {
    public static final Property pollFrequency = BCanFSRawValue.newProperty((int)0, (BValue)BPollFrequency.make((int)0), null);
    public static final Property allowSendToWallModule = BCanFSRawValue.newProperty((int)4, (boolean)false, null);
    public static final Property allowUpdateFromWallModule = BCanFSRawValue.newProperty((int)4, (boolean)true, null);
    public static final Property triggerUpdateToWallModule = BCanFSRawValue.newProperty((int)4, (boolean)false, null);
    public static final Property folderName = BCanFSRawValue.newProperty((int)4, (String)"", null);
    public static final Property pointName = BCanFSRawValue.newProperty((int)4, (String)"", null);
    public static final Property signalValueChange = BCanFSRawValue.newProperty((int)4, (boolean)false, null);
    public static final Property lastUpdateSuccess = BCanFSRawValue.newProperty((int)5, (boolean)false, null);
    public static final Property lastUpdateTimeMS = BCanFSRawValue.newProperty((int)5, (int)0, null);
    public static final Property propertyBase = BCanFSRawValue.newProperty((int)5, (BValue)BWallModulePropertyBase.make(0), null);
    public static final Property powerCycled = BCanFSRawValue.newProperty((int)5, (boolean)false, null);
    public static final Property savedRaw = BCanFSRawValue.newProperty((int)5, (String)"", null);
    public static final Action runUpdate = BCanFSRawValue.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BCanFSRawValue.class);
    private byte[] lastValue = new byte[]{0, 0, 0, 0, 0, 0};
    private byte[] currentValue = new byte[]{0, 0, 0, 0, 0, 0};
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxWallModService.class).getModuleName());

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public boolean getAllowSendToWallModule() {
        return this.getBoolean(allowSendToWallModule);
    }

    public void setAllowSendToWallModule(boolean v) {
        this.setBoolean(allowSendToWallModule, v, null);
    }

    public boolean getAllowUpdateFromWallModule() {
        return this.getBoolean(allowUpdateFromWallModule);
    }

    public void setAllowUpdateFromWallModule(boolean v) {
        this.setBoolean(allowUpdateFromWallModule, v, null);
    }

    public boolean getTriggerUpdateToWallModule() {
        return this.getBoolean(triggerUpdateToWallModule);
    }

    public void setTriggerUpdateToWallModule(boolean v) {
        this.setBoolean(triggerUpdateToWallModule, v, null);
    }

    public String getFolderName() {
        return this.getString(folderName);
    }

    public void setFolderName(String v) {
        this.setString(folderName, v, null);
    }

    public String getPointName() {
        return this.getString(pointName);
    }

    public void setPointName(String v) {
        this.setString(pointName, v, null);
    }

    public boolean getSignalValueChange() {
        return this.getBoolean(signalValueChange);
    }

    public void setSignalValueChange(boolean v) {
        this.setBoolean(signalValueChange, v, null);
    }

    public boolean getLastUpdateSuccess() {
        return this.getBoolean(lastUpdateSuccess);
    }

    public void setLastUpdateSuccess(boolean v) {
        this.setBoolean(lastUpdateSuccess, v, null);
    }

    public long getLastUpdateTimeMS() {
        return this.getLong(lastUpdateTimeMS);
    }

    public void setLastUpdateTimeMS(long v) {
        this.setLong(lastUpdateTimeMS, v, null);
    }

    public BWallModulePropertyBase getPropertyBase() {
        return (BWallModulePropertyBase)this.get(propertyBase);
    }

    public void setPropertyBase(BWallModulePropertyBase v) {
        this.set(propertyBase, (BValue)v, null);
    }

    public boolean getPowerCycled() {
        return this.getBoolean(powerCycled);
    }

    public void setPowerCycled(boolean v) {
        this.setBoolean(powerCycled, v, null);
    }

    public String getSavedRaw() {
        return this.getString(savedRaw);
    }

    public void setSavedRaw(String v) {
        this.setString(savedRaw, v, null);
    }

    public void runUpdate() {
        this.invoke(runUpdate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        BOnyxxWallModule wm = this.getMyDevice(this);
        wm.getPollScheduler().subscribe((BIPollable)this);
        this.doRunUpdate();
    }

    public byte[] getRawData() {
        return this.currentValue;
    }

    public void setRawData(byte[] chg) {
        System.arraycopy(chg, 0, this.currentValue, 0, 6);
        this.writeUpdateToWallMod();
    }

    public boolean writeUpdateToWallMod() {
        boolean ret = false;
        if (this.getCommOk(this)) {
            if (this.getAllowSendToWallModule()) {
                BOnyxxWallModule dev = this.getMyDevice(this);
                if (dev != null) {
                    String devicePath = dev.getDevicePath();
                    String networkPath = dev.getWallModService().getNetworkPath();
                    devicePath = BOnyxxWallModule.checkTrailSlash(devicePath);
                    networkPath = BOnyxxWallModule.checkTrailSlash(networkPath);
                    try {
                        OnyxxFileAccess.writeFile(this.currentValue, networkPath + devicePath + this.getFolderName(), this.getPointName(), 6);
                        ret = true;
                    }
                    catch (Exception e) {
                        LOG.log(3, "CanFSRawValue:writeUpdateToWallMod:" + this.getPointName(), (Throwable)e);
                        this.setModuleStatus(BStatus.fault, "", e, dev);
                    }
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    public void doRunUpdate() {
        try {
            if (this.getCommOk(this)) {
                final BOnyxxWallModule dev = this.getMyDevice(this);
                if (this.getAllowUpdateFromWallModule() && dev != null && !this.getPowerCycled()) {
                    final String devicePath = BOnyxxWallModule.checkTrailSlash(dev.getDevicePath());
                    final String networkPath = BOnyxxWallModule.checkTrailSlash(dev.getWallModService().getNetworkPath());
                    new Thread(){

                        @Override
                        public void run() {
                            String val = "";
                            boolean fault = true;
                            try {
                                long elapsed = System.currentTimeMillis();
                                BCanFSRawValue.this.setLastUpdateSuccess(false);
                                val = OnyxxFileAccess.FileIO(networkPath + devicePath + BCanFSRawValue.this.getFolderName(), BCanFSRawValue.this.getPointName(), "", false);
                                BCanFSRawValue.this.setLastUpdateTimeMS(System.currentTimeMillis() - elapsed);
                                BCanFSRawValue.this.setLastUpdateSuccess(true);
                                if (val.length() == 12) {
                                    if (BCanFSRawValue.this.dataValidCheck(val)) {
                                        BCanFSRawValue.this.setSavedRaw(val);
                                        fault = false;
                                    }
                                } else {
                                    BCanFSRawValue.this.setPowerCycled(true);
                                    BCanFSRawValue.this.setTriggerUpdateToWallModule(true);
                                }
                            }
                            catch (Exception e) {
                                LOG.log(3, "CanFSRawValue:doRunUpdate:" + BCanFSRawValue.this.getPointName(), (Throwable)e);
                                BCanFSRawValue.this.setModuleStatus(BStatus.fault, "", e, dev);
                            }
                            if (val != "" && !fault) {
                                BCanFSRawValue.this.parseRaw(val);
                            }
                        }
                    }.start();
                } else if (this.getPowerCycled()) {
                    this.setTriggerUpdateToWallModule(true);
                }
                if (this.getTriggerUpdateToWallModule()) {
                    this.setTriggerUpdateToWallModule(false);
                    if (this.getPowerCycled()) {
                        this.lastValue = new byte[]{0, 0, 0, 0, 0, 0};
                        this.parseRaw(this.getSavedRaw());
                    }
                    this.writeUpdateToWallMod();
                    this.setPowerCycled(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseRaw(String val) {
        BOnyxxWallModule dev = this.getMyDevice(this);
        if (val.length() >= 12) {
            try {
                Integer i1 = Integer.parseInt(val.substring(0, 2), 16);
                this.currentValue[0] = i1.byteValue();
                Integer i2 = Integer.parseInt(val.substring(2, 4), 16);
                this.currentValue[1] = i2.byteValue();
                Integer i3 = Integer.parseInt(val.substring(4, 6), 16);
                this.currentValue[2] = i3.byteValue();
                Integer i4 = Integer.parseInt(val.substring(6, 8), 16);
                this.currentValue[3] = i4.byteValue();
                Integer i5 = Integer.parseInt(val.substring(8, 10), 16);
                this.currentValue[4] = i5.byteValue();
                Integer i6 = Integer.parseInt(val.substring(10, 12), 16);
                this.currentValue[5] = i6.byteValue();
            }
            catch (NumberFormatException i1) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!Arrays.equals(this.currentValue, this.lastValue)) {
            System.arraycopy(this.currentValue, 0, this.lastValue, 0, 6);
            this.setSignalValueChange(true);
        } else {
            this.setSignalValueChange(false);
        }
    }

    @Override
    public void triggerRefreshToWallMod(boolean all) {
        if (this.getPropertyBase().getOrdinal() == 1 || all && this.getPropertyBase().getOrdinal() == 0) {
            this.setTriggerUpdateToWallModule(true);
        }
    }

    @Override
    public void setPowerCycledFlag(boolean pwr) {
        boolean p = pwr;
        if (this.getPropertyBase().getOrdinal() == 2) {
            p = false;
        }
        this.setPowerCycled(p);
    }

    @Override
    public boolean dataValidCheck(String val) {
        return true;
    }

    @Override
    public void triggerUpdate() {
        this.invoke(runUpdate, null);
    }

    @Override
    public BOnyxxWallModule getMyDevice(BComponent c) {
        return BCanFSInterfaceValue.super.getMyDevice(c);
    }

    public void poll() {
        this.triggerUpdate();
    }
}

