/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.onyxxwallmodule.fileIO;

import com.lynxspring.onyxxwallmodule.service.BOnyxxWallModService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.sys.Sys;

public class OnyxxFileAccess {
    public static Log LOG = Log.getLog((String)Sys.getModuleForClass(BOnyxxWallModService.class).getModuleName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path, String fileName) throws Exception {
        String strFromFile = "";
        BufferedReader br = null;
        try {
            File file = new File(path, fileName);
            br = new BufferedReader(new FileReader(file));
            strFromFile = br.readLine().trim();
        }
        catch (IOException e) {
            LOG.log(3, "OnyxxFileAccess:readFile:" + path + "   " + fileName, null);
            throw e;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occurred during buffered reader close method for " + path + "/" + fileName, e);
            }
        }
        return strFromFile;
    }

    public static String writeFile(byte[] data, String path, String file, int sz) throws Exception {
        FileOutputStream fs = null;
        try {
            File valueFile = new File(path, file);
            fs = new FileOutputStream(valueFile);
            fs.write(data, 0, sz);
            fs.flush();
        }
        catch (IOException e) {
            LOG.log(2, "OnyxxFileAccess:writeFile1:" + file, (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occured during print writer close method for " + path + "/" + file, e);
            }
        }
        return "0";
    }

    public static String writeFile(String data, String path, String file) throws Exception {
        PrintWriter pw = null;
        try {
            File valueFile = new File(path, file);
            pw = new PrintWriter(new FileOutputStream(valueFile));
            pw.print(data);
            pw.flush();
        }
        catch (IOException e) {
            LOG.log(2, "OnyxxFileAccess:writeFile2:" + file, (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occured during print writer close method for " + path + "/" + file, e);
            }
        }
        return "0";
    }

    public static synchronized String FileIO(String path, String file, String data, boolean write) throws Exception {
        String returnValue = "";
        try {
            returnValue = write ? OnyxxFileAccess.writeFile(data, path, file) : OnyxxFileAccess.readFile(path, file);
        }
        catch (Exception e) {
            LOG.log(2, "OnyxxFileAccess:FileIO:" + path + "   " + file, null);
            throw e;
        }
        return returnValue;
    }

    public static String[] readTextFile(String path, String fileName, int maxLines) throws Exception {
        ArrayList<String> strFromFile = new ArrayList<String>();
        BufferedReader br = null;
        File file = null;
        String nxt = "";
        try {
            for (int i = 0; i < maxLines; ++i) {
                if (br == null) {
                    file = new File(path, fileName);
                    br = new BufferedReader(new FileReader(file));
                }
                if ((nxt = br.readLine()) != null && !(nxt = nxt.trim()).isEmpty()) {
                    strFromFile.add(nxt);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.log(2, "OnyxxFileAccess:readTextFile:" + fileName, (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                throw new Exception("Error occured during buffered reader close method for " + path + "/" + fileName, e);
            }
        }
        return strFromFile.toArray(new String[0]);
    }

    public static String[] getDevIds(String networkPath, int maxLines) {
        String[] dvids = null;
        try {
            dvids = OnyxxFileAccess.readTextFile(networkPath + "platform", "devids", maxLines);
        }
        catch (Exception e) {
            LOG.log(2, "OnyxxFileAccess:GetDevIds", null);
            e.printStackTrace();
        }
        return dvids;
    }

    public static void clearDevIds(String networkPath) {
        try {
            OnyxxFileAccess.FileIO(networkPath + "platform", "reset_device_list", " ", true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

