/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusAsync;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusAsync.BModbusAsyncDevice;
import com.tridium.modbusAsync.BModbusAsyncDeviceFolder;
import com.tridium.modbusAsync.comm.ModbusAsyncSerialComm;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.enums.BModbusDataModeEnum;
import com.tridium.modbusCore.messages.ModbusMessage;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="interMessageDelay", type="BRelTime", defaultValue="BRelTime.make(0)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND)")}), @NiagaraProperty(name="maxRxInterCharacterDelay", type="BRelTime", defaultValue="BRelTime.make(50)", flags=4, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND)")}), @NiagaraProperty(name="minRxFrameEnd", type="BRelTime", defaultValue="BRelTime.make(20)", flags=4, facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(0), BFacets.MAX, BRelTime.SECOND)")}), @NiagaraProperty(name="rxPriority", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="serialPortConfig", type="BSerialHelper", defaultValue="new BSerialHelper()"), @NiagaraProperty(name="modbusDataMode", type="BModbusDataModeEnum", defaultValue="BModbusDataModeEnum.rtu"), @NiagaraProperty(name="snifferMode", type="boolean", defaultValue="false"), @NiagaraProperty(name="rtuSnifferModeBufferSize", type="int", defaultValue="8", facets={@Facet(value="BFacets.makeInt(null, 1, Integer.MAX_VALUE)")})})
public class BModbusAsyncNetwork
extends BModbusClientNetwork
implements BISerialHelperParent {
    @Generated
    public static final Property interMessageDelay = BModbusAsyncNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property maxRxInterCharacterDelay = BModbusAsyncNetwork.newProperty((int)4, (BValue)BRelTime.make((long)50L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property minRxFrameEnd = BModbusAsyncNetwork.newProperty((int)4, (BValue)BRelTime.make((long)20L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property rxPriority = BModbusAsyncNetwork.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property serialPortConfig = BModbusAsyncNetwork.newProperty((int)0, (BValue)new BSerialHelper(), null);
    @Generated
    public static final Property modbusDataMode = BModbusAsyncNetwork.newProperty((int)0, (BValue)BModbusDataModeEnum.rtu, null);
    @Generated
    public static final Property snifferMode = BModbusAsyncNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property rtuSnifferModeBufferSize = BModbusAsyncNetwork.newProperty((int)0, (int)8, (BFacets)BFacets.makeInt(null, (int)1, (int)Integer.MAX_VALUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusAsyncNetwork.class);
    private Log log = null;
    private final Object logLock = new Object();
    private boolean commActive = false;
    private boolean networkInitialized = false;

    @Generated
    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    @Generated
    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    @Generated
    public BRelTime getMaxRxInterCharacterDelay() {
        return (BRelTime)this.get(maxRxInterCharacterDelay);
    }

    @Generated
    public void setMaxRxInterCharacterDelay(BRelTime v) {
        this.set(maxRxInterCharacterDelay, (BValue)v, null);
    }

    @Generated
    public BRelTime getMinRxFrameEnd() {
        return (BRelTime)this.get(minRxFrameEnd);
    }

    @Generated
    public void setMinRxFrameEnd(BRelTime v) {
        this.set(minRxFrameEnd, (BValue)v, null);
    }

    @Generated
    public boolean getRxPriority() {
        return this.getBoolean(rxPriority);
    }

    @Generated
    public void setRxPriority(boolean v) {
        this.setBoolean(rxPriority, v, null);
    }

    @Generated
    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    @Generated
    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    @Generated
    public BModbusDataModeEnum getModbusDataMode() {
        return (BModbusDataModeEnum)this.get(modbusDataMode);
    }

    @Generated
    public void setModbusDataMode(BModbusDataModeEnum v) {
        this.set(modbusDataMode, (BValue)v, null);
    }

    @Generated
    public boolean getSnifferMode() {
        return this.getBoolean(snifferMode);
    }

    @Generated
    public void setSnifferMode(boolean v) {
        this.setBoolean(snifferMode, v, null);
    }

    @Generated
    public int getRtuSnifferModeBufferSize() {
        return this.getInt(rtuSnifferModeBufferSize);
    }

    @Generated
    public void setRtuSnifferModeBufferSize(int v) {
        this.setInt(rtuSnifferModeBufferSize, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        Thread rxThread;
        Comm comm;
        super.changed(p, cx);
        if (this.isRunning() && p.equals(rxPriority) && (comm = this.getComm()) instanceof ModbusAsyncSerialComm && (rxThread = ((ModbusAsyncSerialComm)comm).getRxThread()) != null) {
            if (this.getRxPriority()) {
                rxThread.setPriority(7);
            } else {
                rxThread.setPriority(5);
            }
        }
    }

    public Type getDeviceType() {
        return BModbusAsyncDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BModbusAsyncDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "modbusAsync");
    }

    public BModbusAsyncNetwork() {
        this.setResponseTimeout(BRelTime.make((long)1000L));
    }

    public int getModbusMode() {
        return this.getModbusDataMode().getOrdinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.getNameSubscriber().subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Object object = this.logLock;
        synchronized (object) {
            this.log = this.getLog();
        }
    }

    public void startComm() throws Exception {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            this.configFail("No port selected for Modbus communication.");
        } else {
            try {
                super.startComm();
            }
            catch (Exception e) {
                this.configFail("Could not enable Modbus serial communication (" + e + ")");
                throw e;
            }
            this.configOk();
        }
        if (!(this.isDisabled() || this.isDown() || this.isFault())) {
            if (this.getModbusLog().isTraceOn()) {
                this.getModbusLog().trace("*** Starting serial comm for " + this.getName() + " ***");
            }
            if (!this.initializeNetwork()) {
                this.getModbusLog().warning("Unable to initialize network " + this.getName() + "!!");
            }
        }
    }

    public Log getLog() {
        String serialLogName = this.getName() + "_" + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)serialLogName)) {
            serialLogName = SlotPath.escape((String)serialLogName);
        }
        return Log.getLog((String)serialLogName);
    }

    protected Comm makeComm() {
        return new ModbusAsyncSerialComm(this);
    }

    public void stopComm() throws Exception {
        super.stopComm();
        this.commActive = false;
        this.networkInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLog() {
        String serialLogName = this.getName() + "_" + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)serialLogName)) {
            serialLogName = SlotPath.escape((String)serialLogName);
        }
        Log newLog = Log.getLog((String)serialLogName);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Object object = this.logLock;
        synchronized (object) {
            if (this.log != null) {
                newLog.setSeverity(this.log.getSeverity());
                if (!newLog.getLogName().equals(this.log.getLogName())) {
                    Log.deleteLog((String)this.log.getLogName());
                }
            }
            this.log = newLog;
        }
        super.updateLog();
    }

    public void reopenPort() {
        try {
            String newPort = this.getSerialPortConfig().getPortName();
            if (newPort.equals("none")) {
                this.configFail("No port selected for Modbus communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception e) {
            this.getLog().error("BModbusAsyncNetwork caught exception in reopenPort(): ", (Throwable)e);
        }
    }

    private void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log.isTraceOn()) {
                this.log.trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    private boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.commActive = true;
        if (!this.getComm().isCommStarted()) {
            this.getModbusLog().warning("Unable to start Serial Comm for " + this.getName());
            this.commActive = false;
            return false;
        }
        try {
            ((ModbusAsyncSerialComm)this.getComm()).getSerialPort().enableReceiveThreshold(1);
        }
        catch (UnsupportedOperationException e) {
            this.getModbusLog().error(this.getName() + ", ModbusAsyncSerialComm: Unable to perform enableReceiveThreshold = 1.  Exception- ", (Throwable)e);
        }
        this.networkInitialized = true;
        return true;
    }

    public boolean isCommActive() {
        return this.commActive && super.isCommActive();
    }

    public Message sendSync(Message msg, BRelTime responseTimeout, int retryCount) {
        if (this.getSnifferMode() || !this.isCommActive()) {
            return null;
        }
        Message response = super.sendSync(msg, responseTimeout, retryCount);
        try {
            BModbusClientDevice destDevice = this.findDeviceInNetwork(((ModbusMessage)msg).deviceAddress);
            if (destDevice != null) {
                if (response != null) {
                    destDevice.pingOk();
                    destDevice.resetPingsFailed();
                } else if (destDevice.incrementPingsFailed() > this.getMaxFailsUntilDeviceDown()) {
                    destDevice.pingFail(this.getLexicon().getText("pingFail"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    protected void processNameSubscriberEvent(BComponentEvent event) {
        super.processNameSubscriberEvent(event);
        try {
            if (event.getId() == 0 && event.getSlot().equals((Object)BSerialHelper.portName)) {
                this.updateLog();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

