/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.export.rpc;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.file.BExporter;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.Registry;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BExporterRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BExporterRpc.class);
    private static final Logger LOG = Logger.getLogger("com.tridium.file");
    private static BajaFileUtil.BajaFileWriter fileWriter = BajaFileUtil.getDefaultFileWriter();

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BExporterRpc() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONArray getExportersForType(String typeSpec, Context cx) {
        if (typeSpec == null || typeSpec.isEmpty()) {
            return new JSONArray();
        }
        Registry reg = Sys.getRegistry();
        return BExporterRpc.getExportersForAgents(reg.getAgents(reg.getType(typeSpec)), cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONArray getExportersForOrd(String ord, Context cx) {
        if (ord == null || ord.isEmpty()) {
            return new JSONArray();
        }
        try {
            BObject targetObj = BOrd.make((String)ord).get(null, cx);
            return BExporterRpc.getExportersForAgents(targetObj.getAgents(cx), cx);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get Exporters.", ex);
            return new JSONArray();
        }
    }

    private static JSONObject getExporterProps(String exporterTypeSpec) {
        JSONObject exporterProps = new JSONObject();
        try {
            BExporter exporter;
            BTypeSpec exporterSpec = BTypeSpec.make((String)exporterTypeSpec);
            if (!exporterSpec.equals((Object)BTypeSpec.NULL) && (exporter = (BExporter)exporterSpec.getInstance()) != null) {
                exporterProps.put("mimeType", (Object)exporter.getFileMimeType());
                exporterProps.put("fileExt", (Object)exporter.getFileExtension());
                String responseType = BExporterRpc.isBinaryMimeType(exporter.getFileMimeType()) ? "blob" : "text";
                exporterProps.put("responseType", (Object)responseType);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(exporterTypeSpec);
        }
        return exporterProps;
    }

    private static boolean isBinaryMimeType(String mimeType) {
        return "application/pdf".equals(mimeType);
    }

    private static JSONArray getExportersForAgents(AgentList expAgents, Context cx) {
        JSONArray exporters = new JSONArray();
        Arrays.stream(expAgents.filter(AgentFilter.is((String)"baja:Exporter")).list()).forEach(agent -> {
            JSONObject expInfo = new JSONObject();
            String agentTypeSpec = agent.getAgentType().getTypeSpec().toString();
            expInfo.put("typeSpec", (Object)agentTypeSpec);
            expInfo.put("displayName", (Object)agent.getDisplayName(cx));
            expInfo.put("icon", (Object)agent.getIcon(cx));
            expInfo.put("id", (Object)agent.getAgentId());
            try {
                expInfo.put("defaultConfig", (Object)BsonEncoderPlugin.marshal((BValue)((BExporter)agent.getInstance())));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Unable to marshal the exporter defaultConfig", ex);
            }
            expInfo.put("props", (Object)BExporterRpc.getExporterProps(agent.getAgentType().getTypeSpec().toString()));
            exporters.put((Object)expInfo);
        });
        return exporters;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static void exportToFile(String ordToExport, String ordToFile, String exporterTypeSpec, Map<String, String> params, Context cx) throws IOException {
        BObject viewInstance;
        AgentInfo info;
        BOrd fileOrd = BOrd.make((String)ordToFile);
        if (!fileWriter.isWritable(fileOrd, cx)) {
            throw new PermissionException("Not writable");
        }
        BExporter exporter = BExporterRpc.getExporterInstance(exporterTypeSpec);
        BOrd ord = BOrd.make((String)ordToExport);
        OrdTarget exportTarget = ord.resolve(null, cx);
        BObject result = exportTarget.get();
        ViewQuery viewQuery = exportTarget.getViewQuery();
        if (viewQuery != null && viewQuery.getViewId() != null && (info = result.getAgents(cx).get(viewQuery.getViewId())) != null && (viewInstance = info.getInstance()) instanceof BExporter) {
            exporter = (BExporter)viewInstance;
        }
        BExporterRpc.applyParams((BComplex)exporter, params, cx);
        try (InputStream in = exporter.transform(exportTarget, cx);){
            fileWriter.replaceFile(fileOrd, in, cx);
        }
    }

    private static BExporter getExporterInstance(String exporterTypeSpec) {
        BObject exporter = Sys.getRegistry().getType(exporterTypeSpec).getInstance();
        if (!(exporter instanceof BExporter)) {
            throw new IllegalArgumentException("Not a baja:Exporter subclass: " + exporterTypeSpec);
        }
        return (BExporter)exporter;
    }

    private static void applyParams(BComplex exporter, Map<String, String> params, Context cx) {
        params.forEach((key, value) -> {
            try {
                if (exporter.getSlot(key) != null) {
                    exporter.set(key, BsonDecoderPlugin.unmarshal((String)value, (Context)cx));
                }
            }
            catch (JSONException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

