/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.components;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCcnTime
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnTime.class);
    public static final int MIN_HOUR = 0;
    public static final int MAX_HOUR = 23;
    public static final int MIN_MINUTE = 0;
    public static final int MAX_MINUTE = 59;
    public static final int MIN_SECOND = 0;
    public static final int MAX_SECOND = 59;
    public static final int UNSPECIFIED = 255;
    protected int hour;
    protected int minute;
    protected int second;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnTime() {
    }

    public BCcnTime(int hour, int minute, int second) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        if (hour == 255) {
            this.hour = hour;
            return;
        }
        if (hour < 0) {
            while (hour < 0) {
                hour += 24;
            }
        } else if (hour > 23) {
            while (hour > 23) {
                hour -= 24;
            }
        }
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        if (minute == 255) {
            this.minute = minute;
            return;
        }
        if (minute < 0) {
            if (this.hour != 255) {
                int delta = minute / 60;
                if (minute % 60 != 0) {
                    --delta;
                }
                this.setHour(this.hour + delta);
            }
            while (minute < 0) {
                minute = 60 + minute;
            }
        } else if (minute > 59) {
            if (this.hour != 255) {
                this.setHour(this.hour + minute / 60);
            }
            minute %= 60;
        }
        this.minute = minute;
    }

    public int getMinuteOfDay() {
        if (this.hour == 255 || this.minute == 255) {
            throw new IllegalStateException("hour or minute UNSPECIFIED");
        }
        return this.hour * 60 + this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        if (second == 255) {
            this.second = second;
            return;
        }
        if (second < 0) {
            int delta;
            if (this.minute != 255) {
                delta = second / 60;
                if (second % 60 != 0) {
                    --delta;
                }
                this.setMinute(this.minute + delta);
            } else if (this.hour != 255) {
                delta = second / 3600;
                if (second % 3600 != 0) {
                    --delta;
                }
                this.setMinute(this.minute + delta);
            }
            while (second < 0) {
                second = 60 + second;
            }
        } else if (second > 59) {
            if (this.minute != 255) {
                this.setMinute(this.minute + second / 60);
            } else if (this.hour != 255) {
                this.setHour(this.hour + second / 3600);
            }
            second %= 60;
        }
        this.second = second;
    }
}

