/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.comm;

import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BBasicUnsolicitedReceive;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.comm.CcnUnsolicitedMsgWrapper;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnAsyncRequest;
import com.tridium.ccn.messages.CcnBroadcastDateTimeRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.util.CcnAlarmUtil;
import com.tridium.ccn.util.CcnRspDTUtil;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnUnsolMsgListener;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCcnUnsolicitedReceive
extends BBasicUnsolicitedReceive
implements CcnMessageConst,
CcnUnsolMsgListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnUnsolicitedReceive.class);
    private int errorCount = 0;
    private int ignoreCount = 0;
    private int alarmCount = 0;
    private int broadcastCount = 0;
    BCcnNetwork ccnNetwork;
    private static final Log ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnUnsolicitedReceive() {
    }

    public BCcnUnsolicitedReceive(BCcnNetwork newNetwork) {
        this.ccnNetwork = newNetwork;
    }

    public BCcnNetwork getNetwork() {
        if (this.ccnNetwork == null) {
            this.ccnNetwork = (BCcnNetwork)this.getParent();
        }
        return this.ccnNetwork;
    }

    public void callProcessUnsolicitedMessage(ReceivedMessage unsolicitedMsg) {
        this.processUnsolicitedMessage(unsolicitedMsg);
    }

    protected void processUnsolicitedMessage(ReceivedMessage unsolicitedMsg) {
        try {
            if (ccnNetworkLog.isTraceOn()) {
                ccnNetworkLog.trace("BCcnUnsolicitedReceive receieved unsolicitedMsg " + unsolicitedMsg);
            }
            if (!CcnUtil.isNetworkStatusOk(this.getNetwork())) {
                if (ccnNetworkLog.isTraceOn()) {
                    ccnNetworkLog.trace("BCcnUnsolicitedReceive network status unhealthy, ignoring unsolicitedMsg " + unsolicitedMsg);
                }
                return;
            }
            CcnUnsolicitedMsg ccnUnsolicitedMsg = ((CcnUnsolicitedMsgWrapper)unsolicitedMsg).getUnsolicitedMsg();
            if (ccnNetworkLog.isTraceOn()) {
                ccnNetworkLog.trace("BCcnUnsolicitedReceive handling ccnUnsolicitedMsg " + ccnUnsolicitedMsg);
            }
            if (this.isMessageFromAnotherElementAtMyAddress(ccnUnsolicitedMsg)) {
                ccnNetworkLog.error("CCN ADDRESS CONFLICT ADVISORY: Detected another controller at this devices's CCN address");
            }
            if (BCcnUnsolicitedReceive.isAlarmMessage(ccnUnsolicitedMsg)) {
                this.processAlarmMessage(ccnUnsolicitedMsg);
            } else if (BCcnUnsolicitedReceive.isBroadcastTimeRequest(ccnUnsolicitedMsg)) {
                this.processBroadcastTimeRequest(ccnUnsolicitedMsg);
            } else {
                this.ignoreMessage(ccnUnsolicitedMsg);
            }
        }
        catch (Exception e) {
            ++this.errorCount;
            ccnNetworkLog.error("Exception occurred processing unsolicitedMsg " + unsolicitedMsg, (Throwable)e);
        }
    }

    public void unsolicitedMessageReceived(CcnUnsolicitedMsg unsolMsg) {
        CcnUnsolicitedMsgWrapper ccnRcvdMsg = new CcnUnsolicitedMsgWrapper(unsolMsg);
        this.receiveMessage(ccnRcvdMsg);
    }

    private boolean isMessageFromAnotherElementAtMyAddress(CcnUnsolicitedMsg nextUnsolMsg) {
        return nextUnsolMsg.getSrcBus() == this.getNetwork().getBusAddress() && nextUnsolMsg.getSrcAddr() == this.getNetwork().getElemAddress();
    }

    private static boolean isAlarmMessage(CcnUnsolicitedMsg nextUnsolMsg) {
        return nextUnsolMsg.getCommand() == 30;
    }

    private static boolean isBroadcastTimeRequest(CcnUnsolicitedMsg nextUnsolMsg) throws CcnException {
        boolean properTable;
        boolean properCommand;
        boolean bl = properCommand = nextUnsolMsg.getCommand() == 12;
        boolean bl2 = properCommand ? CcnRspDTUtil.isWriteToBroadcastTableByName(nextUnsolMsg) || CcnRspDTUtil.isWriteToBroadcastTableByType_Inst(nextUnsolMsg) : (properTable = false);
        boolean properData = properTable ? nextUnsolMsg.getData()[nextUnsolMsg.getData().length - 1] == 3 : false;
        return properCommand && properTable && properData;
    }

    private void processBroadcastTimeRequest(CcnUnsolicitedMsg bcastDTMsg) throws CcnException {
        ++this.broadcastCount;
        if (!this.getNetwork().getBroadcastAcknowledger()) {
            if (ccnNetworkLog.isTraceOn()) {
                ccnNetworkLog.trace("BCcnUnsolicitedReceive detected broadcast time request but no action taken because local device not configured as time broadcaster");
            }
            return;
        }
        CcnAsyncRequest asyncRequest = this.getNetwork().getCcnComm().ccnAsyncRequest();
        asyncRequest.submitRequest(new CcnBroadcastDateTimeRequest(asyncRequest, true));
    }

    private void processAlarmMessage(CcnUnsolicitedMsg alarmMsg) throws CcnException {
        ++this.alarmCount;
        BCcnDevice d = this.findDeviceForAlarm(alarmMsg = BCcnUnsolicitedReceive.tweakUnsolAlarmMessage(alarmMsg));
        if (d != null) {
            BCcnUnsolicitedReceive.forwardCcnAlarmToCcnDevice(alarmMsg, d);
        } else {
            this.forwardCcnAlarmToNiagaraAlarmConsole(alarmMsg, d);
        }
    }

    private static CcnUnsolicitedMsg tweakUnsolAlarmMessage(CcnUnsolicitedMsg alarmMsg) {
        int OFFSET_DIFF_BETW_UNSOL_ALARM_MSG_AND_ALARM_HIST = 3;
        byte[] alarmData = alarmMsg.getData();
        byte[] tweakedAlarmData = new byte[alarmData.length + 3];
        int i = 0;
        int jump = 3;
        while (i < alarmData.length) {
            tweakedAlarmData[jump] = alarmData[i];
            ++i;
            ++jump;
        }
        CcnUnsolicitedMsg tweakedAlarmMsg = new CcnUnsolicitedMsg((byte)alarmMsg.getDestAddr(), (byte)alarmMsg.getDestBus(), (byte)alarmMsg.getSrcAddr(), (byte)alarmMsg.getSrcBus(), 0, 0, (byte)alarmMsg.getCommand(), tweakedAlarmData, (short)tweakedAlarmData.length);
        return tweakedAlarmMsg;
    }

    private BCcnDevice findDeviceForAlarm(CcnUnsolicitedMsg alarmMsg) {
        BCcnDevice[] devices = (BCcnDevice[])this.getNetwork().getChildren(BCcnDevice.class);
        for (int i = 0; i < devices.length; ++i) {
            BCcnDevice d = devices[i];
            if (!BCcnUnsolicitedReceive.isAlarmForDevice(alarmMsg, d)) continue;
            return d;
        }
        return null;
    }

    private static boolean isAlarmForDevice(CcnUnsolicitedMsg alarmMsg, BCcnDevice d) {
        return d != null && d.getElemNo() == alarmMsg.getSrcAddr() && d.getBusNo() == alarmMsg.getSrcBus();
    }

    private void ignoreMessage(CcnUnsolicitedMsg ignoreMsg) {
        ++this.ignoreCount;
        if (ccnNetworkLog.isTraceOn()) {
            ccnNetworkLog.trace("BCcnUnsolicitedReceive ignoring CcnUnsolicitedMsg " + ignoreMsg);
        }
    }

    private static void forwardCcnAlarmToCcnDevice(CcnUnsolicitedMsg alarmMsg, BCcnDevice d) throws CcnException {
        if (d != null) {
            d.unsolicitedAlarmReceived(alarmMsg);
        }
    }

    private void forwardCcnAlarmToNiagaraAlarmConsole(CcnUnsolicitedMsg alarmMsg, BCcnDevice ccnDevice) throws CcnException {
        boolean isDisplayMetric = this.getNetwork().getDisplayMetric();
        if (ccnDevice != null) {
            this.getNetwork().addAlarm(BString.make((String)CcnAlarmUtil.getAlarmConsoleSummary(alarmMsg, isDisplayMetric)), BString.make((String)(CcnAlarmUtil.getTypeDesc((CcnDataWrapper)alarmMsg) + " - " + CcnAlarmUtil.getSourceDesc((CcnDataWrapper)alarmMsg))), BString.make((String)CcnAlarmUtil.getFormattedValue((CcnDataWrapper)alarmMsg, false, isDisplayMetric)));
        }
    }
}

