/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnDeviceFolder;
import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.comm.BCcnUnsolicitedReceive;
import com.tridium.ccn.comm.CcnComm;
import com.tridium.ccn.comm.CcnCommReceiver;
import com.tridium.ccn.components.BCcnBridgesEntry;
import com.tridium.ccn.components.BCcnBridgesList;
import com.tridium.ccn.components.BCcnControllerList;
import com.tridium.ccn.enums.BCcnBaudRateEnum;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.job.BCcnAddDevicesJob;
import com.tridium.ccn.job.BCcnLearnDevicesJob;
import com.tridium.ccn.messages.CcnBroadcastDateTimeRequest;
import com.tridium.ccn.point.BCcnPointTuningPolicy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.tables.BCcnTableGroup;
import com.tridium.ccn.util.CcnRspDTUtil;
import com.tridium.platCcn.BCcnPlatformService;
import com.tridium.platCcn.CcnCommProps;
import com.tridium.platCcn.CcnUnsolMsgListener;
import com.tridium.util.PxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="debugOn", type="boolean", defaultValue="false"), @NiagaraProperty(name="clearBridgeList", type="boolean", defaultValue="false", flags=2), @NiagaraProperty(name="createTables", type="boolean", defaultValue="false"), @NiagaraProperty(name="autoCreatePoints", type="boolean", defaultValue="false"), @NiagaraProperty(name="bridges", type="BCcnBridgesList", defaultValue="new BCcnBridgesList()", flags=1), @NiagaraProperty(name="controllerList", type="BCcnControllerList", defaultValue="new BCcnControllerList()", flags=4), @NiagaraProperty(name="learnStatus", type="String", defaultValue="Idle", flags=3), @NiagaraProperty(name="firstBusNo", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0, 239)")}), @NiagaraProperty(name="lastBusNo", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0, 239)")}), @NiagaraProperty(name="lowElemNo", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(1, 239)")}), @NiagaraProperty(name="highElemNo", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(1, 239)")}), @NiagaraProperty(name="deviceLearnCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="displayMetric", type="boolean", defaultValue="false"), @NiagaraProperty(name="unsolicitedReceiveHandler", type="BCcnUnsolicitedReceive", defaultValue="new BCcnUnsolicitedReceive()"), @NiagaraProperty(name="retryCount", type="int", defaultValue="3", facets={@Facet(value="BFacets.makeInt(0, 24)")}, override=true), @NiagaraProperty(name="alarmAcknowledger", type="boolean", defaultValue="false"), @NiagaraProperty(name="broadcastAcknowledger", type="boolean", defaultValue="false"), @NiagaraProperty(name="timeSyncStat", type="String", defaultValue="Stopped", flags=1), @NiagaraProperty(name="timeBroadcaster", type="boolean", defaultValue="false"), @NiagaraProperty(name="timeSyncDisplayDots", type="boolean", defaultValue="false"), @NiagaraProperty(name="busAddress", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0, 239)")}), @NiagaraProperty(name="elemAddress", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(1, 239)")}), @NiagaraProperty(name="tunnelEnable", type="boolean", defaultValue="false"), @NiagaraProperty(name="tunnelHelper", type="BCcnTunnelHelper", defaultValue="new BCcnTunnelHelper()"), @NiagaraProperty(name="lowLevelDebug", type="boolean", defaultValue="false"), @NiagaraProperty(name="lowLevelDebugMask", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0))")}), @NiagaraProperty(name="commPort", type="String", defaultValue="COM2", flags=64), @NiagaraProperty(name="hostBaudRate", type="BCcnBaudRateEnum", defaultValue="BCcnBaudRateEnum.Baud9600"), @NiagaraProperty(name="learnedDevices", type="BFolder", defaultValue="new BFolder()", flags=7), @NiagaraProperty(name="isFullyLicensed", type="boolean", defaultValue="true", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="submitDeviceDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitAddDevicesJob", parameterType="BCcnControllerList", defaultValue="new BCcnControllerList()", returnType="BOrd", flags=4), @NiagaraAction(name="getStationSideComponents", returnType="BCcnNetwork", flags=4), @NiagaraAction(name="timeBroadCasting"), @NiagaraAction(name="periodicTimeBroadCasting", flags=4)})
public class BCcnNetwork
extends BBasicNetwork {
    @Generated
    public static final Property debugOn = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property clearBridgeList = BCcnNetwork.newProperty((int)2, (boolean)false, null);
    @Generated
    public static final Property createTables = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property autoCreatePoints = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property bridges = BCcnNetwork.newProperty((int)1, (BValue)new BCcnBridgesList(), null);
    @Generated
    public static final Property controllerList = BCcnNetwork.newProperty((int)4, (BValue)new BCcnControllerList(), null);
    @Generated
    public static final Property learnStatus = BCcnNetwork.newProperty((int)3, (String)"Idle", null);
    @Generated
    public static final Property firstBusNo = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)239));
    @Generated
    public static final Property lastBusNo = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)239));
    @Generated
    public static final Property lowElemNo = BCcnNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)239));
    @Generated
    public static final Property highElemNo = BCcnNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)239));
    @Generated
    public static final Property deviceLearnCount = BCcnNetwork.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property displayMetric = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property unsolicitedReceiveHandler = BCcnNetwork.newProperty((int)0, (BValue)new BCcnUnsolicitedReceive(), null);
    @Generated
    public static final Property retryCount = BCcnNetwork.newProperty((int)0, (int)3, (BFacets)BFacets.makeInt((int)0, (int)24));
    @Generated
    public static final Property alarmAcknowledger = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property broadcastAcknowledger = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property timeSyncStat = BCcnNetwork.newProperty((int)1, (String)"Stopped", null);
    @Generated
    public static final Property timeBroadcaster = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property timeSyncDisplayDots = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property busAddress = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)239));
    @Generated
    public static final Property elemAddress = BCcnNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)239));
    @Generated
    public static final Property tunnelEnable = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property tunnelHelper = BCcnNetwork.newProperty((int)0, (BValue)new BCcnTunnelHelper(), null);
    @Generated
    public static final Property lowLevelDebug = BCcnNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property lowLevelDebugMask = BCcnNetwork.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property commPort = BCcnNetwork.newProperty((int)64, (String)"COM2", null);
    @Generated
    public static final Property hostBaudRate = BCcnNetwork.newProperty((int)0, (BValue)BCcnBaudRateEnum.Baud9600, null);
    @Generated
    public static final Property learnedDevices = BCcnNetwork.newProperty((int)7, (BValue)new BFolder(), null);
    @Generated
    public static final Property isFullyLicensed = BCcnNetwork.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Action submitDeviceDiscoveryJob = BCcnNetwork.newAction((int)4, null);
    @Generated
    public static final Action submitAddDevicesJob = BCcnNetwork.newAction((int)4, (BValue)new BCcnControllerList(), null);
    @Generated
    public static final Action getStationSideComponents = BCcnNetwork.newAction((int)4, null);
    @Generated
    public static final Action timeBroadCasting = BCcnNetwork.newAction((int)0, null);
    @Generated
    public static final Action periodicTimeBroadCasting = BCcnNetwork.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnNetwork.class);
    public boolean driverStarted;
    public BCcnPlatformService ccnPlatSrvc;
    BCcnTable ccnTable;
    Vector<BCcnDevice> devs;
    BCcnUnsolicitedReceive unsolicitRx;
    boolean lowLevelDebugPending;
    boolean lowLevelDebugPendingValue;
    int lowLevelDebugPendingMask;
    Type networkType;
    private BAbsTime timeLastOneOclockCheck;
    private boolean abort;
    private boolean changingDisplay;
    private boolean discoveryInProgress;
    private Clock.Ticket ticket;
    private BAlarmService alarmServ;
    private static final BAbsTime oneAm = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.make((int)1, (int)0, (int)0, (int)0));
    private static final BAbsTime onePm = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.make((int)13, (int)0, (int)0, (int)0));
    private static final BIcon icon = BIcon.make((String)"module://ccn/images/CcnNetwork.png");
    private static final Log ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");

    @Generated
    public boolean getDebugOn() {
        return this.getBoolean(debugOn);
    }

    @Generated
    public void setDebugOn(boolean v) {
        this.setBoolean(debugOn, v, null);
    }

    @Generated
    public boolean getClearBridgeList() {
        return this.getBoolean(clearBridgeList);
    }

    @Generated
    public void setClearBridgeList(boolean v) {
        this.setBoolean(clearBridgeList, v, null);
    }

    @Generated
    public boolean getCreateTables() {
        return this.getBoolean(createTables);
    }

    @Generated
    public void setCreateTables(boolean v) {
        this.setBoolean(createTables, v, null);
    }

    @Generated
    public boolean getAutoCreatePoints() {
        return this.getBoolean(autoCreatePoints);
    }

    @Generated
    public void setAutoCreatePoints(boolean v) {
        this.setBoolean(autoCreatePoints, v, null);
    }

    @Generated
    public BCcnBridgesList getBridges() {
        return (BCcnBridgesList)this.get(bridges);
    }

    @Generated
    public void setBridges(BCcnBridgesList v) {
        this.set(bridges, (BValue)v, null);
    }

    @Generated
    public BCcnControllerList getControllerList() {
        return (BCcnControllerList)this.get(controllerList);
    }

    @Generated
    public void setControllerList(BCcnControllerList v) {
        this.set(controllerList, (BValue)v, null);
    }

    @Generated
    public String getLearnStatus() {
        return this.getString(learnStatus);
    }

    @Generated
    public void setLearnStatus(String v) {
        this.setString(learnStatus, v, null);
    }

    @Generated
    public int getFirstBusNo() {
        return this.getInt(firstBusNo);
    }

    @Generated
    public void setFirstBusNo(int v) {
        this.setInt(firstBusNo, v, null);
    }

    @Generated
    public int getLastBusNo() {
        return this.getInt(lastBusNo);
    }

    @Generated
    public void setLastBusNo(int v) {
        this.setInt(lastBusNo, v, null);
    }

    @Generated
    public int getLowElemNo() {
        return this.getInt(lowElemNo);
    }

    @Generated
    public void setLowElemNo(int v) {
        this.setInt(lowElemNo, v, null);
    }

    @Generated
    public int getHighElemNo() {
        return this.getInt(highElemNo);
    }

    @Generated
    public void setHighElemNo(int v) {
        this.setInt(highElemNo, v, null);
    }

    @Generated
    public int getDeviceLearnCount() {
        return this.getInt(deviceLearnCount);
    }

    @Generated
    public void setDeviceLearnCount(int v) {
        this.setInt(deviceLearnCount, v, null);
    }

    @Generated
    public boolean getDisplayMetric() {
        return this.getBoolean(displayMetric);
    }

    @Generated
    public void setDisplayMetric(boolean v) {
        this.setBoolean(displayMetric, v, null);
    }

    @Generated
    public BCcnUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BCcnUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    @Generated
    public void setUnsolicitedReceiveHandler(BCcnUnsolicitedReceive v) {
        this.set(unsolicitedReceiveHandler, (BValue)v, null);
    }

    @Generated
    public boolean getAlarmAcknowledger() {
        return this.getBoolean(alarmAcknowledger);
    }

    @Generated
    public void setAlarmAcknowledger(boolean v) {
        this.setBoolean(alarmAcknowledger, v, null);
    }

    @Generated
    public boolean getBroadcastAcknowledger() {
        return this.getBoolean(broadcastAcknowledger);
    }

    @Generated
    public void setBroadcastAcknowledger(boolean v) {
        this.setBoolean(broadcastAcknowledger, v, null);
    }

    @Generated
    public String getTimeSyncStat() {
        return this.getString(timeSyncStat);
    }

    @Generated
    public void setTimeSyncStat(String v) {
        this.setString(timeSyncStat, v, null);
    }

    @Generated
    public boolean getTimeBroadcaster() {
        return this.getBoolean(timeBroadcaster);
    }

    @Generated
    public void setTimeBroadcaster(boolean v) {
        this.setBoolean(timeBroadcaster, v, null);
    }

    @Generated
    public boolean getTimeSyncDisplayDots() {
        return this.getBoolean(timeSyncDisplayDots);
    }

    @Generated
    public void setTimeSyncDisplayDots(boolean v) {
        this.setBoolean(timeSyncDisplayDots, v, null);
    }

    @Generated
    public int getBusAddress() {
        return this.getInt(busAddress);
    }

    @Generated
    public void setBusAddress(int v) {
        this.setInt(busAddress, v, null);
    }

    @Generated
    public int getElemAddress() {
        return this.getInt(elemAddress);
    }

    @Generated
    public void setElemAddress(int v) {
        this.setInt(elemAddress, v, null);
    }

    @Generated
    public boolean getTunnelEnable() {
        return this.getBoolean(tunnelEnable);
    }

    @Generated
    public void setTunnelEnable(boolean v) {
        this.setBoolean(tunnelEnable, v, null);
    }

    @Generated
    public BCcnTunnelHelper getTunnelHelper() {
        return (BCcnTunnelHelper)this.get(tunnelHelper);
    }

    @Generated
    public void setTunnelHelper(BCcnTunnelHelper v) {
        this.set(tunnelHelper, (BValue)v, null);
    }

    @Generated
    public boolean getLowLevelDebug() {
        return this.getBoolean(lowLevelDebug);
    }

    @Generated
    public void setLowLevelDebug(boolean v) {
        this.setBoolean(lowLevelDebug, v, null);
    }

    @Generated
    public int getLowLevelDebugMask() {
        return this.getInt(lowLevelDebugMask);
    }

    @Generated
    public void setLowLevelDebugMask(int v) {
        this.setInt(lowLevelDebugMask, v, null);
    }

    @Generated
    public String getCommPort() {
        return this.getString(commPort);
    }

    @Generated
    public void setCommPort(String v) {
        this.setString(commPort, v, null);
    }

    @Generated
    public BCcnBaudRateEnum getHostBaudRate() {
        return (BCcnBaudRateEnum)this.get(hostBaudRate);
    }

    @Generated
    public void setHostBaudRate(BCcnBaudRateEnum v) {
        this.set(hostBaudRate, (BValue)v, null);
    }

    @Generated
    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    @Generated
    public void setLearnedDevices(BFolder v) {
        this.set(learnedDevices, (BValue)v, null);
    }

    @Generated
    public boolean getIsFullyLicensed() {
        return this.getBoolean(isFullyLicensed);
    }

    @Generated
    public void setIsFullyLicensed(boolean v) {
        this.setBoolean(isFullyLicensed, v, null);
    }

    @Generated
    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    @Generated
    public BOrd submitAddDevicesJob(BCcnControllerList parameter) {
        return (BOrd)this.invoke(submitAddDevicesJob, (BValue)parameter, null);
    }

    @Generated
    public BCcnNetwork getStationSideComponents() {
        return (BCcnNetwork)this.invoke(getStationSideComponents, null, null);
    }

    @Generated
    public void timeBroadCasting() {
        this.invoke(timeBroadCasting, null, null);
    }

    @Generated
    public void periodicTimeBroadCasting() {
        this.invoke(periodicTimeBroadCasting, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BCcnDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BCcnDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        try {
            if (Sys.getLicenseManager().getFeature("tridium", "ccn").getFeatureName().equalsIgnoreCase("ccn")) {
                this.setIsFullyLicensed(true);
            }
            return Sys.getLicenseManager().getFeature("tridium", "ccn");
        }
        catch (FeatureNotLicensedException exp) {
            if (Sys.getLicenseManager().getFeature("tridium", "ccnl").getFeatureName().equalsIgnoreCase("ccnl")) {
                this.setIsFullyLicensed(false);
                return Sys.getLicenseManager().getFeature("tridium", "ccnl");
            }
            throw exp;
        }
    }

    public void pingOk() {
        super.pingOk();
        BCcnDevice[] devices = (BCcnDevice[])this.getChildren(BCcnDevice.class);
        if (devices != null && devices.length > 0) {
            for (int i = 0; i < devices.length; ++i) {
                devices[i].doPing();
            }
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        TypeInfo propertySheet = Sys.getRegistry().getType("workbench:PropertySheet");
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(propertySheet)) continue;
            agents.remove(i);
            break;
        }
        TypeInfo deviceManager = Sys.getRegistry().getType("ccn:CcnDeviceManager");
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(deviceManager)) continue;
            agents.toTop(i);
            break;
        }
        return PxUtil.movePxViewsToTop((AgentList)agents);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void started() throws Exception {
        super.started();
        this.networkType = Sys.loadType(BCcnNetwork.class);
        if (Sys.getService((Type)this.networkType) != this) {
            this.configFail("Duplicate CCN network");
            throw new IllegalStateException("Only one CCN Network allowed per station.");
        }
        boolean ccnTuningFound = false;
        BTuningPolicy[] policies = this.getTuningPolicies().getPolicies();
        if (policies != null && policies.length > 0) {
            for (int i = 0; i < policies.length; ++i) {
                if (!policies[i].getName().equalsIgnoreCase("BCcnPointTuningPolicy")) continue;
                ccnTuningFound = true;
                break;
            }
        }
        if (!ccnTuningFound) {
            this.getTuningPolicies().add("BCcnPointTuningPolicy", (BValue)new BCcnPointTuningPolicy());
        }
        this.unsolicitRx = this.getUnsolicitedReceiveHandler();
        this.ccnPlatSrvc = (BCcnPlatformService)Sys.getService((Type)BCcnPlatformService.TYPE);
        CcnCommProps commProps = new CcnCommProps(this.getCommPort(), (long)this.getHostBaudRate().getOrdinal(), (byte)this.getElemAddress(), (byte)this.getBusAddress(), (short)this.getResponseTimeout().getMillis(), this.getAlarmAcknowledger(), this.getBroadcastAcknowledger());
        this.ccnPlatSrvc.registerUnsolMsgListener((CcnUnsolMsgListener)this.unsolicitRx);
        this.ccnPlatSrvc.openDriverComm(commProps);
        this.driverStarted = true;
        if (this.getTimeBroadcaster()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)180000L), (Action)periodicTimeBroadCasting, null);
        }
        if (this.getTunnelEnable()) {
            this.getTunnelHelper().tunnelStart(this);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.driverStarted) {
            this.driverStarted = false;
            this.getTunnelHelper().tunnelStop();
            this.ccnPlatSrvc.closeDriver();
        }
    }

    public void changed(Property changedProperty, Context cx) {
        super.changed(changedProperty, cx);
        if (!this.isRunning()) {
            return;
        }
        if (changedProperty.getName().equalsIgnoreCase("displaymetric")) {
            this.changingDisplay = true;
            this.updateTables((BComponent)this, ((BBoolean)this.get("displayMetric")).getBoolean());
            this.changingDisplay = false;
        }
        if (changedProperty.getName().equalsIgnoreCase("timeBroadcaster")) {
            this.toggleTimeBroadcaster();
        } else if (changedProperty.getName().equalsIgnoreCase("hostBaudRate") || changedProperty.getName().equalsIgnoreCase("elemAddress") || changedProperty.getName().equalsIgnoreCase("busAddress") || changedProperty.getName().equalsIgnoreCase("responseTimeout") || changedProperty.getName().equalsIgnoreCase("alarmAcknowledger") || changedProperty.getName().equalsIgnoreCase("broadcastAcknowledger")) {
            this.ccnPlatSrvc.changeExtendedParams(this.getHostBaudRate().getOrdinal(), (byte)this.getElemAddress(), (byte)this.getBusAddress(), (short)this.getResponseTimeout().getMillis(), this.isAlarmAck(), this.isBcastAck());
            BCcnDevice[] ccndevices = (BCcnDevice[])this.getChildren(BCcnDevice.class);
            for (int i = 0; i < ccndevices.length; ++i) {
                ccndevices[i].doPing();
            }
        } else if (changedProperty.getName().equalsIgnoreCase("lowLevelDebug") || changedProperty.getName().equalsIgnoreCase("lowLevelDebugMask")) {
            this.ccnPlatSrvc.setLowLevelDebug(((BBoolean)this.get("lowLevelDebug")).getBoolean(), this.getLowLevelDebugMask());
        } else if (changedProperty.getName().equalsIgnoreCase("commPort")) {
            this.ccnPlatSrvc.closeDriver();
            CcnCommProps commProps = new CcnCommProps(this.getCommPort(), (long)this.getHostBaudRate().getOrdinal(), (byte)this.getElemAddress(), (byte)this.getBusAddress(), (short)this.getResponseTimeout().getMillis(), this.getAlarmAcknowledger(), this.getBroadcastAcknowledger());
            this.ccnPlatSrvc.openDriverComm(commProps);
            BCcnDevice[] ccndevices = (BCcnDevice[])this.getChildren(BCcnDevice.class);
            for (int i = 0; i < ccndevices.length; ++i) {
                ccndevices[i].doPing();
            }
        } else if (changedProperty.getName().equalsIgnoreCase("tunnelEnable")) {
            if (this.getTunnelEnable() && this.isCommActive()) {
                this.getTunnelHelper().tunnelStart(this);
            } else {
                this.getTunnelHelper().tunnelStop();
            }
        }
    }

    protected Comm makeComm() {
        return new CcnComm(this, new CcnCommReceiver());
    }

    public CcnComm getCcnComm() {
        return (CcnComm)this.getComm();
    }

    public boolean isParentLegal(BComponent parent) throws LocalizableRuntimeException {
        super.isParentLegal(parent);
        if (!(parent instanceof BDriverContainer)) {
            throw new LocalizableRuntimeException("ccn", "CcnNetwork.Drop");
        }
        return true;
    }

    public boolean isChildLegal(BComponent child) throws LocalizableRuntimeException {
        if (child instanceof BCcnNetwork) {
            throw new LocalizableRuntimeException("ccn", "CcnNetwork.ChildDrop");
        }
        return true;
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        BCcnLearnDevicesJob job = new BCcnLearnDevicesJob(this);
        return job.submit(null);
    }

    public BCcnNetwork doGetStationSideComponents() {
        return this;
    }

    public BOrd doSubmitAddDevicesJob(BCcnControllerList controllerList) {
        BCcnAddDevicesJob job = new BCcnAddDevicesJob(this, controllerList);
        return job.submit(null);
    }

    public void doTimeBroadCasting() {
        this.getCcnComm().ccnAsyncRequest().submitRequest(new CcnBroadcastDateTimeRequest(this.getCcnComm().ccnAsyncRequest(), true));
    }

    public void doPeriodicTimeBroadCasting() {
        try {
            this.checkOneOclockTimeBroadCast();
        }
        catch (Exception ie) {
            ccnNetworkLog.warning("Exception occurred during time broadcast check", (Throwable)ie);
        }
        this.setTimeSyncStat("Running");
    }

    public final void updateTables(BComponent network, boolean displayMetric) {
        ArrayList<BCcnTable> childNodes = this.getCcnTables();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.size(); ++i) {
                BCcnProxyExt[] createdPoints;
                this.ccnTable = childNodes.get(i);
                if (this.ccnTable instanceof BCcnDataTable) {
                    this.changingDisplay = true;
                    BCcnDataTable ccnDataTable = (BCcnDataTable)childNodes.get(i);
                    ccnDataTable.setPreMetricDisplay(this.ccnTable.getCurMetricDisplay());
                    ccnDataTable.setCurMetricDisplay(displayMetric);
                    createdPoints = ccnDataTable.getCreatedPoints();
                    if (ccnDataTable.getPointCreateCount() == 0 || createdPoints == null || createdPoints.length == 0) continue;
                    ccnDataTable.changePointsDisplay(createdPoints);
                    this.changingDisplay = false;
                }
                if (this.ccnTable instanceof BCcnPicTable) {
                    this.changingDisplay = true;
                    BCcnPicTable picTable = (BCcnPicTable)childNodes.get(i);
                    picTable.setPreMetricDisplay(this.ccnTable.getCurMetricDisplay());
                    picTable.setCurMetricDisplay(displayMetric);
                    createdPoints = picTable.getCreatedPoints();
                    if (picTable.getPointCreateCount() == 0 || createdPoints == null || createdPoints.length == 0) continue;
                    picTable.changePointsDisplay(createdPoints);
                    this.changingDisplay = false;
                }
                if (!(this.ccnTable instanceof BCcnFidTable)) continue;
                this.changingDisplay = true;
                BCcnFidTable fidTable = (BCcnFidTable)childNodes.get(i);
                fidTable.setPreMetricDisplay(this.ccnTable.getCurMetricDisplay());
                fidTable.setCurMetricDisplay(displayMetric);
                createdPoints = fidTable.getCreatedPoints();
                if (fidTable.getPointCreateCount() == 0 || createdPoints == null || createdPoints.length == 0) continue;
                fidTable.changePointsDisplay(createdPoints);
                this.changingDisplay = false;
            }
        }
    }

    public ArrayList<BCcnTable> getCcnTables() {
        ArrayList<BCcnTable> ccnTables = new ArrayList<BCcnTable>();
        BCcnDevice[] ccnDevices = (BCcnDevice[])this.getChildren(BCcnDevice.class);
        if (ccnDevices != null) {
            for (int i = 0; i < ccnDevices.length; ++i) {
                BCcnTableGroup[] tableGroups = (BCcnTableGroup[])ccnDevices[i].getPoints().getChildren(BCcnTableGroup.class);
                if (tableGroups == null) continue;
                for (int j = 0; j < tableGroups.length; ++j) {
                    BCcnTable[] tables = (BCcnTable[])tableGroups[j].getChildren(BCcnTable.class);
                    if (tables == null) continue;
                    for (int k = 0; k < tables.length; ++k) {
                        BCcnDataTable[] dataTables;
                        if (tables[k] instanceof BCcnPocTable && (dataTables = (BCcnDataTable[])tables[k].getChildren(BCcnDataTable.class)) != null) {
                            for (int dt = 0; dt < dataTables.length; ++dt) {
                                ccnTables.add(dataTables[dt]);
                            }
                        }
                        ccnTables.add(tables[k]);
                    }
                }
            }
        }
        return ccnTables;
    }

    public void setLowLevelDebug(boolean bHow, int mask) {
        if (this.driverStarted) {
            this.lowLevelDebugPending = false;
            this.ccnPlatSrvc.setLowLevelDebug(bHow, mask);
        } else {
            this.lowLevelDebugPending = true;
            this.lowLevelDebugPendingValue = bHow;
            this.lowLevelDebugPendingMask = mask;
        }
    }

    private void toggleTimeBroadcaster() {
        if (this.isTimeBroadCaster()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)180000L), (Action)periodicTimeBroadCasting, null);
            this.setTimeSyncStat("Running");
        } else {
            if (this.ticket != null) {
                this.ticket.cancel();
                this.ticket = null;
            }
            this.setTimeSyncStat("Stopped");
        }
    }

    public boolean isTimeBroadCaster() {
        return ((BBoolean)this.get("timeBroadcaster")).getBoolean();
    }

    public boolean isBcastAck() {
        return ((BBoolean)this.get("broadcastAcknowledger")).getBoolean();
    }

    public boolean isAlarmAck() {
        return ((BBoolean)this.get("alarmAcknowledger")).getBoolean();
    }

    public boolean isDiscoveryInProgress() {
        if (!this.discoveryInProgress) {
            return false;
        }
        this.discoveryInProgress = false;
        return true;
    }

    public void setDiscoveryInProgress(boolean dip) {
        this.discoveryInProgress = dip;
    }

    public Vector<BCcnDevice> getCcnDevices() {
        this.devs = new Vector(50);
        BCcnNetwork.getDevices((BComponent)this, this.devs);
        return this.devs;
    }

    public static void getDevices(BComponent objComp, Vector<BCcnDevice> devs) {
        if (objComp == null) {
            return;
        }
        devs.removeAllElements();
        BComponent[] childrenHandles = objComp.getChildComponents();
        if (childrenHandles == null || childrenHandles.length < 1) {
            return;
        }
        for (int i = 0; i < childrenHandles.length; ++i) {
            if (childrenHandles[i] instanceof BCcnDevice) {
                devs.addElement((BCcnDevice)childrenHandles[i]);
                continue;
            }
            BCcnNetwork.getDevices(childrenHandles[i], devs);
        }
    }

    public boolean isBridge(int address) {
        if (address == 0) {
            return false;
        }
        BCcnBridgesEntry[] bridges = (BCcnBridgesEntry[])this.getBridges().getChildren(BCcnBridgesEntry.class);
        if (bridges == null) {
            return false;
        }
        if (address != 0) {
            for (int bc = 0; bc < bridges.length; ++bc) {
                if (bridges[bc].getBridgeBus() != address) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public boolean isChangingDisplay() {
        return this.changingDisplay;
    }

    public BCcnDevice findCcnDevice(BComponent ccnNetwork) {
        BComponent[] childrenHandles = this.getChildComponents();
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (!(nextChild instanceof BCcnDevice)) continue;
            BCcnDevice dev = (BCcnDevice)nextChild;
            return dev;
        }
        return null;
    }

    public void changeExtendedSettings(int baudRate, byte rxAddr, byte rxBus, short rxTimeOut, boolean alarmAck, boolean broadcastAck) {
        String o = null;
        int ccnCode = 0;
        if (this.driverStarted) {
            int retCode = this.ccnPlatSrvc.changeExtendedParams(baudRate, rxAddr, rxBus, rxTimeOut, alarmAck, broadcastAck);
            if (retCode == 0) {
                return;
            }
            ccnCode = BCcnNetwork.convertChangeExtendedSettingReturnValToCcnErrorCode(retCode);
            o = "Unable to change native settings. Native return code = " + retCode;
        } else {
            o = "Cannot change extended settings because the native driver has not yet been started.";
        }
        throw new CcnRuntimeException(ccnCode, o);
    }

    private static int convertChangeExtendedSettingReturnValToCcnErrorCode(int retCode) {
        if (retCode == -4) {
            return 6488272;
        }
        if (retCode == -5) {
            return 6488271;
        }
        return 6488273;
    }

    public void checkOneOclockTimeBroadCast() {
        BAbsTime timeNow = BAbsTime.now();
        if (this.timeLastOneOclockCheck != null && (CcnRspDTUtil.timeJustPassed(oneAm, this.timeLastOneOclockCheck, timeNow) || CcnRspDTUtil.timeJustPassed(onePm, this.timeLastOneOclockCheck, timeNow))) {
            this.getCcnComm().ccnAsyncRequest().submitRequest(new CcnBroadcastDateTimeRequest(this.getCcnComm().ccnAsyncRequest(), true));
        }
        this.timeLastOneOclockCheck = timeNow;
    }

    public boolean isNetworkStatusOk() {
        return !this.isDown() && !this.isDisabled() && !this.isFatalFault();
    }

    public void addAlarm(BString alarmText, BString alarmType, BString alarmValue) {
        try {
            if (this.alarmServ == null) {
                this.alarmServ = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            }
            BFacets niagaraAlarmFacets = BFacets.make(BCcnNetwork.ccnHashMap(alarmText, alarmType, alarmValue));
            BAlarmRecord rec = new BAlarmRecord(BUuid.make());
            rec.setSource(BOrdList.make((BOrd)this.getAlarmSourceInfo().getNavOrd()));
            rec.setAlarmClass(this.getAlarmSourceInfo().getAlarmClass());
            rec.setAlarmData(niagaraAlarmFacets);
            this.alarmServ.routeAlarm(rec);
        }
        catch (Exception e) {
            ccnNetworkLog.error("Exception occurred when adding Alarm", (Throwable)e);
        }
    }

    private static HashMap<String, BString> ccnHashMap(BString alarmText, BString alarmType, BString alarmValue) {
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmText", alarmText);
        map.put("alarmType", alarmType);
        map.put("alarmValue", alarmValue);
        return map;
    }
}

