/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.event.enableEvents;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.event.enableEvents.AxisParameterUtil;

public class EventActionUtil {
    protected BAxisVideoCamera avCamera;
    protected String actionMessage;
    protected String shortEventServerId;

    public EventActionUtil(BAxisVideoCamera avCamera, String actionMessage, String eventServerId) {
        this.avCamera = avCamera;
        actionMessage = actionMessage.replaceAll("[^\\w\\d\\s]", "_");
        this.actionMessage = actionMessage = actionMessage.replaceAll("\\s+", " ");
        this.shortEventServerId = eventServerId.substring(eventServerId.lastIndexOf(46) + 1);
    }

    public String getActionId() throws AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToUpdateParameterException, AxisParameterUtil.UnableToAddGroupException {
        try {
            String eventActionMessageKey = AxisParameterUtil.queryGroup(this.avCamera, "Event.*.Actions.*.Message", this.actionMessage);
            String actionEventServerKey = eventActionMessageKey.substring(0, eventActionMessageKey.lastIndexOf(46));
            AxisParameterUtil.updateParameter(this.avCamera, actionEventServerKey + ".Server", this.shortEventServerId);
            int dotAfterENbr = eventActionMessageKey.indexOf(".", 11);
            return eventActionMessageKey.substring(5, dotAfterENbr);
        }
        catch (AxisParameterUtil.ParameterNotFoundException e) {
            String shortEventTypeId = AxisParameterUtil.addParameterGroup(this.avCamera, "Event&template=event&Event.E.Name=" + this.actionMessage + "&Event.E.Priority=2");
            String eventTypeId = "Event." + shortEventTypeId;
            AxisParameterUtil.addParameterGroup(this.avCamera, eventTypeId + ".Actions&template=tcpaction&" + eventTypeId + ".Actions.A.Server=" + this.shortEventServerId + '&' + eventTypeId + ".Actions.A.Message=" + this.actionMessage);
            return eventTypeId;
        }
    }
}

