/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.event.enableEvents;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.naxisVideo.messages.AxisGetSupportedEventInstancesRequest;
import com.tridium.naxisVideo.messages.AxisReadFirmwareVersionRequest;
import com.tridium.naxisVideo.messages.AxisSubscribeVideoMotionDetectionRequest;
import com.tridium.naxisVideo.util.BAxisUserNameAndPassword;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtpStream;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.util.Lexicon;

public class AxisSubscribeVideoMotionDetection {
    private static final Logger axisLog = Logger.getLogger("NAxisVideo");
    public static final Lexicon LEX = Lexicon.make(AxisSubscribeVideoMotionDetection.class);

    private AxisSubscribeVideoMotionDetection() {
    }

    public static boolean isVmdSupportedByCamera(BAxisVideoCamera axisVideoCamera) {
        try {
            axisLog.log(Level.FINE, "Start to check whether VMD is supported by the camera or not...");
            BIpAddress ipAddress = new BIpAddress(((BAxisVideoCameraDeviceId)axisVideoCamera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)axisVideoCamera.getVideoDeviceId()).getWebPort());
            AxisReadFirmwareVersionRequest readFirmwareVersionRequest = new AxisReadFirmwareVersionRequest(ipAddress);
            AxisSubscribeVideoMotionDetection.updateHttpRequest(axisVideoCamera, readFirmwareVersionRequest);
            byte[] rsp = axisVideoCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)readFirmwareVersionRequest).getData();
            boolean isSupported = AxisSubscribeVideoMotionDetection.processFirmwareVersionNumber(new String(rsp));
            axisVideoCamera.setVmdSupported(isSupported);
            return isSupported;
        }
        catch (Exception e) {
            axisLog.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private static void updateHttpRequest(BAxisVideoCamera axisVideoCamera, NHttpRequest request) {
        String passKey = axisVideoCamera.getUpdatedVideoKey();
        BAxisUserNameAndPassword usernameAndPassword = new BAxisUserNameAndPassword();
        usernameAndPassword.setUsername(axisVideoCamera.getCredentials().getUsername());
        usernameAndPassword.setPassword(BPassword.make((String)passKey));
        request.setUsernamePassword((BUsernameAndPassword)usernameAndPassword);
        request.addBasicAuthorization(axisVideoCamera.getCredentials().getUsername(), passKey);
        request.setRetryCount(0);
        request.setResponseTimeOut(20000);
    }

    public static boolean processFirmwareVersionNumber(String response) throws InvalidResponseException {
        String version = response.substring(response.indexOf(61) + 1);
        StringTokenizer st = new StringTokenizer(version, ".");
        if (st.countTokens() >= 2) {
            String major = st.nextToken();
            int mj = Integer.parseInt(major.trim());
            return mj > 5 ? true : AxisSubscribeVideoMotionDetection.checkOlderFirmwareVersion(st, mj);
        }
        throw new InvalidResponseException(LEX.getText("improperFirmwareVersion") + response);
    }

    private static boolean checkOlderFirmwareVersion(StringTokenizer st, int mj) {
        return mj < 5 ? false : AxisSubscribeVideoMotionDetection.checkMinorVersion(Integer.parseInt(st.nextToken().trim()));
    }

    private static boolean checkMinorVersion(int i) {
        return i >= 60;
    }

    public static List<String> getSupportedEventsOnAxisCamera(BAxisVideoCamera avCamera) {
        axisLog.log(Level.FINE, "Start to get supported Events on Axis camera...");
        BIpAddress ipAddress = new BIpAddress(((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getWebPort());
        AxisGetSupportedEventInstancesRequest getSupportedEventInstancesRequest = new AxisGetSupportedEventInstancesRequest(ipAddress);
        AxisSubscribeVideoMotionDetection.updateHttpRequest(avCamera, getSupportedEventInstancesRequest);
        byte[] rsp = null;
        try {
            getSupportedEventInstancesRequest.setBody();
            rsp = avCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)getSupportedEventInstancesRequest).getData();
            String childrenOfCameraApplicationPlatformTag = AxisSubscribeVideoMotionDetection.processResponseOnSupportedEventTopics(rsp, "tnsaxis:CameraApplicationPlatform", "/tnsaxis:CameraApplicationPlatform");
            String childrenOfVmdTag = AxisSubscribeVideoMotionDetection.processResponseOnSupportedEventTopics(childrenOfCameraApplicationPlatformTag.getBytes(), "VMD", "/VMD");
            return AxisSubscribeVideoMotionDetection.processCameraApplicationPlatformTags(childrenOfVmdTag, "axis:CameraApplicationPlatform/VMD");
        }
        catch (Exception e) {
            axisLog.log(Level.SEVERE, e.getMessage(), e);
            return new ArrayList<String>();
        }
    }

    public static String processResponseOnSupportedEventTopics(byte[] rsp, String startTag, String endTag) throws InvalidResponseException {
        if (rsp == null) {
            throw new InvalidResponseException(LEX.getText("noResponseOnSupportedTopics"));
        }
        StringBuilder sb = AxisSubscribeVideoMotionDetection.addNewLineAtEnd(rsp);
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        sb.delete(0, sb.length());
        boolean foundStartingTag = false;
        while (st.hasMoreTokens()) {
            String currSt = st.nextToken();
            if (!currSt.contains(startTag) && !foundStartingTag) continue;
            foundStartingTag = true;
            sb.append(currSt + "\n");
            if (!currSt.contains(endTag)) continue;
            return sb.toString();
        }
        throw new InvalidResponseException(LEX.getText("responseDoesNotHavingProperTags"));
    }

    private static StringBuilder addNewLineAtEnd(byte[] rsp) {
        StringBuilder sb = new StringBuilder();
        for (byte b : rsp) {
            sb.append((char)b);
            if (!Character.valueOf((char)b).equals(Character.valueOf('>'))) continue;
            sb.append("\n");
        }
        return sb;
    }

    public static List<String> processCameraApplicationPlatformTags(String s, String prefixString) throws NoEventTopicsDefinedException {
        StringTokenizer st = new StringTokenizer(s, "\n");
        ArrayList<String> topicStrings = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String processString = st.nextToken();
            if (!processString.contains("wstop:topic=\"true\"")) continue;
            int index = processString.indexOf(32);
            String targetString = processString.substring(1, index).trim();
            topicStrings.add(prefixString + "/" + targetString);
        }
        if (topicStrings.stream().count() > 0L) {
            return topicStrings;
        }
        throw new NoEventTopicsDefinedException(LEX.getText("noEventTopicsDefined") + s);
    }

    public static String queryStringForEventTopicsToSubscribe(List<String> eventTopicsToSubscribe) throws NoEventTopicsDefinedException {
        StringBuilder sb = new StringBuilder();
        sb.append("video=0&audio=0&event=on");
        if (eventTopicsToSubscribe == null || eventTopicsToSubscribe.stream().count() == 0L) {
            throw new NoEventTopicsDefinedException(LEX.getText("noEventTopicsDefined"));
        }
        sb.append("&eventtopic=");
        for (int i = 0; i < eventTopicsToSubscribe.size(); ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(eventTopicsToSubscribe.get(i)).append("//.");
        }
        return sb.toString();
    }

    public static void subscribeForVideoMotionDetection(BAxisVideoCamera avCamera, List<String> eventTopics) {
        try {
            String passKey = avCamera.getUpdatedVideoKey();
            BAxisUserNameAndPassword usernameAndPassword = new BAxisUserNameAndPassword();
            usernameAndPassword.setUsername(avCamera.getCredentials().getUsername());
            usernameAndPassword.setPassword(BPassword.make((String)passKey));
            String queryString = AxisSubscribeVideoMotionDetection.queryStringForEventTopicsToSubscribe(eventTopics);
            avCamera.setEventListToSubscribe(queryString);
            AxisSubscribeVideoMotionDetectionRequest videoReq = new AxisSubscribeVideoMotionDetectionRequest(new BIpAddress(((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)avCamera.getVideoDeviceId()).getWebPort()), avCamera, null);
            videoReq.setUsernamePassword(usernameAndPassword);
            videoReq.addBasicAuthorization(avCamera.getRtspUsername(), passKey);
            videoReq.setVideoSource((BIVideoSource)avCamera);
            avCamera.setMotionDetectionVideoStream(videoReq.makeVideoStream());
            Runnable workerThread = () -> {
                axisLog.log(Level.FINE, "Creating Worker Thread to process motion detection events on RTP stream");
                if (avCamera.getMotionDetectionVideoStream() == null) {
                    ScheduledExecutorService scheduledExecutorService = avCamera.getMotionDetectionEventExecutorService();
                    if (null != scheduledExecutorService) {
                        scheduledExecutorService.shutdown();
                    }
                } else {
                    RtpStream inputStream = (RtpStream)avCamera.getMotionDetectionVideoStream().getInputStream();
                    try {
                        while (inputStream.size() > 0) {
                            RtpPacket rtpPacket = inputStream.readPacket();
                            if (rtpPacket.payload_type != 98 || !rtpPacket.marker) continue;
                            StringBuilder sb = AxisSubscribeVideoMotionDetection.addNewLineAtEnd(rtpPacket.payload);
                            videoReq.processRtspStream(sb.toString());
                        }
                    }
                    catch (Exception e) {
                        axisLog.log(Level.SEVERE, "Exception raised while processing motion detection events on RTP stream", e);
                    }
                }
            };
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
            service.scheduleAtFixedRate(workerThread, 0L, 2L, TimeUnit.SECONDS);
            avCamera.setMotionDetectionEventExecutorService(service);
        }
        catch (NoEventTopicsDefinedException e) {
            axisLog.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void unsubscribeForVideoMotionDetection(BAxisVideoCamera avCamera) {
        try {
            axisLog.log(Level.FINE, "Unsubscribe for motion detection alarms... ");
            avCamera.getMotionDetectionVideoStream().closeVideoStream();
        }
        catch (IOException e) {
            axisLog.log(Level.SEVERE, "Exception raised while unsubscribe for video motion detection events", e);
        }
        avCamera.setMotionDetectionVideoStream(null);
    }

    public static class NoEventTopicsDefinedException
    extends Exception {
        private final String description;

        public NoEventTopicsDefinedException(String description) {
            this.description = description;
        }

        @Override
        public String toString() {
            return "NoEventTopicsDefinedException (" + this.description + ')';
        }
    }

    public static class InvalidResponseException
    extends Exception {
        private final String description;

        public InvalidResponseException(String description) {
            this.description = description;
        }

        @Override
        public String toString() {
            return "Invalid response (" + this.description + ")";
        }
    }
}

