/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oauth2.clientcredentials;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.oauth2.OAuth2AuthorizationException;
import com.tridium.oauth2.OAuth2AuthorizationRequest;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadata;
import com.tridium.oauth2.clientcredentials.OAuth2ClientCredentialType;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;

public class OAuth2ClientCredentialsGrantRequest
extends OAuth2AuthorizationRequest {
    private final ClientAuthentication clientAuthentication;
    private final X509Certificate clientCertificate;
    private final PrivateKey clientCertificatePrivateKey;
    private final OAuth2ClientCredentialType credentialType;

    public OAuth2ClientCredentialsGrantRequest(OAuth2AuthorizationServerMetadata authServerMetadata, String clientId, char[] clientSecret, String[] scope) {
        super(authServerMetadata, clientId, scope);
        if (clientSecret == null) {
            throw new IllegalArgumentException("Client secret must be not be null");
        }
        this.credentialType = OAuth2ClientCredentialType.CLIENT_SECRET;
        this.clientAuthentication = new ClientSecretPost(new ClientID(this.clientId), new Secret(new String(clientSecret)));
        this.clientCertificate = null;
        this.clientCertificatePrivateKey = null;
    }

    public OAuth2ClientCredentialsGrantRequest(OAuth2AuthorizationServerMetadata authServerMetadata, String clientId, X509Certificate clientCertificate, PrivateKey clientCertificatePrivateKey, String[] scope) {
        super(authServerMetadata, clientId, scope);
        if (clientCertificate == null || clientCertificatePrivateKey == null) {
            throw new IllegalArgumentException("Client Certificate and Private Key must not be null");
        }
        this.clientCertificate = clientCertificate;
        this.clientCertificatePrivateKey = clientCertificatePrivateKey;
        this.credentialType = OAuth2ClientCredentialType.CLIENT_CERTIFICATE;
        this.clientAuthentication = null;
    }

    @Override
    protected HTTPRequest toHTTPRequest() {
        TokenRequest request;
        switch (this.credentialType) {
            case CLIENT_SECRET: {
                if (this.clientAuthentication == null) {
                    throw new IllegalStateException("Client Authentication must not be null");
                }
                request = this.createClientSecretTokenRequest();
                break;
            }
            case CLIENT_CERTIFICATE: {
                request = this.createClientCertificateTokenRequest();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Credential Type!");
            }
        }
        return request.toHTTPRequest();
    }

    private TokenRequest createClientSecretTokenRequest() {
        return new TokenRequest(this.authServerMetadata.getTokenEndpoint(), this.clientAuthentication, (AuthorizationGrant)new ClientCredentialsGrant(), this.scope != null ? new Scope(this.scope) : null);
    }

    private TokenRequest createClientCertificateTokenRequest() {
        JWTAssertionDetails claimSet = new JWTAssertionDetails(new Issuer(this.clientId), new Subject(this.clientId), Collections.singletonList(new Audience(this.authServerMetadata.getTokenEndpoint())), new Date(new Date().getTime() + 300000L), null, new Date(), new JWTID(), null);
        String certificateFingerprint = NX509Certificate.make((X509Certificate)this.clientCertificate).getSHA1Fingerprint();
        BigInteger cert = new BigInteger(certificateFingerprint.replace(":", ""), 16);
        SignedJWT jwtSecuredAuthorizationRequest = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).x509CertThumbprint(Base64URL.encode(cert)).build(), claimSet.toJWTClaimsSet());
        try {
            jwtSecuredAuthorizationRequest.sign(new RSASSASigner(this.clientCertificatePrivateKey));
        }
        catch (JOSEException e) {
            throw new OAuth2AuthorizationException("An error occurred while signing JWS!");
        }
        return new TokenRequest(this.authServerMetadata.getTokenEndpoint(), new PrivateKeyJWT(jwtSecuredAuthorizationRequest), (AuthorizationGrant)new ClientCredentialsGrant(), this.scope != null ? new Scope(this.scope) : null);
    }

    public OAuth2ClientCredentialType getCredentialType() {
        return this.credentialType;
    }
}

