/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.ui.BMbusSecondaryAddressFE;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
public final class BMbusSecondaryKnownAddressFE
extends BMbusSecondaryAddressFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusSecondaryKnownAddressFE.class);
    private final BTextField secondaryAddress = new BTextField();
    private final BLabel addressText = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.SecondaryAddressRequired", "Secondary Address (*): "), BHalign.left);
    private final BLabel optimiseSpeeds = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.SecondaryOptimiseCommSpeed", "Optimise Comm Speed"), BHalign.left);
    private final BCheckBox optimiseSpeedsCheckbox = new BCheckBox();
    private final BLabel requiredLabel = new BLabel(MbusToolkit.lex.get("SecondaryAddressWizard.RequiredField", "(*) REQUIRED FIELD"), BHalign.left);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusSecondaryKnownAddressFE() {
        super(false);
        this.deviceIdEditor.loadValue((BObject)BMbusDeviceTypeId.reserved);
        BGridPane pane = new BGridPane();
        pane.setColumnAlign(BHalign.left);
        pane.setColumnGap(4.0);
        pane.add(null, (BValue)this.addressText);
        pane.add(null, (BValue)this.secondaryAddress);
        pane.add(null, (BValue)this.manuText);
        pane.add(null, (BValue)this.manuField);
        pane.add(null, (BValue)this.devIdText);
        pane.add(null, (BValue)this.deviceIdEditor);
        pane.add(null, (BValue)this.versionText);
        pane.add(null, (BValue)this.versionField);
        pane.add(null, (BValue)this.optimiseSpeeds);
        pane.add(null, (BValue)this.optimiseSpeedsCheckbox);
        pane.add(null, (BValue)this.requiredLabel);
        this.linkTo((BComponent)this.secondaryAddress, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.manuField, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.versionField, (Slot)BTextEditor.textModified, (Slot)setModified);
        if (this.deviceIdEditor.getTopic(BTextEditor.textModified.getName()) != null) {
            this.linkTo((BComponent)this.deviceIdEditor, (Slot)BTextEditor.textModified, (Slot)setModified);
        }
        this.setContent((BWidget)pane);
    }

    @Override
    public void doLoadValue(BObject value, Context context) throws Exception {
        this.secondaryAddress.setEditable(!this.isReadonly());
        BMbusSecondaryAddressFilters filters = (BMbusSecondaryAddressFilters)value;
        this.secondaryAddress.setText(filters.getSecondaryAddresses());
        this.optimiseSpeedsCheckbox.setSelected(filters.getOptimiseSpeeds());
        super.doLoadValue(value, context);
    }

    private void validateAddressEntries() throws CannotSaveException {
        String enteredText = this.secondaryAddress.getText();
        char delimiter = ',';
        String[] addressesEntered = TextUtil.splitAndTrim((String)enteredText, (char)delimiter);
        boolean validatedAddress = false;
        for (int i = 0; i < addressesEntered.length; ++i) {
            String currentStr = addressesEntered[i];
            int rangeMarkerIndex = -1;
            rangeMarkerIndex = currentStr.indexOf(45);
            if (rangeMarkerIndex == -1) {
                BMbusSecondaryKnownAddressFE.validSecondaryAddress(currentStr, true);
            } else {
                String[] addressRange = TextUtil.splitAndTrim((String)currentStr, (char)'-');
                if (addressRange.length != 2) {
                    throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.RangeAddressInvalid", new Object[]{currentStr}));
                }
                BMbusSecondaryKnownAddressFE.validSecondaryAddress(addressRange[0], false);
                BMbusSecondaryKnownAddressFE.validSecondaryAddress(addressRange[1], false);
                long addr1 = Long.parseLong(addressRange[0]);
                long addr2 = Long.parseLong(addressRange[1]);
                if (addr2 < addr1) {
                    throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.StartAfterEndInRange", new Object[]{currentStr}));
                }
            }
            validatedAddress = true;
        }
        if (!validatedAddress) {
            throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.NoValidAddressEntered"));
        }
    }

    private static void validSecondaryAddress(String address, boolean wildcardsAllowed) throws CannotSaveException {
        if (address.length() < 8) {
            throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.SecondaryAddressReqCharsWrong", new Object[]{String.valueOf(address.length()), address}));
        }
        for (int charNo = 0; charNo < address.length(); ++charNo) {
            char ch = address.charAt(charNo);
            if (ch >= '0' && ch <= '9' || wildcardsAllowed && ch == 'F') continue;
            throw new CannotSaveException(lex.getText("mbusSecondaryKnownAddressFE.InvalidCharacterForAddress", new Object[]{String.valueOf(ch), address}));
        }
    }

    @Override
    public BObject doSaveValue(BObject value, Context context) throws Exception {
        this.validateAddressEntries();
        BMbusSecondaryAddressFilters r = (BMbusSecondaryAddressFilters)super.doSaveValue(value, context);
        r.setSecondaryAddresses(this.secondaryAddress.getText());
        r.setOptimiseSpeeds(this.optimiseSpeedsCheckbox.getSelected());
        return r;
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.secondaryAddress.setEditable(!readonly);
        this.optimiseSpeedsCheckbox.setEnabled(!readonly);
        super.doSetReadonly(readonly);
    }
}

