/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.BMbusNetwork;
import com.tridium.mbus.ui.BAbstractDualDropDownFE;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BIStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraAction(name="parentDropDownChanged", override=true)
public class BDualComponentOrdFE
extends BAbstractDualDropDownFE {
    @Generated
    public static final Action parentDropDownChanged = BDualComponentOrdFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDualComponentOrdFE.class);
    private BOrd currentOrd = BOrd.NULL;
    private boolean selectFirstItemInList = false;
    private String exPredicate = "";
    private final Sub sub = new Sub();
    public static final String PARENT_TYPE_FACETS_KEY = "parentType";
    public static final String CHILD_TYPE_FACETS_KEY = "childType";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDualComponentOrdFE() {
        this.parentDropDown.getList().setRenderer((ListRenderer)new Renderer());
        this.childDropDown.getList().setRenderer((ListRenderer)new Renderer());
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        block11: {
            super.doLoadValue(value, cx);
            if (BWbShell.getWbShell((BWidget)this) == null) {
                return;
            }
            this.currentOrd = (BOrd)value;
            try {
                BOrd activeOrd = BWbShell.getWbShell((BWidget)this).getActiveOrd();
                StringBuilder buff = new StringBuilder();
                buff.append(this.getMbusNetwork().getSlotPathOrd().toString());
                buff.append("|bql:select handleOrd, name from ");
                buff.append(this.getChildType(cx).toString());
                buff.append(" where parent.type = '");
                buff.append(this.getParentType(cx).toString());
                buff.append("'");
                if (this.exPredicate.length() > 0) {
                    buff.append(" and (");
                    buff.append(this.exPredicate);
                    buff.append(")");
                }
                buff.append(" order by parent.handleOrd");
                BITable result = (BITable)BOrd.make((BOrd)activeOrd, (String)buff.toString()).get();
                if (result == null) break block11;
                ColumnList columns = result.getColumns();
                Column ordColumn = columns.get(0);
                TableCursor c = result.cursor();
                Array ordArray = new Array(BOrd.class);
                while (c.next()) {
                    BOrd newOrd = BOrd.make((BOrd)activeOrd, (String)c.cell(ordColumn).toString()).normalize();
                    ordArray.add((Object)newOrd);
                }
                BatchResolve batch = new BatchResolve((BOrd[])ordArray.trim());
                batch.resolve((BObject)BLocalHost.INSTANCE);
                BComponent[] comps = batch.getTargetComponents();
                HashMap<BComplex, Array> compHash = new HashMap<BComplex, Array>();
                for (int i = 0; i < comps.length; ++i) {
                    Array o = (Array)compHash.get(comps[i].getParent());
                    if (o == null) {
                        o = new Array(BComponent.class);
                    }
                    o.add((Object)comps[i]);
                    compHash.put(comps[i].getParent(), o);
                }
                Object[] keys = compHash.keySet().toArray();
                try {
                    Comparator<Object> cmp = new Comparator<Object>(){

                        @Override
                        public int compare(Object v1, Object v2) {
                            return ((BComponent)v1).getName().compareTo(((BComponent)v2).getName());
                        }
                    };
                    SortUtil.sort((Object[])keys, (Object[])keys, (Comparator)cmp);
                    for (int i = 0; i < keys.length; ++i) {
                        BComponent parent = (BComponent)keys[i];
                        parent.loadSlots();
                        this.sub.subscribe(parent);
                        Object[] children = (BComponent[])((Array)compHash.get(parent)).trim();
                        for (int j = 0; j < children.length; ++j) {
                            children[j].loadSlots();
                        }
                        SortUtil.sort((Object[])children, (Object[])children, (Comparator)cmp);
                        this.sub.subscribe((BComponent[])children, 0, null);
                        ParentComponentItem parComp = new ParentComponentItem(parent, (BComponent[])children);
                        this.parentDropDown.getList().addItem(parComp.getImage(), (Object)parComp);
                    }
                }
                catch (Exception e) {
                    this.sub.unsubscribeAll();
                }
                this.selectCurrentOrd();
            }
            catch (Exception e) {
                if (MbusToolkit.getLogger() == null) break block11;
                MbusToolkit.error((String)"Error could not load information in dual component field editor", (Throwable)e);
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        ComponentItem item = (ComponentItem)this.childDropDown.getList().getSelectedItem();
        this.currentOrd = item != null ? item.getComponent().getHandleOrd() : BOrd.NULL;
        return BOrd.make((String)this.currentOrd.toString());
    }

    private void selectCurrentOrd() {
        block10: {
            if (this.parentDropDown.getList().getItemCount() > 0) {
                try {
                    int newIndex = -1;
                    BList list = this.parentDropDown.getList();
                    BComponent comp = null;
                    if (this.currentOrd != null && !this.currentOrd.isNull()) {
                        comp = (BComponent)BOrd.make((BOrd)BWbShell.getWbShell((BWidget)this).getActiveOrd(), (BOrd)this.currentOrd).get();
                        BComponent parentComp = (BComponent)comp.getParent();
                        for (int i = 0; i < list.getItemCount(); ++i) {
                            if (!((ComponentItem)list.getItem(i)).getComponent().equals((Object)parentComp)) continue;
                            newIndex = i;
                            break;
                        }
                    }
                    if (this.selectFirstItemInList && newIndex == -1) {
                        newIndex = 0;
                        this.setModified();
                    }
                    if (newIndex > -1) {
                        list.setSelectedIndex(newIndex);
                        this.updateChildDropDown(comp);
                    }
                }
                catch (Exception e) {
                    if (MbusToolkit.getLogger() != null) {
                        MbusToolkit.error((String)"Could not resolve component for current Ord", (Throwable)e);
                    }
                    try {
                        this.parentDropDown.getList().setSelectedItem(null);
                    }
                    catch (Exception e2) {
                        if (MbusToolkit.getLogger() == null) break block10;
                        MbusToolkit.error((String)"Fatal error selecting no list argument", (Throwable)e2);
                    }
                }
            }
        }
    }

    @Override
    public void onParentDropDownChanged() {
        this.updateChildDropDown(null);
    }

    private void updateChildDropDown(BComponent comp) {
        block8: {
            try {
                BWidget parentWidget;
                this.childDropDown.getList().setSelectedItem(null);
                this.childDropDown.getList().removeAllItems();
                ParentComponentItem parentItem = (ParentComponentItem)this.parentDropDown.getList().getSelectedItem();
                if (parentItem != null) {
                    BComponent[] childComps = parentItem.getChildren();
                    int indexCount = 0;
                    int newIndex = 0;
                    for (int i = 0; i < childComps.length; ++i) {
                        if (comp != null && comp.equals((Object)childComps[i])) {
                            newIndex = indexCount;
                        }
                        ComponentItem childItem = new ComponentItem(childComps[i]);
                        this.childDropDown.getList().addItem(childItem.getImage(), (Object)childItem);
                        ++indexCount;
                    }
                    if (this.childDropDown.getList().getItemCount() > 0) {
                        this.childDropDown.getList().setSelectedIndex(newIndex);
                    }
                    if (this.parentDropDown.getList().getItemCount() == 1) {
                        this.hideParentDropDown();
                    }
                }
                if ((parentWidget = (BWidget)this.getParent()) != null) {
                    parentWidget.relayout();
                }
            }
            catch (Exception e) {
                if (MbusToolkit.getLogger() == null) break block8;
                MbusToolkit.error((String)"Error updating child drop down list", (Throwable)e);
            }
        }
    }

    public void setSelectFirstItem() {
        this.selectFirstItemInList = true;
    }

    public void setExtendedPredicate(String exPredicate) {
        this.exPredicate = exPredicate;
    }

    protected Type getParentType(Context cx) throws Exception {
        BString parentType;
        if (cx != null && (parentType = (BString)cx.getFacet(PARENT_TYPE_FACETS_KEY)) != null) {
            return Sys.getType((String)parentType.getString());
        }
        throw new UnsupportedOperationException("Parent type not implemented in facets");
    }

    protected Type getChildType(Context cx) throws Exception {
        BString childType;
        if (cx != null && (childType = (BString)cx.getFacet(CHILD_TYPE_FACETS_KEY)) != null) {
            return Sys.getType((String)childType.getString());
        }
        throw new UnsupportedOperationException("Child type not implemented in facets");
    }

    private BMbusNetwork getMbusNetwork() {
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            return null;
        }
        return BDualComponentOrdFE.findNetwork(shell.getActiveOrdTarget().getComponent());
    }

    private static BMbusNetwork findNetwork(BComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof BMbusNetwork) {
            return (BMbusNetwork)comp;
        }
        return BDualComponentOrdFE.findNetwork((BComponent)comp.getParent());
    }

    private static class Sub
    extends Subscriber {
        private Sub() {
        }

        public void event(BComponentEvent event) {
        }
    }

    private static class Renderer
    extends ListRenderer {
        private Renderer() {
        }

        public BBrush getBackground(ListRenderer.Item item) {
            ComponentItem compItem = (ComponentItem)item.value;
            if (compItem.getComponent() instanceof BIStatus) {
                BColor c = (BColor)((BIStatus)compItem.getComponent()).getStatus().getBackgroundColor((BSimple)BColor.black);
                if (c == BColor.black) {
                    return null;
                }
                return c.toBrush();
            }
            return null;
        }

        public BBrush getForeground(ListRenderer.Item item) {
            ComponentItem compItem = (ComponentItem)item.value;
            if (compItem.getComponent() instanceof BIStatus) {
                BColor c = (BColor)((BIStatus)compItem.getComponent()).getStatus().getForegroundColor((BSimple)BColor.black);
                return c.toBrush();
            }
            return super.getForeground(item);
        }
    }

    private static final class ParentComponentItem
    extends ComponentItem {
        private final BComponent[] children;

        ParentComponentItem(BComponent comp, BComponent[] children) {
            super(comp);
            this.children = children;
        }

        BComponent[] getChildren() {
            return this.children;
        }
    }

    private static class ComponentItem {
        private BComponent comp = null;

        ComponentItem(BComponent comp) {
            this.comp = comp;
        }

        BComponent getComponent() {
            return this.comp;
        }

        public String toString() {
            if (this.comp instanceof BIStatus) {
                StringBuilder buff = new StringBuilder();
                buff.append(this.comp.getDisplayName(null));
                buff.append(" {");
                buff.append(((BIStatus)this.comp).getStatus().flagsToString(null));
                buff.append("}");
                return buff.toString();
            }
            return this.comp.getDisplayName(null);
        }

        public BImage getImage() {
            BIStatus s;
            if (this.comp instanceof BIStatus && (s = (BIStatus)this.comp).getStatus().isDisabled()) {
                return BImage.make((BIcon)this.comp.getIcon()).getDisabledImage();
            }
            return BImage.make((BIcon)this.comp.getIcon());
        }
    }
}

