/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    public long handle;
    PointF currentPoint = new PointF();
    PointF startPoint = new PointF();

    public Path(Device device) {
        super(device);
        this.device.checkGDIP();
        this.handle = Gdip.GraphicsPath_new((int)0);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        flatness = Math.max(0.0f, flatness);
        this.handle = Gdip.GraphicsPath_Clone((long)path.handle);
        if (flatness != 0.0f) {
            Gdip.GraphicsPath_Flatten((long)this.handle, (long)0L, (float)flatness);
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, PathData data) {
        this(device);
        if (data == null) {
            SWT.error(4);
        }
        this.init(data);
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        x = DPIUtil.autoScaleUp((float)x);
        y = DPIUtil.autoScaleUp((float)y);
        width = DPIUtil.autoScaleUp((float)width);
        height = DPIUtil.autoScaleUp((float)height);
        this.addArcInPixels(x, y, width, height, startAngle, arcAngle);
    }

    void addArcInPixels(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0.0f) {
            x += width;
            width = -width;
        }
        if (height < 0.0f) {
            y += height;
            height = -height;
        }
        if (width == 0.0f || height == 0.0f || arcAngle == 0.0f) {
            return;
        }
        if (width == height) {
            Gdip.GraphicsPath_AddArc((long)this.handle, (float)x, (float)y, (float)width, (float)height, (float)(-startAngle), (float)(-arcAngle));
        } else {
            long matrix;
            long path = Gdip.GraphicsPath_new((int)0);
            if (path == 0L) {
                SWT.error(2);
            }
            if ((matrix = Gdip.Matrix_new((float)width, (float)0.0f, (float)0.0f, (float)height, (float)x, (float)y)) == 0L) {
                SWT.error(2);
            }
            Gdip.GraphicsPath_AddArc((long)path, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)(-startAngle), (float)(-arcAngle));
            Gdip.GraphicsPath_Transform((long)path, (long)matrix);
            Gdip.GraphicsPath_AddPath((long)this.handle, (long)path, (boolean)true);
            Gdip.Matrix_delete((long)matrix);
            Gdip.GraphicsPath_delete((long)path);
        }
        Gdip.GraphicsPath_GetLastPoint((long)this.handle, (PointF)this.currentPoint);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath((long)this.handle, (long)path.handle, (boolean)false);
        this.currentPoint.X = path.currentPoint.X;
        this.currentPoint.Y = path.currentPoint.Y;
    }

    public void addRectangle(float x, float y, float width, float height) {
        x = DPIUtil.autoScaleUp((float)x);
        y = DPIUtil.autoScaleUp((float)y);
        width = DPIUtil.autoScaleUp((float)width);
        height = DPIUtil.autoScaleUp((float)height);
        this.addRectangleInPixels(x, y, width, height);
    }

    void addRectangleInPixels(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rect = new RectF();
        rect.X = x;
        rect.Y = y;
        rect.Width = width;
        rect.Height = height;
        Gdip.GraphicsPath_AddRectangle((long)this.handle, (RectF)rect);
        this.currentPoint.X = x;
        this.currentPoint.Y = y;
    }

    public void addString(String string, float x, float y, Font font) {
        x = DPIUtil.autoScaleUp((float)x);
        y = DPIUtil.autoScaleUp((float)y);
        this.addStringInPixels(string, x, y, font);
    }

    void addStringInPixels(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        char[] buffer = string.toCharArray();
        long hDC = this.device.internal_new_GC(null);
        long[] family = new long[1];
        long gdipFont = GC.createGdipFont(hDC, font.handle, 0L, this.device.fontCollection, family, null);
        PointF point = new PointF();
        point.X = x - Gdip.Font_GetSize((long)gdipFont) / 6.0f;
        point.Y = y;
        int style = Gdip.Font_GetStyle((long)gdipFont);
        float size = Gdip.Font_GetSize((long)gdipFont);
        Gdip.GraphicsPath_AddString((long)this.handle, (char[])buffer, (int)buffer.length, (long)family[0], (int)style, (float)size, (PointF)point, (long)0L);
        Gdip.GraphicsPath_GetLastPoint((long)this.handle, (PointF)this.currentPoint);
        Gdip.FontFamily_delete((long)family[0]);
        Gdip.Font_delete((long)gdipFont);
        this.device.internal_dispose_GC(hDC, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure((long)this.handle);
        this.currentPoint.X = this.startPoint.X;
        this.currentPoint.Y = this.startPoint.Y;
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        x = DPIUtil.autoScaleUp((float)x);
        y = DPIUtil.autoScaleUp((float)y);
        return this.containsInPixels(x, y, gc, outline);
    }

    boolean containsInPixels(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.initGdip();
        gc.checkGC(120);
        int mode = OS.GetPolyFillMode((long)gc.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode((long)this.handle, (int)mode);
        if (outline) {
            return Gdip.GraphicsPath_IsOutlineVisible((long)this.handle, (float)x, (float)y, (long)gc.data.gdipPen, (long)gc.data.gdipGraphics);
        }
        return Gdip.GraphicsPath_IsVisible((long)this.handle, (float)x, (float)y, (long)gc.data.gdipGraphics);
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        cx1 = DPIUtil.autoScaleUp((float)cx1);
        cy1 = DPIUtil.autoScaleUp((float)cy1);
        cx2 = DPIUtil.autoScaleUp((float)cx2);
        cy2 = DPIUtil.autoScaleUp((float)cy2);
        x = DPIUtil.autoScaleUp((float)x);
        y = DPIUtil.autoScaleUp((float)y);
        this.cubicToInPixels(cx1, cy1, cx2, cy2, x, y);
    }

    void cubicToInPixels(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier((long)this.handle, (float)this.currentPoint.X, (float)this.currentPoint.Y, (float)cx1, (float)cy1, (float)cx2, (float)cy2, (float)x, (float)y);
        Gdip.GraphicsPath_GetLastPoint((long)this.handle, (PointF)this.currentPoint);
    }

    @Override
    void destroy() {
        Gdip.GraphicsPath_delete((long)this.handle);
        this.handle = 0L;
    }

    public void getBounds(float[] bounds) {
        if (bounds == null) {
            SWT.error(4);
        }
        this.getBoundsInPixels(bounds);
        bounds = DPIUtil.autoScaleDown((float[])bounds);
    }

    void getBoundsInPixels(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        RectF rect = new RectF();
        Gdip.GraphicsPath_GetBounds((long)this.handle, (RectF)rect, (long)0L, (long)0L);
        bounds[0] = rect.X;
        bounds[1] = rect.Y;
        bounds[2] = rect.Width;
        bounds[3] = rect.Height;
    }

    public void getCurrentPoint(float[] point) {
        if (point == null) {
            SWT.error(4);
        }
        this.getCurrentPointInPixels(point);
        point = DPIUtil.autoScaleDown((float[])point);
    }

    void getCurrentPointInPixels(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        point[0] = this.currentPoint.X;
        point[1] = this.currentPoint.Y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        PathData result = this.getPathDataInPixels();
        result.points = DPIUtil.autoScaleDown((float[])result.points);
        return result;
    }

    PathData getPathDataInPixels() {
        int count = Gdip.GraphicsPath_GetPointCount((long)this.handle);
        byte[] gdipTypes = new byte[count];
        float[] points = new float[count * 2];
        Gdip.GraphicsPath_GetPathTypes((long)this.handle, (byte[])gdipTypes, (int)count);
        Gdip.GraphicsPath_GetPathPoints((long)this.handle, (float[])points, (int)count);
        byte[] types = new byte[count * 2];
        int index = 0;
        int typesIndex = 0;
        while (index < count) {
            byte type = gdipTypes[index];
            boolean close = false;
            switch (type & 7) {
                case 0: {
                    types[typesIndex++] = 1;
                    close = (type & 0x80) != 0;
                    ++index;
                    break;
                }
                case 1: {
                    types[typesIndex++] = 2;
                    close = (type & 0x80) != 0;
                    ++index;
                    break;
                }
                case 3: {
                    types[typesIndex++] = 4;
                    close = (gdipTypes[index + 2] & 0x80) != 0;
                    index += 3;
                    break;
                }
                default: {
                    ++index;
                }
            }
            if (!close) continue;
            types[typesIndex++] = 5;
        }
        if (typesIndex != types.length) {
            byte[] newTypes = new byte[typesIndex];
            System.arraycopy(types, 0, newTypes, 0, typesIndex);
            types = newTypes;
        }
        PathData result = new PathData();
        result.types = types;
        result.points = points;
        return result;
    }

    public void lineTo(float x, float y) {
        this.lineToInPixels(DPIUtil.autoScaleUp((float)x), DPIUtil.autoScaleUp((float)y));
    }

    void lineToInPixels(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine((long)this.handle, (float)this.currentPoint.X, (float)this.currentPoint.Y, (float)x, (float)y);
        Gdip.GraphicsPath_GetLastPoint((long)this.handle, (PointF)this.currentPoint);
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public void moveTo(float x, float y) {
        this.moveToInPixels(DPIUtil.autoScaleUp((float)x), DPIUtil.autoScaleUp((float)y));
    }

    void moveToInPixels(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_StartFigure((long)this.handle);
        this.currentPoint.X = this.startPoint.X = x;
        this.currentPoint.Y = this.startPoint.Y = y;
    }

    public void quadTo(float cx, float cy, float x, float y) {
        cx = DPIUtil.autoScaleUp((float)cx);
        cy = DPIUtil.autoScaleUp((float)cy);
        x = DPIUtil.autoScaleUp((float)x);
        y = DPIUtil.autoScaleUp((float)y);
        this.quadToInPixels(cx, cy, x, y);
    }

    void quadToInPixels(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float cx1 = this.currentPoint.X + 2.0f * (cx - this.currentPoint.X) / 3.0f;
        float cy1 = this.currentPoint.Y + 2.0f * (cy - this.currentPoint.Y) / 3.0f;
        float cx2 = cx1 + (x - this.currentPoint.X) / 3.0f;
        float cy2 = cy1 + (y - this.currentPoint.Y) / 3.0f;
        Gdip.GraphicsPath_AddBezier((long)this.handle, (float)this.currentPoint.X, (float)this.currentPoint.Y, (float)cx1, (float)cy1, (float)cx2, (float)cy2, (float)x, (float)y);
        Gdip.GraphicsPath_GetLastPoint((long)this.handle, (PointF)this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

